<?php
session_start();
include "config.php";

// Redirect if user is not logged in
if (!isset($_SESSION['user'])) {
    echo '<script>window.location.href = "index.php";</script>';
    exit();
}

// Get user details from session
$user = $_SESSION['user'];

//echo "Welcome " . htmlspecialchars($user['name'] ?? 'User') . "<br>";
//echo "Email: " . htmlspecialchars($user['email'] ?? '') . "<br>";
//echo "Phone: " . htmlspecialchars($user['phone'] ?? '') . "<br>";
$pid = $user['pid'];
// Fetch all users
$kycQuery = "SELECT * FROM `kyc` WHERE `policestation_id`='$pid' ";
$resultKyc = mysqli_query($con, $kycQuery);


?>

<!DOCTYPE html>
<html lang="en">

<head>
    <title>User</title>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <!-- Main CSS-->
    <link rel="stylesheet" type="text/css" href="css/main.css">
    <!-- Font-icon css-->
    <link rel="stylesheet" type="text/css"
        href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css">


</head>

<body class="app sidebar-mini">
    <?php include "header.php" ?>
    <!-- Sidebar menu-->
    <div class="app-sidebar__overlay" data-toggle="sidebar"></div>
    <aside class="app-sidebar">
        <?php include "./common/name.php" ?>

        <ul class="app-menu">

            <li><a class="app-menu__item active" href="main.php"><i class="app-menu__icon bi bi-speedometer"></i><span
                        class="app-menu__label">Dashboard</span></a>
            </li>

            <li class="treeview"><a class="app-menu__item" data-toggle="treeview"><i
                        class="app-menu__icon bi bi-laptop"></i><span class="app-menu__label">Bank</span><i
                        class="treeview-indicator bi bi-chevron-right"></i></a>
                <ul class="treeview-menu">
                    <li><a class="treeview-item" href="kyc_form.php"><i class="icon bi bi-circle-fill"></i>KYC</a> </li>
                    <li><a class="treeview-item" href="lien_amount.php"><i class="icon bi bi-circle-fill"></i>
                            LIAN AMOUNT</a></li>
                    <li><a class="treeview-item" href=""><i class="icon bi bi-circle-fill"></i> BOND</a> </li>
                    <li><a class="treeview-item" href=""><i class="icon bi bi-circle-fill"></i> Opinion</a> </li>
                    <li><a class="treeview-item" href=""><i class="icon bi bi-circle-fill"></i> COMPLY ORDER</a> </li>
                    <li><a class="treeview-item" href=""><i class="icon bi bi-circle-fill"></i> CCTV</a> </li>
                </ul>
            </li>


        </ul>

    </aside>


    <main class="app-content">
        <div class="app-title">
            <div>
                <h1><i class="bi bi-table"></i> Data Table</h1>

            </div>
            <ul class="app-breadcrumb breadcrumb side">
                <li class="breadcrumb-item"><i class="bi bi-house-door fs-6"></i></li>
                <li class="breadcrumb-item">Tables</li>
                <li class="breadcrumb-item active"><a href="#">Data Table</a></li>
            </ul>
        </div>
        <div class="col-md-12">
            <div class="tile">
                <div class="tile-title-w-btn">
                    <h3 class="title">KYC</h3>
                    <p>
                        <a href="add_kyc.php" class="btn btn-primary icon-btn">
                            <i class="bi bi-plus-square me-2"></i>Add KYC
                        </a>
                    </p>

                </div>

            </div>
        </div>

        <div class="row">
            <div class="col-md-12">
                <div class="tile">
                    <div class="tile-body">
                        <div class="table-responsive">
                            <table class="table table-hover table-bordered" id="sampleTable">
                                <thead>
                                    <tr>
                                        <th>ID</th>
                                        <th>Acknowledgement</th>
                                        <th>Complaint Name</th>
                                        <th>Police Station</th>
                                        <th>Police Name</th>
                                        <th>Subject</th>
                                        <th>Notice</th>
                                        <th>View</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php if (mysqli_num_rows($resultKyc) > 0): ?>
                                        <?php while ($row = mysqli_fetch_assoc($resultKyc)): ?>
                                            <tr>
                                                <td><?= htmlspecialchars($row['id']) ?></td>
                                                <td><?= htmlspecialchars($row['acknowledgement_no']) ?></td>
                                                <td><?= htmlspecialchars($row['complainant_name']) ?></td>
                                                <td>
                                                    <?php
                                                    $id = (int) $row['policestation_id'];
                                                    $result0 = $con->query("SELECT * FROM `policestation` WHERE id = $id");
                                                    if ($result0 && $result0->num_rows > 0) {
                                                        $data = $result0->fetch_assoc();
                                                        echo htmlspecialchars($data['p_name']);
                                                    } else {
                                                        echo "Name not found";
                                                    }
                                                    ?>
                                                </td>
                                                <td>
                                                    <?php
                                                    $id = (int) $row['police_id'];
                                                    $result0 = $con->query("SELECT * FROM `police` WHERE id = $id");
                                                    if ($result0 && $result0->num_rows > 0) {
                                                        $data = $result0->fetch_assoc();
                                                        echo htmlspecialchars($data['i_name']);
                                                    } else {
                                                        echo "Name not found";
                                                    }
                                                    ?>
                                                <td>
                                                    <?php
                                                    $id = (int) $row['subject_id'];
                                                    $result0 = $con->query("SELECT * FROM `subject` WHERE id = $id");
                                                    if ($result0 && $result0->num_rows > 0) {
                                                        $data = $result0->fetch_assoc();
                                                        echo htmlspecialchars($data['s_name']);
                                                    } else {
                                                        echo "Name not found";
                                                    }
                                                    ?>
                                                <td>
                                                    <?php
                                                    $id = (int) $row['notice_id'];
                                                    $result0 = $con->query("SELECT * FROM `notice` WHERE id = $id");
                                                    if ($result0 && $result0->num_rows > 0) {
                                                        $data = $result0->fetch_assoc();
                                                        echo htmlspecialchars($data['n_name']);
                                                    } else {
                                                        echo "Name not found";
                                                    }
                                                    ?>
                                                </td>
                                                <td>
                                                    <a href="viewkyc.php?kycid=<?= urlencode($row['id']) ?>">
                                                        <button type="button" class="btn btn-primary btn-sm">View</button>
                                                    </a>
                                                </td>
                                            </tr>
                                        <?php endwhile; ?>
                                    <?php else: ?>
                                        <tr>
                                            <td colspan="8" class="text-center">No users found</td>
                                        </tr>
                                    <?php endif; ?>

                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>


            <!-- Add User Modal -->
            <div class="modal fade" id="addUserModal" tabindex="-1" aria-labelledby="addUserModalLabel"
                aria-hidden="true">
                <div class="modal-dialog">
                    <form method="POST" action="add_user.php">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h5 class="modal-title">Add New User</h5>
                                <button type="button" class="btn-close" data-bs-dismiss="modal"
                                    aria-label="Close"></button>
                            </div>
                            <div class="modal-body">

                                <div class="mb-3">
                                    <label class="form-label">Select Police ID</label>
                                    <select class="form-control" name="pid" required>
                                        <option value="">-- Select Police Station ID --</option>
                                        <?php while ($row = $policeresult->fetch_assoc()): ?>
                                            <option value="<?= $row['id'] ?>">
                                                <?= $row['p_name'] ?>
                                            </option>
                                        <?php endwhile; ?>
                                    </select>
                                </div>

                                <div class="mb-3">
                                    <label class="form-label">Name</label>
                                    <input type="text" class="form-control" name="name" required />
                                </div>
                                <div class="mb-3">
                                    <label class="form-label">Email</label>
                                    <input type="email" class="form-control" name="email" required />
                                </div>
                                <div class="mb-3">
                                    <label class="form-label">Password</label>
                                    <input type="text" class="form-control" name="password" required />
                                </div>
                            </div>
                            <div class="modal-footer">
                                <button type="submit" class="btn btn-primary">Add User</button>
                                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>




        </div>
    </main>
    <!-- Essential javascripts for application to work-->

    <script src="js/jquery-3.7.0.min.js"></script>
    <script src="js/bootstrap.min.js"></script>
    <script src="js/main.js"></script>
    <link rel="stylesheet" href="https://cdn.datatables.net/v/bs5/dt-1.13.4/datatables.min.css">
    <!-- Data table plugin-->
    <script type="text/javascript" src="js/plugins/jquery.dataTables.min.js"></script>
    <script type="text/javascript" src="js/plugins/dataTables.bootstrap.min.js"></script>
    <script type="text/javascript">
        $('#sampleTable').DataTable();
    </script>

    <script>
        function openUpdateModal(id, pid, name, email, password) {
            document.getElementById('updateId').value = id;
            document.getElementById('updatePid').value = pid;
            document.getElementById('updateName').value = name;
            document.getElementById('updateEmail').value = email;
            //document.getElementById('updatePassword').value = "";

            var modal = new bootstrap.Modal(document.getElementById('updateModal'));
            modal.show();
        }


        function openDeleteModal(id, name, email, password) {
            document.getElementById('deleteId').value = id;
            document.getElementById('deleteUserName').textContent = name;

            var modal = new bootstrap.Modal(document.getElementById('deleteModal'));
            modal.show();
        }
    </script>
    <script type="text/javascript" src="https://cdn.jsdelivr.net/npm/echarts@5.4.3/dist/echarts.min.js"></script>



</body>

</html>