<?php
session_start();
include "config.php";

// Redirect if user is not logged in
if (!isset($_SESSION['user'])) {
    echo '<script>window.location.href = "index.php";</script>';
    exit();
}
$platform = $_GET['platform'] ?? '';

// Get user details from session
$user = $_SESSION['user'];
$pid = $user['pid'];
//echo "Welcome " . htmlspecialchars($user['name'] ?? 'User') . "<br>";
//echo "Email: " . htmlspecialchars($user['email'] ?? '') . "<br>";
//echo "Phone: " . htmlspecialchars($user['phone'] ?? '') . "<br>";

// $kycQuery = "
//     SELECT k.*, c.acknowlegement, c.complain_name, c.mobile
//     FROM kyc k
//     LEFT JOIN cyber_police c ON k.c_id = c.id
//     WHERE c.pid = '$pid' AND k.type = 'KYC'
//     ORDER BY k.id DESC
// ";
$facebookQuery = "
    SELECT 
        s.*, 
        c.acknowlegement, 
        c.complain_name, 
        c.mobile, 
        c.incident_date_time, 
        c.total_fraud_amount, 
        c.total_lien_amount, 
        c.atf, 
        c.status AS complain_status, 
        c.time_stamp
    FROM social_media AS s
    LEFT JOIN cyber_police AS c 
        ON s.c_id = c.id
    WHERE s.c_id != 0
      AND c.pid = '$pid'  AND s.type = '$platform'
    ORDER BY s.id DESC
";


//$facebookQuery = "SELECT * FROM `social_media` WHERE `type`='$platform' ORDER BY `id` DESC";
$resultFacebook = mysqli_query($con, $facebookQuery);

$platform_gujarati = '';

switch (strtolower($platform)) {
    case 'facebook':
        $platform_gujarati = 'ફેસબુક';
        break;
    case 'instagram':
        $platform_gujarati = 'ઇન્સ્ટાગ્રામ';
        break;
    case 'whatsapp':
        $platform_gujarati = 'વોટ્સએપ';
        break;
    case 'snapchat':
        $platform_gujarati = 'સ્નેપચેટ';
        break;
    case 'twitter-x':
    case 'twitter':
        $platform_gujarati = 'ટ્વિટર-એક્સ';
        break;
    case 'google':
        $platform_gujarati = 'ગૂગલ';
        break;
    default:
        $platform_gujarati = strtoupper($platform);
        break;
}


?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="icon" href="images/favicon.ico" sizes="32x32" type="image/x-icon">
    <title><?php echo strtoupper($platform); ?></title>

    <!-- Main CSS -->
    <link rel="stylesheet" type="text/css" href="css/main.css">

    <!-- Bootstrap Icons -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css">
</head>

<body class="app sidebar-mini">
    <!-- Navbar-->
    <?php include "header.php" ?>
    <!-- Sidebar menu-->
    <div class="app-sidebar__overlay" data-toggle="sidebar"></div>
    <aside class="app-sidebar">

        <?php include "./common/name.php" ?>

        <?php include 'sidebar.php' ?>


    </aside>

    <main class="app-content">
        <div class="app-title">
            <div>
                <h1><i class="bi bi-instagram"></i>
                    <?php echo strtoupper(string: $platform); ?>
                </h1>
            </div>
            <ul class="app-breadcrumb breadcrumb">
                <li class="breadcrumb-item"><i class="bi bi-house-door fs-6"></i></li>
                <li class="breadcrumb-item">Social Media</li>
                <li class="breadcrumb-item"><a href="#">
                        <?php echo strtoupper(string: $platform); ?>
                    </a></li>

            </ul>
        </div>


        <div class="tile-title-w-btn d-flex justify-content-end">

            <!-- Export to PDF -->
            <p class="mb-10">
                <a href="./export/socialmedia_report_pdf.php?platform=<?php echo urlencode($platform); ?>"
                    class="btn btn-primary icon-btn" target="_blank">
                    <i class="bi bi-file-earmark-pdf me-2"></i>Export to PDF
                </a>
            </p>

            <p class="mb-10"> &nbsp;&nbsp;</p>
            <!-- Export to Excel -->
            <p class="mb-10">
                <a href="./export/socialmedia_report_excel.php?platform=<?php echo urlencode($platform); ?>"
                    class="btn btn-primary icon-btn">
                    <i class="bi bi-file-earmark-excel me-2"></i>Export to Excel
                </a>
            </p>
            <p class="mb-10"> &nbsp;&nbsp;</p>

            <p class="mb-10">
                <a href="add_socialmedia.php?platform=<?php echo $platform; ?>" class="btn btn-primary icon-btn">
                    <i class="bi bi-plus-square me-2"></i>Add
                </a>
            </p>
        </div>

        <div class="row">
            <div class="col-md-12">
                <div class="tile">
                    <div class="tile-body">
                        <div class="table-responsive">
                            <table class="table table-hover table-bordered" id="sampleTable">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>Acknowlegement No</th>
                                        <th><?= strtoupper($platform) ?> ID</th>
                                        <th>Update</th>
                                        <th>View</th>
                                        <th>Status</th>
                                    </tr>
                                    <tr>
                                        <th>#</th>
                                        <th>એકનૉલેજમેન્ટ નંબર</th>
                                        <th><?= $platform_gujarati ?> આઈ.ડી.</th>
                                        <th>Update</th>
                                        <th>જુઓ</th>
                                        <th>સ્થિતિ</th>
                                    </tr>

                                </thead>
                                <tbody>
                                    <?php if (mysqli_num_rows($resultFacebook) > 0): ?>
                                    <?php $serial = 1; ?>

                                    <?php while ($row = mysqli_fetch_assoc($resultFacebook)): ?>
                                    <tr>
                                        <td><?= $serial++; ?></td>

                                        <td>
                                            <?php
                                                    if (!empty($row['acknowlegement'])) {
                                                        echo htmlspecialchars($row['acknowlegement']) . '<br>';
                                                        echo htmlspecialchars($row['complain_name']) . '<br>';
                                                        echo htmlspecialchars($row['mobile']);
                                                    } else {
                                                        echo '-';
                                                    }
                                                    ?>
                                        </td>

                                        <td>
                                            <?php
                                                    $social_ids = json_decode($row['social_id'], true);
                                                    if (is_array($social_ids)) {
                                                        // Escape each id and join with comma + <br> tag
                                                        echo implode(",<br>", array_map('htmlspecialchars', $social_ids));
                                                    } else {
                                                        echo htmlspecialchars($row['social_id']);
                                                    }
                                                    ?>
                                        </td>

                                        <td>
                                            <form id="viewForm<?= $row['id'] ?>" method="post"
                                                action="update_socialmedia.php" style="display:inline;">
                                                <input type="hidden" name="social_id"
                                                    value="<?= htmlspecialchars($row['id']) ?>">
                                                <input type="hidden" name="platform" value="<?= $platform ?>">
                                                <input type="hidden" name="print" value="true">
                                                <a href="#"
                                                    onclick="document.getElementById('viewForm<?= $row['id'] ?>').submit();"
                                                    class="btn btn-primary">
                                                    Update
                                                </a>
                                            </form>
                                        </td>
                                        <td>
                                            <form method="post" action="view_socialmedia.php" target="_blank">
                                                <input type="hidden" name="social_id"
                                                    value="<?= htmlspecialchars($row['id']) ?>">
                                                <input type="hidden" name="platform" value="<?= $platform ?>">
                                                <input type="hidden" name="print" value="true">

                                                <button type="submit" class="btn btn-primary">
                                                    View
                                                </button>
                                            </form>
                                        </td>

                                        <td>
                                            <form action="update_status_socialmedia.php" method="POST">
                                                <input type="hidden" name="social_id"
                                                    value="<?= htmlspecialchars($row['id']) ?>">
                                                <input type="hidden" name="platform" value="<?= $platform ?>">
                                                <select name="status" class="form-control"
                                                    onchange="this.form.submit()">
                                                    <option value="Pending"
                                                        <?= ($row['status'] == 'Pending') ? 'selected' : '' ?>>
                                                        Pending</option>
                                                    <option value="KYC Done"
                                                        <?= ($row['status'] == 'KYC Done') ? 'selected' : '' ?>>
                                                        KYC Done</option>
                                                </select>
                                            </form>
                                        </td>



                                    </tr>
                                    <?php endwhile; ?>
                                    <?php else: ?>
                                    <?php endif; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>



    </main>
    <!-- Essential javascripts for application to work-->
    <script src="js/jquery-3.7.0.min.js"></script>
    <script src="js/bootstrap.min.js"></script>
    <script src="js/main.js"></script>
    <!-- Page specific javascripts-->
    <link rel="stylesheet" href="https://cdn.datatables.net/v/bs5/dt-1.13.4/datatables.min.css">
    <!-- Data table plugin-->
    <script type="text/javascript" src="js/plugins/jquery.dataTables.min.js"></script>
    <script type="text/javascript" src="js/plugins/dataTables.bootstrap.min.js"></script>
    <script type="text/javascript">
    $('#sampleTable').DataTable();
    </script>
    <script type="text/javascript" src="https://cdn.jsdelivr.net/npm/echarts@5.4.3/dist/echarts.min.js"></script>


</body>

</html>