<?php
session_start();
include "config.php";

// Redirect if user is not logged in
if (!isset($_SESSION['user'])) {
    echo '<script>window.location.href = "index.php";</script>';
    exit();
}
// Get user details from session
$user = $_SESSION['user'];
$pid = $user['pid'];
//echo "Welcome " . htmlspecialchars($user['name'] ?? 'User') . "<br>";
//echo "Email: " . htmlspecialchars($user['email'] ?? '') . "<br>";
//echo "Phone: " . htmlspecialchars($user['phone'] ?? '') . "<br>";
//$IPDRQuery = "SELECT * FROM `ipdr` ORDER BY `id` DESC";
//$resultIPDR = mysqli_query($con, $IPDRQuery);

//$IPDRQuery = " SELECT * FROM ipdr INNER JOIN cyber_police ON ipdr.c_id = cyber_police.id ORDER BY ipdr.id DESC";
$IPDRQuery = "
    SELECT 
        ipdr.id,
        ipdr.c_id,
        ipdr.police_id,
        ipdr.notice_id,
        ipdr.subject_id,
        ipdr.ip_data,
        ipdr.created_at,
        ipdr.status,
        cyber_police.id AS cyber_id,
        cyber_police.acknowlegement,
        cyber_police.complain_name,
        cyber_police.mobile,
        cyber_police.incident_date_time,
        cyber_police.total_fraud_amount,
        cyber_police.total_lien_amount,
        cyber_police.atf,
        cyber_police.pid,
        cyber_police.status AS cyber_status,
        cyber_police.time_stamp
    FROM ipdr
    INNER JOIN cyber_police 
        ON ipdr.c_id = cyber_police.id
    WHERE cyber_police.pid = '$pid'
    ORDER BY ipdr.id DESC
";

$resultIPDR = mysqli_query($con, $IPDRQuery);


?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="icon" href="images/favicon.ico" sizes="32x32" type="image/x-icon">

    <title>IP Detail Record</title>

    <!-- Main CSS -->
    <link rel="stylesheet" type="text/css" href="css/main.css">

    <!-- Bootstrap Icons -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css">
</head>

<body class="app sidebar-mini">
    <!-- Navbar-->
    <?php include "header.php" ?>
    <!-- Sidebar menu-->
    <div class="app-sidebar__overlay" data-toggle="sidebar"></div>


    <aside class="app-sidebar">

        <?php include "./common/name.php" ?>

        <?php include 'sidebar.php' ?>

    </aside>

    <main class="app-content">
        <div class="app-title">
            <div>
                <h1><i class="bi bi-database"></i> IPDR </h1>
            </div>
            <ul class="app-breadcrumb breadcrumb">
                <li class="breadcrumb-item"><i class="bi bi-house-door fs-6"></i></li>
                <li class="breadcrumb-item"><a href="ipdr.php">IPDR</a></li>

            </ul>
        </div>


        <div class="tile-title-w-btn d-flex justify-content-end">
            <p class="mb-10">
                <a href="./export/export_ipdr_pdf.php" class="btn btn-primary icon-btn" target="_blank">
                    <i class="bi bi-plus-square me-2"></i>Export to PDF
                </a>

            </p>
            <p class="mb-10"> &nbsp;&nbsp;</p>
            <p class="mb-10">
                <a href="./export/export_ipdr_excel.php" class="btn btn-primary icon-btn">
                    <i class="bi bi-plus-square me-2"></i>Export to EXCEL
                </a>
            </p>
            <p class="mb-10"> &nbsp;&nbsp;</p>

            <p class="mb-10">
                <a href="add_ipdr.php" class="btn btn-primary icon-btn">
                    <i class="bi bi-plus-square me-2"></i>Add
                </a>
            </p>
        </div>


        <div class="row">
            <div class="col-md-12">
                <div class="tile">
                    <div class="tile-body">
                        <div class="table-responsive">
                            <table class="table table-hover table-bordered" id="sampleTable">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>Acknowlegement No</th>
                                        <th>Number</th>
                                        <th>Update</th>
                                        <th>View</th>
                                        <th>Status</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php if (mysqli_num_rows($resultIPDR) > 0): ?>
                                    <?php $serial = 1; ?>

                                    <?php while($row = mysqli_fetch_assoc($resultIPDR)): ?>


                                    <tr>
                                        <td><?= $serial++; ?></td>
                                        <td>
                                            <?php
                                            if (!empty($row['acknowlegement'])) {
                                                echo htmlspecialchars($row['acknowlegement']) . '<br>';
                                                echo htmlspecialchars($row['complain_name']) . '<br>';
                                                echo htmlspecialchars($row['mobile']);
                                            } else {
                                                echo '-';
                                            }
                                            ?>
                                        </td>
                                        <td>
                                            <div class="table-responsive">
                                                <table class="table table-hover table-bordered">
                                                    <thead>
                                                        <tr>

                                                            <th>IP TYPE</th>
                                                            <th>IP ADDRESS</th>
                                                            <th>Start DATE</th>
                                                            <th>START TIME (IST)</th>
                                                            <th>End DATE</th>
                                                            <th>END TIME (IST)</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        <?php
                                                            $ip_data = $row['ip_data'];
                                                            $ip_records = json_decode($ip_data, true);

                                                            if (is_array($ip_records) && count($ip_records) > 0) {
                                                                foreach ($ip_records as $record) {
                                                                    echo '<tr>';
                                                                    echo '<td>' . htmlspecialchars($record['ip_type']) . '</td>';
                                                                    echo '<td>' . htmlspecialchars($record['ip_address']) . '</td>';
                                                                    echo '<td>' . htmlspecialchars($record['start_date']) . '</td>';
                                                                    echo '<td>' . htmlspecialchars($record['start_time_ist']) . '</td>';
                                                                    echo '<td>' . htmlspecialchars($record['start_date']) . '</td>';
                                                                    echo '<td>' . htmlspecialchars($record['end_date']) . '</td>';
                                                                    echo '</tr>';
                                                                }
                                                            } else {
                                                                echo '<tr><td colspan="5" class="text-center">No IP records available.</td></tr>';
                                                            }
                                                        ?>

                                                    </tbody>
                                                </table>
                                            </div>
                                        </td>

                                        <td>

                                            <form id="viewForm<?= $row['id'] ?>" method="post" action="update_ipdr.php"
                                                style="display:inline;">
                                                <input type="hidden" name="ipdr_id" value="<?= $row['id'] ?>">
                                                <input type="hidden" name="print" value="true">
                                                <a href="#"
                                                    onclick="event.preventDefault(); document.getElementById('viewForm<?= $row['id'] ?>').submit();"
                                                    class="btn btn-primary">
                                                    Update
                                                </a>
                                            </form>
                                        </td>

                                        <td>
                                            <form id="viewForm<?= $row['c_id'] ?>" method="post" action="view_ipdr.php"
                                                style="display:inline;" target="_blank">
                                                <input type="hidden" name="ipdr_id" value="<?= $row['c_id'] ?>">
                                                <input type="hidden" name="print" value="true">

                                                <a href="#"
                                                    onclick="event.preventDefault(); document.getElementById('viewForm<?= $row['c_id'] ?>').submit();"
                                                    class="btn btn-primary">
                                                    View
                                                </a>
                                            </form>

                                        </td>

                                        <td>
                                            <form action="update_status_ipdr.php" method="POST">
                                                <input type="hidden" name="id" value="<?= $row['id'] ?>">
                                                <select name="status" class="form-control"
                                                    onchange="this.form.submit()">
                                                    <option value="Pending"
                                                        <?= ($row['status'] == 'Pending') ? 'selected' : '' ?>>Pending
                                                    </option>
                                                    <option value="KYC Done"
                                                        <?= ($row['status'] == 'KYC Done') ? 'selected' : '' ?>>KYC Done
                                                    </option>
                                                </select>
                                            </form>
                                        </td>
                                    </tr>
                                    <?php endwhile; ?>
                                    <?php else: ?>
                                    <?php endif; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>






    </main>
    <!-- Essential javascripts for application to work-->
    <script src="js/jquery-3.7.0.min.js"></script>
    <script src="js/bootstrap.min.js"></script>
    <script src="js/main.js"></script>
    <!-- Page specific javascripts-->
    <link rel="stylesheet" href="https://cdn.datatables.net/v/bs5/dt-1.13.4/datatables.min.css">
    <!-- Data table plugin-->
    <script type="text/javascript" src="js/plugins/jquery.dataTables.min.js"></script>
    <script type="text/javascript" src="js/plugins/dataTables.bootstrap.min.js"></script>
    <script type="text/javascript">
    $('#sampleTable').DataTable();
    </script>
    <script type="text/javascript" src="https://cdn.jsdelivr.net/npm/echarts@5.4.3/dist/echarts.min.js"></script>




</body>

</html>