<?php
include "config.php";

/* ================= INSERT PORTAL ================= */
if (isset($_POST['save_portal'])) {

    $category = mysqli_real_escape_string($con, $_POST['category']);
    $sub_category = mysqli_real_escape_string($con, $_POST['sub_category']);
    $title = mysqli_real_escape_string($con, $_POST['title']);
    $url = mysqli_real_escape_string($con, $_POST['url']);

    // DUPLICATE CHECK
    $check = mysqli_query(
        $con,
        "SELECT id FROM cyber_portal 
         WHERE category='$category' 
         AND sub_category='$sub_category'
         AND title='$title' 
         AND url='$url'"
    );

    if (mysqli_num_rows($check) == 0) {

        mysqli_query(
            $con,
            "INSERT INTO cyber_portal (category, sub_category, title, url)
             VALUES ('$category','$sub_category','$title','$url')"
        );

        echo "<script>alert('Portal added successfully');</script>";

    } else {
        echo "<script>alert('This portal already exists');</script>";
    }

    echo "<script>window.location='portal.php';</script>";
}

function getIconByTitle($title)
{
    $title = strtolower($title);
    if (strpos($title, 'whatsapp') !== false)
        return 'bi-whatsapp';
    if (strpos($title, 'facebook') !== false)
        return 'bi-facebook';
    if (strpos($title, 'instagram') !== false)
        return 'bi-instagram';
    if (strpos($title, 'google') !== false)
        return 'bi-google';
    if (strpos($title, 'mail') !== false)
        return 'bi-envelope';
    if (strpos($title, 'cctv') !== false)
        return 'bi-camera-video';
    if (strpos($title, 'court') !== false)
        return 'bi-bank';
    if (strpos($title, 'ip') !== false)
        return 'bi-pc-display';
    if (strpos($title, 'training') !== false)
        return 'bi-mortarboard';
    if (strpos($title, 'map') !== false)
        return 'bi-geo-alt';
    return 'bi-globe';
}

/* ================= COLOR CLASSES ================= */
$colors = ['primary', 'info', 'warning', 'danger'];

?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="icon" href="images/favicon.ico" sizes="32x32" type="image/x-icon">
    <title>Portal</title>
    <link rel="stylesheet" href="css/main.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            margin-left: 5%;
            margin-right: 5%;
            background-color: #e9ecef;
            /* secondary color */
            font-family: Arial, sans-serif;
        }
    </style>
</head>

<body>

    <main>
        <div class="text-center mt-4 mb-4">
            <h1><i class="bi bi-speedometer"></i> Portal</h1>
        </div>

        <!-- SEARCH + ADD BUTTON -->
        <div class="d-flex justify-content-between align-items-center mt-4 mb-3">
            <input type="text" id="searchPortal" class="form-control" style="max-width:300px;"
                placeholder="Search portal...">

        </div>

        <!-- CATEGORY WISE DATA -->
        <?php
        $catQuery = mysqli_query($con, "SELECT DISTINCT category FROM cyber_portal ORDER BY category");
        $colorIndex = 0;

        while ($cat = mysqli_fetch_assoc($catQuery)) {
            $category = $cat['category'];
            ?>
            <h4 class="mt-4 fw-bold"><?= htmlspecialchars($category) ?></h4>
            <div class="row">
                <?php
                $dataQuery = mysqli_query($con, "SELECT * FROM cyber_portal WHERE category='$category' ORDER BY title");
                while ($row = mysqli_fetch_assoc($dataQuery)) {
                    $searchText = strtolower($row['category'] . ' ' . $row['sub_category'] . ' ' . $row['title']);
                    $colorClass = $colors[$colorIndex % count($colors)];
                    $iconClass = getIconByTitle($row['title']);
                    $colorIndex++;
                    ?>
                    <div class="col-md-3 col-lg-4 portal-card" data-search="<?= $searchText ?>">
                        <div class="widget-small <?= $colorClass ?> coloured-icon"
                            onclick="window.open('<?= htmlspecialchars($row['url']) ?>','_blank')">
                            <div class="icon"><i class="bi <?= $iconClass ?> fs-1"></i></div>
                            <div class="info">
                                <h4><?= htmlspecialchars($row['title']) ?></h4>
                                <h5><?= htmlspecialchars($row['sub_category']) ?></h5>
                            </div>
                        </div>
                    </div>
                <?php } ?>
            </div>
        <?php } ?>
    </main>

    <script src="js/jquery-3.7.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>

    <script>
        // LIVE SEARCH
        document.getElementById('searchPortal').addEventListener('keyup', function () {
            let value = this.value.toLowerCase();
            document.querySelectorAll('.portal-card').forEach(function (card) {
                let text = card.getAttribute('data-search');
                card.style.display = text.includes(value) ? '' : 'none';
            });
        });
    </script>

</body>

</html>