<?php
session_start();
include "config.php";

// Redirect if user is not logged in
if (!isset($_SESSION['user'])) {
    echo '<script>window.location.href = "index.php";</script>';
    exit();
}
// Get user details from session
$user = $_SESSION['user'];
$pid = $user['pid'];

//echo "Welcome " . htmlspecialchars($user['name'] ?? 'User') . "<br>";
//echo "Email: " . htmlspecialchars($user['email'] ?? '') . "<br>";
//echo "Phone: " . htmlspecialchars($user['phone'] ?? '') . "<br>";
?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="icon" href="images/favicon.ico" sizes="32x32" type="image/x-icon">

    <title>Dashboard</title>

    <!-- Main CSS -->
    <link rel="stylesheet" type="text/css" href="css/main.css">

    <!-- Bootstrap Icons -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css">
</head>

<body class="app sidebar-mini">
    <!-- Navbar-->
    <?php include "header.php" ?>
    <!-- Sidebar menu-->
    <div class="app-sidebar__overlay" data-toggle="sidebar"></div>
    <aside class="app-sidebar">

        <?php include "./common/name.php" ?>

        <?php include 'sidebar.php' ?>

    </aside>

    <main class="app-content">
        <div class="app-title">
            <div>
                <h1><i class="bi bi-speedometer"></i> Dashboard</h1>
            </div>
            <ul class="app-breadcrumb breadcrumb">
                <li class="breadcrumb-item"><i class="bi bi-house-door fs-6"></i></li>
                <li class="breadcrumb-item"><a href="main.php">Dashboard</a></li>
            </ul>
        </div>

        <div class="row">
            <div class="col-md-6">
                <div class="tile">
                    <h3 class="tile-title">Police Station Data Overview</h3>
                    <div class="ratio ratio-16x9">
                        <div id="stationOverviewChart"></div>
                    </div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="tile">
                    <h3 class="tile-title">Social Media Data Overview</h3>
                    <div class="ratio ratio-16x9">
                        <div id="socialMediaChart"></div>
                    </div>
                </div>
            </div>
        </div>



    </main>
    <!-- Essential javascripts for application to work-->
    <script src="js/jquery-3.7.0.min.js"></script>
    <script src="js/bootstrap.min.js"></script>
    <script src="js/main.js"></script>
    <!-- Page specific javascripts-->

    <script type="text/javascript" src="https://cdn.jsdelivr.net/npm/echarts@5.4.3/dist/echarts.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/echarts@5.4.2/dist/echarts.min.js"></script>
    <script>
        document.addEventListener('DOMContentLoaded', () => {
            fetch('get_chart_data.php')
                .then(response => response.json())
                .then(data => {
                    renderStationChart(data);
                    renderSocialChart(data);
                })
                .catch(error => {
                    console.error('Error loading chart data:', error);
                });

            function renderStationChart(data) {
                const chartDom = document.getElementById('stationOverviewChart');
                const chart = echarts.init(chartDom);
                const option = {
                    tooltip: {
                        trigger: 'axis',
                        axisPointer: {
                            type: 'shadow'
                        }
                    },
                    xAxis: {
                        type: 'category',
                        data: ['KYC', 'Lien', 'Comply', 'CCTV', 'CDR', 'Domain']
                    },
                    yAxis: {
                        type: 'value'
                    },
                    series: [{
                        name: 'Count',
                        type: 'bar',
                        data: [
                            data.kyc,
                            data.lien,
                            data.comply,
                            data.cctv,
                            data.cdr,
                            data.domain
                        ],
                        itemStyle: {
                            color: '#4e73df'
                        }
                    }]
                };
                chart.setOption(option);
                new ResizeObserver(() => chart.resize()).observe(chartDom);
            }

            function renderSocialChart(data) {
                const chartDom = document.getElementById('socialMediaChart');
                const chart = echarts.init(chartDom);
                const option = {
                    tooltip: {
                        trigger: 'item'
                    },
                    legend: {
                        bottom: 0
                    },
                    series: [{
                        name: 'Social Media',
                        type: 'pie',
                        radius: '70%',
                        data: [{
                            value: data.facebook,
                            name: 'Facebook'
                        },
                        {
                            value: data.instagram,
                            name: 'Instagram'
                        },
                        {
                            value: data.whatsapp,
                            name: 'WhatsApp'
                        },
                        {
                            value: data.twitter,
                            name: 'Twitter'
                        },
                        {
                            value: data.snapchat,
                            name: 'Snapchat'
                        },
                        {
                            value: data.google,
                            name: 'Google'
                        }
                        ],
                        emphasis: {
                            itemStyle: {
                                shadowBlur: 10,
                                shadowOffsetX: 0,
                                shadowColor: 'rgba(0, 0, 0, 0.5)'
                            }
                        }
                    }]
                };
                chart.setOption(option);
                new ResizeObserver(() => chart.resize()).observe(chartDom);
            }
        });
    </script>


</body>

</html>