<?php
session_start();
include "config.php";

// Redirect if user is not logged in
if (!isset($_SESSION['user'])) {
    echo '<script>window.location.href = "index.php";</script>';
    exit();
}
// Get user details from session
$user = $_SESSION['user'];
$pid = $user['pid'];
//echo "Welcome " . htmlspecialchars($user['name'] ?? 'User') . "<br>";
//echo "Email: " . htmlspecialchars($user['email'] ?? '') . "<br>";
//echo "Phone: " . htmlspecialchars($user['phone'] ?? '') . "<br>";

$facebookQuery = "SELECT * FROM `facebook_data` WHERE `pid`='$pid' and `type`='Facebook' ORDER BY `id` DESC";
$resultFacebook = mysqli_query($con, $facebookQuery);
?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <title>FACEBOOK</title>

    <!-- Main CSS -->
    <link rel="stylesheet" type="text/css" href="css/main.css">

    <!-- Bootstrap Icons -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css">
</head>

<body class="app sidebar-mini">
    <!-- Navbar-->
    <?php include "header.php" ?>
    <!-- Sidebar menu-->
    <div class="app-sidebar__overlay" data-toggle="sidebar"></div>
    <aside class="app-sidebar">

        <?php include "./common/name.php" ?>

        <ul class="app-menu">

            <li><a class="app-menu__item" href="main.php"><i class="app-menu__icon bi bi-speedometer"></i><span
                        class="app-menu__label">Dashboard</span></a>
            </li>

            <li class="treeview"><a class="app-menu__item" data-toggle="treeview"><i
                        class="app-menu__icon bi bi-laptop"></i><span class="app-menu__label">Bank</span><i
                        class="treeview-indicator bi bi-chevron-right"></i></a>
                <ul class="treeview-menu">
                    <li><a class="treeview-item" href="kyc_form.php"><i class="icon bi bi-circle-fill"></i>KYC</a>
                    </li>
                    <li><a class="treeview-item" href="lien_amount.php"><i class="icon bi bi-circle-fill"></i> LIAN
                            AMOUNT</a></li>
                    <li><a class="treeview-item" href=""><i class="icon bi bi-circle-fill"></i> BOND</a> </li>
                    <li><a class="treeview-item" href=""><i class="icon bi bi-circle-fill"></i> Opinion</a> </li>
                    <li><a class="treeview-item" href=""><i class="icon bi bi-circle-fill"></i> COMPLY ORDER</a> </li>
                    <li><a class="treeview-item" href=""><i class="icon bi bi-circle-fill"></i> CCTV</a> </li>
                </ul>
            </li>

            <li class="treeview"><a class="app-menu__item active" data-toggle="treeview"><i
                        class="app-menu__icon bi bi-laptop"></i><span class="app-menu__label">SOCIAL MEDIA</span><i
                        class="treeview-indicator bi bi-chevron-right"></i></a>
                <ul class="treeview-menu">
                    <li><a class="treeview-item active" href="facebook.php"><i
                                class="icon bi bi-circle-fill"></i>FACEBOOK</a>
                    </li>
                    <li><a class="treeview-item" href=""><i class="icon bi bi-circle-fill"></i>INSTAGRAM</a></li>
                    <li><a class="treeview-item" href=""><i class="icon bi bi-circle-fill"></i> Whatsapp</a> </li>
                    <li><a class="treeview-item" href=""><i class="icon bi bi-circle-fill"></i> X(TWitter)</a> </li>
                    <li><a class="treeview-item" href=""><i class="icon bi bi-circle-fill"></i> Snapchat</a> </li>
                    <li><a class="treeview-item" href=""><i class="icon bi bi-circle-fill"></i> LERS(Google)</a> </li>
                </ul>
            </li>

        </ul>

    </aside>

    <main class="app-content">
        <div class="app-title">
            <div>
                <h1><i class="bi bi-facebook"></i> Facebook</h1>
            </div>
            <ul class="app-breadcrumb breadcrumb">
                <li class="breadcrumb-item"><i class="bi bi-house-door fs-6"></i></li>
                <li class="breadcrumb-item"><a href="#">Dashboard</a></li>
            </ul>
        </div>

        <div class="row">
            <div class="tile">
                <div class="tile-title-w-btn">
                    <h3 class="title">FACEBOOK</h3>
                    <p>
                        <a href="add_facebook.php" class="btn btn-primary icon-btn">
                            <i class="bi bi-plus-square me-2"></i>Add
                        </a>
                    </p>

                </div>

            </div>
        </div>

        <div class="row">
            <div class="col-md-12">
                <div class="tile">
                    <div class="tile-body">
                        <div class="table-responsive">
                            <table class="table table-hover table-bordered" id="sampleTable">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>Acknowlegement No</th>
                                        <!-- <th>Fraud Type</th> -->
                                        <th>Facebook ID</th>
                                        <th>View</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php if (mysqli_num_rows($resultFacebook) > 0): ?>
                                        <?php while ($row = mysqli_fetch_assoc($resultFacebook)): ?>
                                            <tr>
                                                <td><?= htmlspecialchars($row['id']) ?></td>
                                                <td><?= htmlspecialchars($row['ack_no']) ?></td>

                                                <td>
                                                    <?php
                                                    $fb_ids = json_decode($row['facebook_id'], true);
                                                    if (is_array($fb_ids)) {
                                                        // Escape each id and join with comma + <br> tag
                                                        echo implode(",<br>", array_map('htmlspecialchars', $fb_ids));
                                                    } else {
                                                        echo htmlspecialchars($row['facebook_id']);
                                                    }
                                                    ?>
                                                </td>

                                                <td>
                                                    <form id="viewForm<?= $row['id'] ?>" method="post"
                                                        action="view_facebook.php" style="display:inline;">
                                                        <input type="hidden" name="facebook_id"
                                                            value="<?= htmlspecialchars($row['id']) ?>">
                                                        <input type="hidden" name="print" value="true">
                                                        <a href="#"
                                                            onclick="document.getElementById('viewForm<?= $row['id'] ?>').submit();"
                                                            class="btn btn-primary">
                                                            View
                                                        </a>
                                                    </form>
                                                </td>
                                            </tr>
                                        <?php endwhile; ?>
                                    <?php else: ?>
                                    <?php endif; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>



    </main>
    <!-- Essential javascripts for application to work-->
    <script src="js/jquery-3.7.0.min.js"></script>
    <script src="js/bootstrap.min.js"></script>
    <script src="js/main.js"></script>
    <!-- Page specific javascripts-->
    <link rel="stylesheet" href="https://cdn.datatables.net/v/bs5/dt-1.13.4/datatables.min.css">
    <!-- Data table plugin-->
    <script type="text/javascript" src="js/plugins/jquery.dataTables.min.js"></script>
    <script type="text/javascript" src="js/plugins/dataTables.bootstrap.min.js"></script>
    <script type="text/javascript">
        $('#sampleTable').DataTable();
    </script>
    <script type="text/javascript" src="https://cdn.jsdelivr.net/npm/echarts@5.4.3/dist/echarts.min.js"></script>

    <script>
        function openKycPage() {
            window.location.href = "kyc_form.php"; // 👈 change this to your target URL
        }
    </script>

</body>

</html>