<?php
session_start();
include "../config.php";

// Check login
if (!isset($_SESSION['user'])) {
    header("Location: ../index.php");
    exit();
}

$user = $_SESSION['user'];
$pid = $user['pid'];
$platform = $_GET['platform'] ?? '';

$psQuery = "SELECT p_name FROM policestation WHERE id = '$pid' LIMIT 1";
$psResult = mysqli_query($con, $psQuery);
$policeStationName = mysqli_fetch_assoc($psResult)['p_name'] ?? 'PoliceStation';

// Fetch social media data
$sql = "
    SELECT 
        s.*, 
        c.acknowlegement, 
        c.complain_name, 
        c.mobile, 
        c.incident_date_time, 
        c.total_fraud_amount, 
        c.total_lien_amount, 
        c.status AS complain_status,
        s.status AS social_status
    FROM social_media s
    LEFT JOIN cyber_police c ON s.c_id = c.id
    WHERE s.c_id != 0
    AND c.pid = '$pid'
    AND s.type = '$platform'
    ORDER BY s.id DESC
";
$result = mysqli_query($con, $sql);

$platform_title = strtoupper($platform);
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <title><?php echo $platform_title; ?> Report</title>
    <style>
    body {
        font-family: Arial, sans-serif;
        margin: 30px;
    }

    h2 {
        text-align: center;
        margin-bottom: 20px;
        text-transform: uppercase;
    }

    table {
        width: 100%;
        border-collapse: collapse;
        margin-bottom: 20px;
    }

    th,
    td {
        border: 1px solid #444;
        padding: 8px;
        font-size: 13px;
    }

    th {
        background: #f2f2f2;
        text-align: center;
    }

    td {
        vertical-align: top;
    }

    .btn-print {
        display: inline-block;
        padding: 8px 16px;
        background: #007bff;
        color: white;
        border: none;
        cursor: pointer;
        border-radius: 5px;
        margin-bottom: 10px;
    }

    @media print {
        .btn-print {
            display: none;
        }
    }
    </style>
</head>

<body>

    <h2><?php echo "{$policeStationName} - {$platform_title} Report"; ?></h2>

    <table>
        <tr>
            <th>#</th>
            <th>Acknowledgement</th>
            <th>Complainant</th>
            <th>Mobile</th>
            <th>Social Media ID(s)</th>
            <th>Incident Date</th>
            <th>Status</th>
        </tr>

        <?php
        if (mysqli_num_rows($result) > 0) {
            $i = 1;
            while ($row = mysqli_fetch_assoc($result)) {
                $social_ids = json_decode($row['social_id'], true);
                $social_display = '';
                if (is_array($social_ids)) {
                    foreach ($social_ids as $id) {
                        $social_display .= htmlspecialchars($id) . "<br>";
                    }
                } else {
                    $social_display = htmlspecialchars($row['social_id']);
                }

                echo "<tr>
                    <td>{$i}</td>
                    <td>" . htmlspecialchars($row['acknowlegement'] ?? '-') . "</td>
                    <td>" . htmlspecialchars($row['complain_name'] ?? '-') . "</td>
                    <td>" . htmlspecialchars($row['mobile'] ?? '-') . "</td>
                    <td>{$social_display}</td>
                    <td>" . htmlspecialchars($row['incident_date_time'] ?? '-') . "</td>
                    <td>" . htmlspecialchars($row['social_status'] ?? '-') . "</td>
                  </tr>";
                $i++;
            }
        } else {
            echo "<tr><td colspan='9' style='text-align:center;'>No records found</td></tr>";
        }
        ?>
    </table>

    <script>
    window.print(); // Open print dialog for PDF
    </script>
</body>

</html>