<?php
session_start();
include "../config.php";

// Redirect if not logged in
if (!isset($_SESSION['user'])) {
    header("Location: index.php");
    exit();
}

$user = $_SESSION['user'];
$pid = $user['pid'];

// Get Police Station Name
$psQuery = "SELECT p_name FROM policestation WHERE id = '$pid' LIMIT 1";
$psResult = mysqli_query($con, $psQuery);
$policeStationName = mysqli_fetch_assoc($psResult)['p_name'] ?? 'PoliceStation';

// Fetch KYC + Bank details
$sql = "SELECT k.id AS kyc_id, k.status AS kyc_status, k.remarks AS kyc_remarks,
       c.acknowlegement, c.complain_name, c.mobile,
       b.bank_name, b.account_number, b.ifsc_code, b.account_holder, b.hold_amount, b.remarks AS bank_remarks
FROM kyc k
LEFT JOIN cyber_police c ON k.c_id = c.id
LEFT JOIN bank_accounts b ON b.kyc_id = k.id
WHERE c.pid = '$pid' AND k.type = 'LIEN AMOUNT'
ORDER BY k.id DESC, b.id ASC
";
$result = mysqli_query($con, $sql);

// Preprocess to group by KYC
$kycData = [];
while ($row = mysqli_fetch_assoc($result)) {
    $kycId = $row['kyc_id'];
    if (!isset($kycData[$kycId])) {
        $kycData[$kycId] = [
            'acknowlegement' => $row['acknowlegement'],
            'complain_name' => $row['complain_name'],
            'kyc_status' => $row['kyc_status'],
            'kyc_remarks' => $row['kyc_remarks'],
            'banks' => []
        ];
    }
    $kycData[$kycId]['banks'][] = [
        'bank_name' => $row['bank_name'],
        'account_number' => $row['account_number'],
        'ifsc_code' => $row['ifsc_code'],
        'account_holder' => $row['account_holder'],
        'hold_amount' => $row['hold_amount'],
        'bank_remarks' => $row['bank_remarks'],

    ];
}
?>
<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <title><?= htmlspecialchars($policeStationName) ?> KYC Report</title>
    <style>
        body {
            font-family: Arial, sans-serif;
        }

        h2 {
            text-align: center;
            margin-bottom: 20px;
        }

        table {
            border-collapse: collapse;
            width: 100%;
        }

        th,
        td {
            border: 1px solid #000;
            padding: 8px;
            text-align: left;
        }

        th {
            background-color: #f2f2f2;
        }
    </style>
</head>

<body>
    <h2><?= htmlspecialchars($policeStationName) ?> LIEN Report</h2>
    <table>
        <thead>
            <tr>
                <th>Acknowledgement</th>
                <th>Complainant Name</th>
                <th>Bank Name</th>
                <th>Account Number</th>
                <th>IFSC</th>
                <th>Account Holder</th>
                <th>Hold Amount</th>
                <th>Bank Remarks</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($kycData as $kyc): ?>
                <?php $rowspan = count($kyc['banks']) ?: 1; ?>
                <?php foreach ($kyc['banks'] as $i => $bank): ?>
                    <tr>
                        <?php if ($i === 0): ?>
                            <td rowspan="<?= $rowspan ?>"><?= htmlspecialchars((string) $kyc['acknowlegement']) ?></td>
                            <td rowspan="<?= $rowspan ?>"><?= htmlspecialchars((string) $kyc['complain_name']) ?></td>
                            <!-- <td rowspan="<?= $rowspan ?>"><?= htmlspecialchars((string) $kyc['kyc_status']) ?></td> -->
                        <?php endif; ?>
                        <td><?= htmlspecialchars((string) $bank['bank_name']) ?></td>
                        <td><?= htmlspecialchars((string) $bank['account_number']) ?></td>
                        <td><?= htmlspecialchars((string) $bank['ifsc_code']) ?></td>
                        <td><?= htmlspecialchars((string) $bank['account_holder']) ?></td>
                        <td><?= htmlspecialchars((string) $bank['hold_amount']) ?></td>
                        <td><?= htmlspecialchars((string) $bank['bank_remarks']) ?></td>
                    </tr>
                <?php endforeach; ?>
            <?php endforeach; ?>
        </tbody>
    </table>
    <script>
        window.print(); // Open print dialog for PDF
    </script>
</body>

</html>