<?php
session_start();
include "config.php";

// Redirect if user is not logged in
if (!isset($_SESSION['user'])) {
    echo '<script>window.location.href = "index.php";</script>';
    exit();
}
// Get user details from session
$user = $_SESSION['user'];

//echo "Welcome " . htmlspecialchars($user['name'] ?? 'User') . "<br>";
//echo "Email: " . htmlspecialchars($user['email'] ?? '') . "<br>";
//echo "Phone: " . htmlspecialchars($user['phone'] ?? '') . "<br>";
?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <title>Dashboard</title>

    <!-- Main CSS -->
    <link rel="stylesheet" type="text/css" href="css/main.css">

    <!-- Bootstrap Icons -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css">
</head>

<body class="app sidebar-mini">
    <!-- Navbar-->
    <?php include "header.php" ?>
    <!-- Sidebar menu-->
    <div class="app-sidebar__overlay" data-toggle="sidebar"></div>
    <aside class="app-sidebar">

        <?php include "./common/name.php" ?>
        
        <?php include "sidebar.php"?>

    </aside>
    <main class="app-content">
        <div class="app-title">
            <div>
                <h1><i class="bi bi-speedometer"></i> Dashboard</h1>
            </div>
            <ul class="app-breadcrumb breadcrumb">
                <li class="breadcrumb-item"><i class="bi bi-house-door fs-6"></i></li>
                <li class="breadcrumb-item"><a href="#">Dashboard</a></li>
            </ul>
        </div>
        <div class="row">
            <div class="col-md-6 col-lg-3">
                <div class="widget-small primary coloured-icon"><i class="icon bi bi-people fs-1"></i>
                    <div class="info">
                        <h4>SP OFFICE</h4>
                        <p>
                            <b>
                                <?php
                                    // Assuming $conn is your MySQLi connection
                                    $sql = "SELECT COUNT(*) AS total_users FROM spoffice";
                                    $result = mysqli_query($con, $sql);
                                    $row = mysqli_fetch_assoc($result);
                                    echo "Total : " . $row['total_users'];
                                ?>
                            </b>
                        </p>
                    </div>
                </div>
            </div>
            <div class="col-md-6 col-lg-3">
                <div class="widget-small info coloured-icon"><i class="icon bi bi-pin-map fs-1"></i>
                    <div class="info">
                        <h4>Police Station</h4>
                        <p><b>
                                <?php
                                    // Assuming $conn is your MySQLi connection
                                    $sql = "SELECT COUNT(*) AS total_users FROM policestation";
                                    $result = mysqli_query($con, $sql);
                                    $row = mysqli_fetch_assoc($result);
                                    echo "Total : " . $row['total_users'];
                                ?>
                            </b></p>
                    </div>
                </div>
            </div>
            <div class="col-md-6 col-lg-3">
                <div class="widget-small warning coloured-icon"><i class="icon bi bi-people fs-1"></i>
                    <div class="info">
                        <h4>Users</h4>
                        <p><b>
                                <?php
                                    // Assuming $conn is your MySQLi connection
                                    $sql = "SELECT COUNT(*) AS total_users FROM users";
                                    $result = mysqli_query($con, $sql);
                                    $row = mysqli_fetch_assoc($result);
                                    echo "Total : " . $row['total_users'];
                                ?>
                            </b></p>
                    </div>
                </div>
            </div>
            <div class="col-md-6 col-lg-3">
                <div class="widget-small danger coloured-icon"><i class="icon bi bi-person-badge fs-1"></i>
                    <div class="info">
                        <h4>Police</h4>
                        <p><b><?php
                                    // Assuming $conn is your MySQLi connection
                                    $sql = "SELECT COUNT(*) AS total_users FROM police";
                                    $result = mysqli_query($con, $sql);
                                    $row = mysqli_fetch_assoc($result);
                                    echo "Total : " . $row['total_users'];
                                ?></b></p>
                    </div>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-md-6 col-lg-3">
                <div class="widget-small primary coloured-icon"><i class="icon bi bi-files fs-1"></i>
                    <div class="info">
                        <h4>Notice</h4>
                        <p>
                            <b>
                                <?php
                                    // Assuming $conn is your MySQLi connection
                                    $sql = "SELECT COUNT(*) AS total_users FROM notice";
                                    $result = mysqli_query($con, $sql);
                                    $row = mysqli_fetch_assoc($result);
                                    echo "Total : " . $row['total_users'];
                                ?>
                            </b>
                        </p>
                    </div>
                </div>
            </div>
            <div class="col-md-6 col-lg-3">
                <div class="widget-small info coloured-icon"><i class="icon bi bi-files-alt fs-1"></i>
                    <div class="info">
                        <h4>Subject</h4>
                        <p><b>
                                <?php
                                    // Assuming $conn is your MySQLi connection
                                    $sql = "SELECT COUNT(*) AS total_users FROM subject";
                                    $result = mysqli_query($con, $sql);
                                    $row = mysqli_fetch_assoc($result);
                                    echo "Total : " . $row['total_users'];
                                ?>
                            </b></p>
                    </div>
                </div>
            </div>
            <div class="col-md-6 col-lg-3">
                <div class="widget-small warning coloured-icon"><i class="icon bi bi-bank fs-1"></i>
                    <div class="info">
                        <h4>Bank</h4>
                        <p><b>
                                <?php
                                    // Assuming $conn is your MySQLi connection
                                    $sql = "SELECT COUNT(*) AS total_users FROM bank";
                                    $result = mysqli_query($con, $sql);
                                    $row = mysqli_fetch_assoc($result);
                                    echo "Total : " . $row['total_users'];
                                ?>
                            </b></p>
                    </div>
                </div>
            </div>
            <div class="col-md-6 col-lg-3">
                <div class="widget-small danger coloured-icon"><i class="icon bi bi-list-task fs-1"></i>
                    <div class="info">
                        <h4>Logs</h4>
                        <p><b><?php
                                    // Assuming $conn is your MySQLi connection
                                    $sql = "SELECT COUNT(*) AS total_users FROM logs";
                                    $result = mysqli_query($con, $sql);
                                    $row = mysqli_fetch_assoc($result);
                                    echo "Total : " . $row['total_users'];
                                ?></b></p>
                    </div>
                </div>
            </div>
        </div>


        <!-- <div class="row">
            <div class="col-md-6">
                <div class="tile">
                    <h3 class="tile-title">Weekly Sales - Last week</h3>
                    <div class="ratio ratio-16x9">
                        <div id="salesChart"></div>
                    </div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="tile">
                    <h3 class="tile-title">Support Requests</h3>
                    <div class="ratio ratio-16x9">
                        <div id="supportRequestChart"></div>
                    </div>
                </div>
            </div>
        </div> -->
    </main>
    <!-- Essential javascripts for application to work-->
    <script src="js/jquery-3.7.0.min.js"></script>
    <script src="js/bootstrap.min.js"></script>
    <script src="js/main.js"></script>
    <!-- Page specific javascripts-->
    <script type="text/javascript" src="https://cdn.jsdelivr.net/npm/echarts@5.4.3/dist/echarts.min.js"></script>
    <script type="text/javascript">
    const salesData = {
        xAxis: {
            type: 'category',
            data: ['Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat', 'Sun']
        },
        yAxis: {
            type: 'value',
            axisLabel: {
                formatter: '${value}'
            }
        },
        series: [{
            data: [150, 230, 224, 218, 135, 147, 260],
            type: 'line',
            smooth: true
        }],
        tooltip: {
            trigger: 'axis',
            formatter: "<b>{b0}:</b> ${c0}"
        }
    }

    const supportRequests = {
        tooltip: {
            trigger: 'item'
        },
        legend: {
            orient: 'vertical',
            left: 'left'
        },
        series: [{
            name: 'Support Requests',
            type: 'pie',
            radius: '50%',
            data: [{
                    value: 300,
                    name: 'In Progress'
                },
                {
                    value: 50,
                    name: 'Delayed'
                },
                {
                    value: 100,
                    name: 'Complete'
                }
            ],
            emphasis: {
                itemStyle: {
                    shadowBlur: 10,
                    shadowOffsetX: 0,
                    shadowColor: 'rgba(0, 0, 0, 0.5)'
                }
            }
        }]
    };

    const salesChartElement = document.getElementById('salesChart');
    const salesChart = echarts.init(salesChartElement, null, {
        renderer: 'svg'
    });
    salesChart.setOption(salesData);
    new ResizeObserver(() => salesChart.resize()).observe(salesChartElement);

    const supportChartElement = document.getElementById("supportRequestChart")
    const supportChart = echarts.init(supportChartElement, null, {
        renderer: 'svg'
    });
    supportChart.setOption(supportRequests);
    new ResizeObserver(() => supportChart.resize()).observe(supportChartElement);
    </script>
    <!-- Google analytics script-->

</body>

</html>