<?php
session_start();
include "config.php";

// Redirect if user is not logged in
if (!isset($_SESSION['user'])) {
    echo '<script>window.location.href = "index.php";</script>';
    exit();
}



// Get user details from session
$user = $_SESSION['user'];

//echo "Welcome " . htmlspecialchars($user['name'] ?? 'User') . "<br>";
//echo "Email: " . htmlspecialchars($user['email'] ?? '') . "<br>";
//echo "Phone: " . htmlspecialchars($user['phone'] ?? '') . "<br>";
$pid = $user['pid'];
// Fetch all users


$cctvQuery = "
    SELECT c.*, 
           p.acknowlegement, 
           p.complain_name, 
           p.mobile, 
           p.incident_date_time, 
           p.total_fraud_amount, 
           p.total_lien_amount, 
           p.atf, 
           p.pid, 
           p.status, 
           p.time_stamp
    FROM cctv c
    LEFT JOIN cyber_police p ON c.c_id = p.id
    WHERE p.pid = '$pid'
    ORDER BY c.id DESC
";



$resultCCtv = mysqli_query($con, $cctvQuery);


?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="icon" href="images/favicon.ico" sizes="32x32" type="image/x-icon">
    <title>BANK-CCTV</title>
    <!-- Main CSS -->
    <link rel="stylesheet" type="text/css" href="css/main.css">

    <!-- Bootstrap Icons -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css">
</head>

<body class="app sidebar-mini">
    <!-- Navbar-->
    <?php include "header.php" ?>
    <!-- Sidebar menu-->
    <div class="app-sidebar__overlay" data-toggle="sidebar"></div>
    <aside class="app-sidebar">

        <?php include "./common/name.php" ?>


        <?php include 'sidebar.php' ?>


    </aside>

    <main class="app-content">
        <div class="app-title">
            <div>
                <h1>CCTV</h1>
            </div>
            <ul class="app-breadcrumb breadcrumb">
                <li class="breadcrumb-item"><i class="bi bi-house-door fs-6"></i> BANK</li>
                <li class="breadcrumb-item"><a href="#">CCTV</a></li>
            </ul>
        </div>

        <div class="tile-title-w-btn d-flex justify-content-end">
            <p class="mb-10">
                <a href="./export/cctv_report_pdf.php" class="btn btn-primary icon-btn" target="_blank">
                    <i class="bi bi-plus-square me-2"></i>Export to PDF
                </a>

            </p>
            <p class="mb-10"> &nbsp;&nbsp;</p>
            <p class="mb-10">
                <a href="./export/cctv_report_excel.php" class="btn btn-primary icon-btn">
                    <i class="bi bi-plus-square me-2"></i>Export to EXCEL
                </a>
            </p>
            <p class="mb-10"> &nbsp;&nbsp;</p>


            <p class="mb-10">
                <a href="add_cctv.php" class="btn btn-primary icon-btn">
                    <i class="bi bi-plus-square me-2"></i>Add
                </a>
            </p>
        </div>


        <div class="row">
            <div class="col-md-12">
                <div class="tile">
                    <div class="tile-body">
                        <div class="table-responsive">
                            <table class="table table-hover table-bordered" id="sampleTable">
                                <thead>
                                    <tr>
                                        <th>ID</th>
                                        <th>Acknowledgement</th>
                                        <th>CCTV</th>
                                        <th>Update</th>
                                        <th>View</th>
                                        <th>Status</th>
                                    </tr>
                                    <tr>
                                        <th>આઈ.ડી.</th>
                                        <th>એકનૉલેજમેન્ટ નંબર / એફ.આઈ.આર નંબર</th>
                                        <th>સી.સી.ટી.વી. ફૂટેજ ની ડિટેલ્સ</th>
                                        <th>Update</th>
                                        <th>જુઓ</th>
                                        <th>સ્થિતિ</th>
                                    </tr>

                                </thead>
                                <tbody>
                                    <?php if (mysqli_num_rows($resultCCtv) > 0): ?>
                                    <?php $serial = 1; ?>
                                    <?php while($row = mysqli_fetch_assoc($resultCCtv)): ?>
                                    <tr>
                                        <td><?= $serial++; ?></td>
                                        <td>
                                            <?php
        if (!empty($row['acknowlegement'])) {
            echo htmlspecialchars($row['acknowlegement']) . '<br>';
            echo htmlspecialchars($row['complain_name']) . '<br>';
            echo htmlspecialchars($row['mobile']);
        } else {
            echo '-';
        }
        ?>
                                        </td>

                                        <td>
                                            <div class="table-responsive">
                                                <table class="table table-hover table-bordered" id="sampleTable">
                                                    <thead>
                                                        <tr>
                                                            <th>Bank Name</th>
                                                            <th>ATM ID</th>
                                                            <th>Start Date/Time</th>
                                                            <th>End Date/Time</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        <?php
            $cctv_details = $row['cctv_details'];
            $bank_accounts = json_decode($cctv_details, true);

            if (is_array($bank_accounts) && count($bank_accounts) > 0) {
                foreach ($bank_accounts as $bank) {
                    echo '<tr>';
                    echo '<td>' . htmlspecialchars($bank['bank_name']) . '</td>';
                    echo '<td>' . htmlspecialchars($bank['atm_id']) . '</td>';
                    echo '<td>' . htmlspecialchars($bank['start_date_time']) . '</td>';
                    echo '<td>' . htmlspecialchars($bank['end_date_time']) . '</td>';
                    echo '</tr>';
                }
            } else {
                echo '<tr><td colspan="4" class="text-center">No bank account details available.</td></tr>';
            }
            ?>
                                                    </tbody>
                                                </table>
                                            </div>

                                        </td>

                                        <td>
                                            <form action="update_cctv.php" method="post">
                                                <input type="hidden" name="record_id"
                                                    value="<?= htmlspecialchars($row['id']) ?>">
                                                <input type="hidden" name="print" value="true">
                                                <button type="submit" class="btn btn-primary">Update</button>
                                            </form>
                                        </td>

                                        <td>
                                            <form action="view_cctv.php" method="post" target="_blank">
                                                <input type="hidden" name="record_id"
                                                    value="<?= htmlspecialchars($row['id']) ?>">
                                                <input type="hidden" name="print" value="true">
                                                <button type="submit" class="btn btn-primary">View</button>
                                            </form>
                                        </td>

                                        <td>
                                            <form action="update_status_cctv.php" method="POST">
                                                <input type="hidden" name="id" value="<?= $row['id'] ?>">
                                                <select name="status" class="form-control"
                                                    onchange="this.form.submit()">
                                                    <option value="Pending"
                                                        <?= ($row['status'] == 'Pending') ? 'selected' : '' ?>>Pending
                                                    </option>
                                                    <option value="KYC Done"
                                                        <?= ($row['status'] == 'KYC Done') ? 'selected' : '' ?>>KYC Done
                                                    </option>
                                                </select>
                                            </form>
                                        </td>

                                    </tr>
                                    <?php endwhile; ?>
                                    <?php else: ?>
                                    <?php endif; ?>

                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>

        </div>



    </main>
    <!-- Essential javascripts for application to work-->
    <script src="js/jquery-3.7.0.min.js"></script>
    <script src="js/bootstrap.min.js"></script>
    <script src="js/main.js"></script>
    <!-- Page specific javascripts-->
    <link rel="stylesheet" href="https://cdn.datatables.net/v/bs5/dt-1.13.4/datatables.min.css" />
    <!-- Data table plugin-->
    <script type="text/javascript" src="js/plugins/jquery.dataTables.min.js"></script>
    <script type="text/javascript" src="js/plugins/dataTables.bootstrap.min.js"></script>

    <script type="text/javascript">
    $('#sampleTable').DataTable();
    </script>
    <!-- Google analytics script-->

</body>

</html>