<?php
session_start();
include "config.php";

// Redirect if user is not logged in
if (!isset($_SESSION['user'])) {
    header("Location: index.php");
    exit();
}

// Get user details from session
$user = $_SESSION['user'];

//echo "Welcome " . htmlspecialchars($user['name'] ?? 'User') . "<br>";
//echo "Email: " . htmlspecialchars($user['email'] ?? '') . "<br>";
//echo "Phone: " . htmlspecialchars($user['phone'] ?? '') . "<br>";

// Fetch all users
$pid = $user['pid'];

$ATFQuery = "SELECT * FROM `cyber_police` WHERE `pid`='$pid' ORDER BY `id` DESC";
$resultATF = mysqli_query($con, $ATFQuery);


?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="icon" href="images/favicon.ico" sizes="32x32" type="image/x-icon">

    <title>Dashboard</title>

    <!-- Main CSS -->
    <link rel="stylesheet" type="text/css" href="css/main.css">

    <!-- Bootstrap Icons -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css">
</head>

<body class="app sidebar-mini">
    <!-- Navbar-->
    <?php include "header.php" ?>


    <!-- Sidebar menu-->
    <div class="app-sidebar__overlay" data-toggle="sidebar"></div>
    <aside class="app-sidebar">

        <?php include "./common/name.php" ?>


        <?php include 'sidebar.php' ?>


    </aside>


    <main class="app-content">
        <div class="app-title">
            <div>
                <h1><i class="bi bi-speedometer"></i> Add Data</h1>
            </div>
            <ul class="app-breadcrumb breadcrumb">
                <li class="breadcrumb-item"><i class="bi bi-house-door fs-6"></i></li>
                <li class="breadcrumb-item"><a href="main.php">Dashboard</a></li>
            </ul>
        </div>

        <div class="text-end mt-4">
            <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addATFModal">
                <i class="fa fa-save me-2"></i>ADD
            </button>
        </div>

        <br>

        <div class="row">
            <div class="col-md-12">
                <div class="tile">
                    <div class="tile-body">
                        <div class="table-responsive">
                            <table class="table table-hover table-bordered" id="sampleTable">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>Acknowlegement No/Fir No</th>
                                        <th>Complain Name</th>
                                        <th>Mobile</th>
                                        <th>Incident of Date Time</th>
                                        <th>Total Fraud Amount</th>
                                        <th>Total Lien Amount</th>
                                        <th>Status</th>
                                    </tr>
                                    <tr>
                                        <th>#</th>
                                        <th>અકનૉલેજમેન્ટ નં./FIR નંબર</th>
                                        <th>ફરિયાદીનું નામ</th>
                                        <th>મોબાઇલ નંબર</th>
                                        <th>ઘટનાની તારીખ અને સમય</th>
                                        <th>ઠગાઈની કુલ રકમ</th>
                                        <th>કુલ અટકેલી રકમ</th>
                                        <th>સ્થિતિ</th>
                                    </tr>

                                </thead>
                                <tbody>
                                    <?php if (mysqli_num_rows($resultATF) > 0): ?>
                                        <?php $serial = 1; ?>

                                        <?php while ($row = mysqli_fetch_assoc($resultATF)): ?>
                                            <tr>
                                                <td><?= $serial++; ?></td>
                                                <td><?= htmlspecialchars($row['acknowlegement']) ?></td>
                                                <td><?= htmlspecialchars($row['complain_name']) ?></td>
                                                <td><?= htmlspecialchars($row['mobile']) ?></td>
                                                <td>
                                                    <?php
                                                    if (!empty($row['incident_date_time'])) {
                                                        $dt = new DateTime($row['incident_date_time']);
                                                        echo $dt->format('d m Y') . '<br>' . $dt->format('h:i:s A');
                                                    }
                                                    ?>
                                                </td>

                                                <td><?= htmlspecialchars($row['total_fraud_amount']) ?></td>
                                                <td><?= htmlspecialchars($row['total_lien_amount']) ?></td>
                                                <td>
                                                    <button type="button" class="btn btn-sm btn-primary updateStatusLink"
                                                        data-id="<?= $row['id'] ?>"
                                                        data-status="<?= htmlspecialchars($row['status']) ?>"
                                                        data-atf="<?= htmlspecialchars($row['atf']) ?>" data-bs-toggle="modal"
                                                        data-bs-target="#updateStatusModal">
                                                        <?= htmlspecialchars($row['status']) ?>
                                                    </button>
                                                </td>


                                            </tr>
                                        <?php endwhile; ?>
                                    <?php else: ?>
                                    <?php endif; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Add Record Modal -->
        <div class="modal fade" id="addATFModal" tabindex="-1" aria-labelledby="addRecordLabel" aria-hidden="true">
            <div class="modal-dialog modal-lg modal-dialog-centered">
                <div class="modal-content">

                    <div class="modal-header">
                        <h5 class="modal-title" id="addRecordLabel">Add New Record</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>

                    <div class="modal-body">
                        <form method="POST" action="add_atf.php" enctype="multipart/form-data">
                            <div class="row">

                                <!-- LEFT COLUMN -->
                                <div class="col-md-6">
                                    <!-- Reference Type Selection -->
                                    <div class="mb-3">
                                        <label class="form-label d-block">Select Type:</label>
                                        <div class="form-check form-check-inline">
                                            <input class="form-check-input" type="radio" name="reference_type"
                                                id="acknowledgementRadio" value="0" checked onchange="updateLabel()">
                                            <label class="form-check-label"
                                                for="acknowledgementRadio">Acknowledgement</label>
                                        </div>
                                        <div class="form-check form-check-inline">
                                            <input class="form-check-input" type="radio" name="reference_type"
                                                id="ticketRadio" value="1" onchange="updateLabel()">
                                            <label class="form-check-label" for="ticketRadio">Ticket</label>
                                        </div>
                                        <div class="form-check form-check-inline">
                                            <input class="form-check-input" type="radio" name="reference_type"
                                                id="firRadio" value="2" onchange="updateLabel()">
                                            <label class="form-check-label" for="firRadio">FIR</label>
                                        </div>
                                    </div>

                                    <!-- Reference Number Input -->
                                    <div class="mb-3">
                                        <label class="form-label">Acknowledgement Number/Fir No</label>
                                        <input class="form-control" type="number" name="ack_no"
                                            placeholder="Enter Number" required>
                                    </div>

                                    <!-- Complainant Name -->
                                    <div class="mb-3">
                                        <label class="form-label">Complainant Name/Victim name /અરજદારનું નામ </label>
                                        <input class="form-control" type="text" name="complainant_name"
                                            placeholder="Enter Complainant Name" required>
                                    </div>

                                    <!-- Mobile -->
                                    <div class="mb-3">
                                        <label class="form-label">Mobile</label>
                                        <input class="form-control" type="text" name="mobile"
                                            placeholder="Enter Mobile No" required>
                                    </div>
                                </div>

                                <!-- RIGHT COLUMN -->
                                <div class="col-md-6">
                                    <!-- Incident Date & Time -->
                                    <div class="mb-3">
                                        <label class="form-label">Incident Date & Time</label>
                                        <input class="form-control" type="datetime-local" name="incident_date_time"
                                            required>
                                    </div>

                                    <!-- Total Fraud Amount -->
                                    <div class="mb-3">
                                        <label class="form-label">Total Fraud Amount</label>
                                        <input class="form-control" type="text" name="total_fraud_amount"
                                            placeholder="Enter Total Fraud Amount" required>
                                    </div>

                                    <!-- Total Lien Amount -->
                                    <div class="mb-3">
                                        <label class="form-label">Total Lien Amount</label>
                                        <input class="form-control" type="text" name="total_lien_amount"
                                            placeholder="Enter Total Lien Amount" required>
                                    </div>
                                </div>
                            </div>

                            <!-- Modal Footer -->
                            <div class="modal-footer">
                                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                                <button type="submit" class="btn btn-primary">
                                    <i class="fa fa-save me-2"></i>Submit
                                </button>
                            </div>
                        </form>
                    </div>

                </div>
            </div>
        </div>


        <div class="modal fade" id="updateStatusModal" tabindex="-1" aria-labelledby="updateStatusLabel"
            aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content">

                    <div class="modal-header">
                        <h5 class="modal-title" id="updateStatusLabel">Update Status & Type</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                    </div>

                    <div class="modal-body">
                        <form id="updateStatusForm" method="POST" action="update_status_atf.php">
                            <input type="hidden" name="id" id="recordId">

                            <div class="mb-3">
                                <label class="form-label">Status</label>
                                <textarea class="form-control" name="status" id="statusText" rows="2"
                                    placeholder="Enter status here"
                                    required><?= htmlspecialchars($row['status'] ?? '') ?></textarea>
                            </div>


                            <div class="mb-3">
                                <label class="form-label">Type (ATF)</label>
                                <select class="form-select" name="atf" id="atfSelect" required>
                                    <option value="0">Acknowledgement</option>
                                    <option value="1">Ticket</option>
                                    <option value="2">FIR</option>
                                </select>
                            </div>

                            <div class="text-end">
                                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                                <button type="submit" class="btn btn-primary">Update</button>
                            </div>

                        </form>
                    </div>

                </div>
            </div>
        </div>





    </main>
    <!-- Essential javascripts for application to work-->
    <script src="js/jquery-3.7.0.min.js"></script>
    <script src="js/bootstrap.min.js"></script>
    <script src="js/main.js"></script>
    <!-- Page specific javascripts-->
    <link rel="stylesheet" href="https://cdn.datatables.net/v/bs5/dt-1.13.4/datatables.min.css" />

    <script src="https://cdn.datatables.net/1.13.4/js/dataTables.bootstrap5.min.js"></script>


    <!-- Data table plugin-->
    <script type="text/javascript" src="js/plugins/jquery.dataTables.min.js"></script>
    <script type="text/javascript" src="js/plugins/dataTables.bootstrap.min.js"></script>
    <script type="text/javascript">
        $("#sampleTable").DataTable();
    </script>


    <script>
        document.querySelectorAll('.updateStatusLink').forEach(function (link) {
            link.addEventListener('click', function () {
                const id = this.dataset.id;
                const status = this.dataset.status;
                const atf = this.dataset.atf;

                document.getElementById('recordId').value = id;
                document.getElementById('statusSelect').value = status;
                document.getElementById('atfSelect').value = atf;
            });
        });
    </script>


</body>

</html>