<?php
header('Content-Type: text/html; charset=UTF-8');
?>

<?php
include "config.php";

$currentDate = date("d/m/Y");
$kycid = $_POST['kycid'] ?? '';
$print = $_POST['print'] ?? '';
$acknowledgement_no = "";
$type = "";
$complainantName = "";
$policestationId = "";

if (!empty($kycid)) {

    $kycid = mysqli_real_escape_string($con, $kycid);

    // Fetch KYC data
    $kycQuery = "SELECT id, c_id, police_id, subject_id, notice_id, created_by, created_at 
                 FROM kyc 
                 WHERE id = $kycid";
    $kycResult = mysqli_query($con, $kycQuery);

    if ($kycRow = mysqli_fetch_assoc($kycResult)) {
        $c_id = $kycRow['c_id'];
        $policeId = $kycRow['police_id'];
        $subjectId = $kycRow['subject_id'];
        $noticeId = $kycRow['notice_id'];

        // Fetch cyber_police data using c_id
        $cpQuery = "SELECT * FROM cyber_police WHERE id = '$c_id'";
        $cpResult = mysqli_query($con, $cpQuery);

        if ($cpRow = mysqli_fetch_assoc($cpResult)) {
            $type = $cpRow['atf'];

            // Map ATF type to human-readable string
            switch ($type) {
                case '0':
                    $typeLabel = "Acknowledgement";
                    break;
                case '1':
                    $typeLabel = "FIR";
                    break;
                case '2':
                    $typeLabel = "Ticket"; // if you have a third type
                    break;
                default:
                    $typeLabel = "Unknown";
                    break;
            }

            $acknowledgement_no = $cpRow['acknowlegement'];
            $complainant_name = $cpRow['complain_name'];
            $policestationId = $cpRow['pid'];
            $mobile = $cpRow['mobile'];
            $incident_date_time = $cpRow['incident_date_time'];
            $total_fraud_amount = $cpRow['total_fraud_amount'];
            $total_lien_amount = $cpRow['total_lien_amount'];
            $atf = $cpRow['atf'];
            $status = $cpRow['status'];
            $time_stamp = $cpRow['time_stamp'];
        } else {
            echo "No cyber_police record found for this KYC.";
            exit;
        }
    } else {
        echo "KYC record not found.";
        exit;
    }

    $getNotice = "SELECT `id`, `n_name`, `time_stamp` FROM `notice` WHERE `id` = '$noticeId' LIMIT 1";

    $resultNotice = $con->query($getNotice);

    if ($resultNotice && $resultNotice->num_rows > 0) {
        $row = $resultNotice->fetch_assoc();

        // Example: To access station name
        $noticeName = $row['n_name'];

    }
    $getSubject = "SELECT `id`, `s_name`, `time_stamp` FROM `subject` WHERE `id` = '$subjectId'  LIMIT 1";

    $resultSubject = $con->query($getSubject);

    if ($resultSubject && $resultSubject->num_rows > 0) {
        $row = $resultSubject->fetch_assoc();

        // Example: To access station name
        $subjectName = $row['s_name'];

    }

    $getPoliceStation = "SELECT `id`, `spid`, `p_name`, `p_address`, `p_landline`, `p_number`, `p_email`, `timestamp` 
                     FROM `policestation` 
                     WHERE `id` = '$policestationId' 
                     LIMIT 1";

    $resultPoliceStation = $con->query($getPoliceStation);

    if ($resultPoliceStation && $resultPoliceStation->num_rows > 0) {
        $row = $resultPoliceStation->fetch_assoc();

        // Example: To access station name
        $policeStationName = $row['p_name'];
        $pAddress = $row['p_address'];
        $pLandLine = $row['p_landline'];
        $pNumber = $row['p_number'];
        $pEmail = $row['p_email'];
    }

    $getPoliceInspector = "SELECT `id`, `pid`, `i_name`, `i_number`, `i_designation`, `i_sign` FROM `police` 
                                 WHERE `id` = '$policeId' 
                     LIMIT 1";

    $resultPoliceInspector = $con->query($getPoliceInspector);

    if ($resultPoliceInspector && $resultPoliceInspector->num_rows > 0) {
        $row = $resultPoliceInspector->fetch_assoc();

        // Example: To access station name
        $policeName = $row['i_name'];
        $policeNumber = $row['i_number'];
        $policeDesignation = $row['i_designation'];
        $sign = $row['i_sign'];

    }

    if ($print === 'true') {
        echo '<script>window.onload = function() { window.print(); }</script>';
    }


    $sql = "SELECT `id`, `kyc_id`, `bank_id`, `bank_name`, `account_number`, `ifsc_code`, `account_holder`, `transaction_id` 
            FROM `bank_accounts` 
            WHERE `kyc_id` = '$kycid'";

    $result = $con->query($sql);

    if ($result && $result->num_rows > 0) {
        while ($row = $result->fetch_assoc()) {
            ?>

            <!DOCTYPE html>
            <html>

            <head>
                <meta charset="UTF-8">
                <title>BANK-KYC</title>
                <link rel="stylesheet" href="https://www.w3schools.com/w3css/4/w3.css">
                <link rel="stylesheet" href="css/styles.css"> <!-- External CSS file -->

            </head>

            <body>

                <div class="a4-container">
                    <!-- Header -->
                    <div class="header-container">
                        <img src="images/gp_logo.png" class="logo-left" alt="Police Logo">
                        <div class="header-text">
                            <h2><?php echo $policeStationName ?></h2>
                            <p><?php echo htmlspecialchars($pAddress); ?></p>
                            <p>Tel. no. <?php echo $pLandLine ?></p>
                            <p class="email">E-mail ID: <?php echo $pEmail; ?></p>
                        </div>
                        <img src="images/azadi.png" class="logo-right" alt="Azadi Ka Amrit Mahotsav">
                    </div>

                    <!-- Title -->
                    <div class="section-title">
                        <?php echo strtoupper($noticeName); ?>
                    </div>

                    <!-- Outward block right aligned -->
                    <div class="outward-details">
                        <div class="outward-box">
                            <b>
                                Outward number _________/2025,<br>
                                Date-<?php echo $currentDate; ?>
                            </b>
                        </div>
                    </div>

                    <!-- Recipient Info -->
                    <div class="to-box">
                        <b>
                            To,<br>
                            Nodal officer/The Manager<br>
                            <?php echo htmlspecialchars($row['bank_name']); ?>
                        </b>
                    </div>

                    <div class="subject">
                        Subject: <?php echo $subjectName; ?>
                    </div>


                    <div class="letter-body">
                        <p>Dear Sir/Madam,</p>
                        <p>
                            &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;

                            I,<b><?php echo $policeName; ?></b>, <b><?php echo $policeDesignation; ?></b>,
                            <b><?php echo $policeStationName; ?></b>, am
                            currently
                            investigating
                            a case
                            related to

                            <?php
                            $typeLabel = '';

                            if ($type == 0) {
                                $typeLabel = 'Acknowledgement Number ';
                            } elseif ($type == 1) {
                                $typeLabel = 'Ticket Number ';
                            } elseif ($type == 2) {
                                $typeLabel = 'FIR Number';
                            }
                            ?>
                            <b><?php echo $typeLabel; ?> : <?php echo $acknowledgement_no; ?></b>, filed by the
                            complainant <b><?php echo $complainantName; ?></b>. The complaint involves a
                            fraudulent financial scam, where the accused are engaged in
                            money
                            fraud, fake transactions, and deceptive financial activities.<br>
                            &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                            As per our investigation, the fraudsters have committed offenses under BNS 2023, Section 318(4)
                            and Section 66(D) of the Information Technology Act, 2008. In connection with this case, I formally
                            request you to provide detailed information on the account(s) involved in these fraudulent
                            transactions.
                        </p>
                    </div>

                    <div class="account-table">
                        <table class="w3-table-all w3-bordered">
                            <thead>
                                <tr>
                                    <th>Account Number</th>
                                    <th>IFSC Code</th>
                                    <th>Account Holder Name</th>
                                    <th>Transaction ID</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td><?php echo htmlspecialchars($row['account_number']) ?></td>
                                    <td><?php echo htmlspecialchars($row['ifsc_code']) ?></td>
                                    <td><?php echo htmlspecialchars($row['account_holder']) ?></td>
                                    <td><?php echo htmlspecialchars($row['transaction_id']) ?></td>

                                </tr>
                            </tbody>
                        </table>
                    </div>


                    <div class="instruction-block">
                        Hence, as powers given in BNSS 2023, Section 94 you are instructed that:
                        <ol>
                            <li>To mandatorily provide beneficiary details of above-mentioned Account.</li>
                            <li>Copy (soft copy) of above customer's KYC.</li>
                            <li>Date of account opening.</li>
                            <li>Complete transaction from accounts opened to <?php echo $currentDate ?> date.</li>
                            <li>Contact Number of account Holder.</li>
                            <li>Detail of Home branch.</li>
                            <li>IP Address of transaction.</li>
                        </ol>
                        <p>
                            So, you are hereby requested to provide beneficiary details of above-mentioned transaction at the
                            earliest.<br>
                            <b>Thanking You</b>
                        </p>
                    </div>


                    <div class="w3-row" style="margin-top:30px; display:flex; justify-content:center; align-items:flex-start;">

                        <!-- EMPTY SPACE – fixed 150px -->
                        <div style="width:150px;"></div>

                        <!-- CENTER : Stamp -->
                        <div style="text-align:center; width:150px;">
                            <img src="http://localhost/spoffice/uploads/<?= htmlspecialchars('Upload Stamp Image.png') ?>"
                                alt="Stamp" width="150">
                        </div>

                        <!-- RIGHT : Signature + Details -->
                        <div style="text-align:center; margin-left:120px;">
                            <img src="http://localhost/spoffice/uploads/<?= htmlspecialchars($sign) ?>" alt="Signature"
                                width="150"><br>

                            <b>
                                (<?= strtoupper($policeName); ?>)<br>
                                <?= strtoupper($policeDesignation); ?><br>
                                <?= strtoupper($policeStationName); ?><br>
                                <?= strtoupper($pAddress); ?><br>
                                <?= strtoupper($policeNumber); ?>
                            </b>
                        </div>

                    </div>



                </div>

            </body>

            </html>

            <?php

            //     echo "Bank Name: " . htmlspecialchars($row['bank_name']) . "<br>";
            //     echo "Account Number: " . htmlspecialchars($row['account_number']) . "<br>";
            //     echo "IFSC Code: " . htmlspecialchars($row['ifsc_code']) . "<br>";
            //     echo "Account Holder: " . htmlspecialchars($row['account_holder']) . "<br>";
            //     echo "Transaction ID: " . htmlspecialchars($row['transaction_id']) . "<br><hr>";
        }
    } else {
        echo "No bank details found for KYC ID: " . htmlspecialchars($kycid);
    }
} else {
    echo "No KYC ID provided.";
}
?>