<?php
session_start();
include "config.php";
$currentDate = date("d/m/Y");
if (!isset($_SESSION['user'])) {
    echo '<script>window.location.href = "index.php";</script>';
    exit();
}

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['domain_id'])) {
    $platform = 'Domain';
    $print = $_POST['print'] ?? '';
    $Id = intval($_POST['domain_id']);

    // Fetch Facebook data
    $query = "SELECT * FROM `domain_data` WHERE id = $Id";
    $result = mysqli_query($con, $query);

    if (!$result || mysqli_num_rows($result) == 0) {
        exit("No record found.");
    }

    $data = mysqli_fetch_assoc($result);

    $c_id = htmlspecialchars($data['c_id']);


    $policeId = $data['police_id'];
    $subjectId = $data['s_id'];
    $noticeId = $data['n_id'];

    // Fetch cyber_police data using c_id
    $cpQuery = "SELECT * FROM cyber_police WHERE id = '$c_id'";
    $cpResult = mysqli_query($con, $cpQuery);

    if ($cpRow = mysqli_fetch_assoc($cpResult)) {
        $type = $cpRow['atf'];

        // Map ATF type to human-readable string
        switch ($type) {
            case '0':
                $typeLabel = "Acknowledgement";
                break;
            case '1':
                $typeLabel = "FIR";
                break;
            case '2':
                $typeLabel = "Ticket"; // if you have a third type
                break;
            default:
                $typeLabel = "Unknown";
                break;
        }

        $acknowledgement_no = $cpRow['acknowlegement'];
        $complainant_name = $cpRow['complain_name'];
        $pid = $cpRow['pid'];
        $mobile = $cpRow['mobile'];
        $incident_date_time = $cpRow['incident_date_time'];
        $total_fraud_amount = $cpRow['total_fraud_amount'];
        $total_lien_amount = $cpRow['total_lien_amount'];
        $atf = $cpRow['atf'];
        $status = $cpRow['status'];
        $time_stamp = $cpRow['time_stamp'];
    }


    //$type = htmlspecialchars($data['atf']);
    //$acknowledgement_no = htmlspecialchars($data['ack_no']);
    //$pid = intval($data['pid']);
    //$policeId = intval($data['police_id']);
    //$noticeId = intval($data['n_id']);
    //$subjectId = intval($data['s_id']);

    $policeStationName = "";
    $pAddress = "";
    $pLandLine = "";
    $pEmail = "";
    $noticeName = "";
    $policeName = "";
    $policeDesignation = "";
    $complainantName = "";
    $policeNumber = "";
    $subjectName = "";

    // Fetch Police Station
    $policeStation = $con->query("SELECT * FROM `policestation` WHERE id = $pid LIMIT 1")->fetch_assoc();

    // Fetch Police Inspector
    $police = $con->query("SELECT * FROM `police` WHERE id = $policeId LIMIT 1")->fetch_assoc();

    // Fetch Notice
    $notice = $con->query("SELECT `n_name` FROM `notice` WHERE id = $noticeId LIMIT 1")->fetch_assoc();

    // Fetch Subject
    $subject = $con->query("SELECT `s_name` FROM `subject` WHERE id = $subjectId LIMIT 1")->fetch_assoc();

    // Display Information
// echo "<h3>Facebook Data Details:</h3>";
// echo "<p><strong>ID:</strong> {$data['id']}</p>";
// echo "<p><strong>UID:</strong> {$data['uid']}</p>";
// echo "<p><strong>Acknowledgement No:</strong> {$acknowledgement_no}</p>";
// echo "<p><strong>Fraud Type:</strong> {$data['fraud_type']}</p>";
// echo "<p><strong>Notice:</strong> {$notice['n_name']}</p>";
// echo "<p><strong>Subject:</strong> {$subject['s_name']}</p>";
// echo "<p><strong>Created At:</strong> {$data['created_at']}</p>";

    $policeStationName = $policeStation['p_name'];
    $pAddress = $policeStation['p_address'];
    $pLandLine = $policeStation['p_landline'];
    $pEmail = $policeStation['p_email'];
    $noticeName = $notice['n_name'];
    $subjectName = $subject['s_name'];
    $policeName = $police['i_name'];
    $policeDesignation = $police['i_designation'];
    $policeNumber = $police['i_number'];
    $complainantName = "";

    // Display Police Station
// echo "<h4>Police Station:</h4>";
// echo "<p><strong>Name:</strong> {$policeStation['p_name']}</p>";
// echo "<p><strong>Address:</strong> {$policeStation['p_address']}</p>";
// echo "<p><strong>Landline:</strong> {$policeStation['p_landline']}</p>";
// echo "<p><strong>Mobile:</strong> {$policeStation['p_number']}</p>";
// echo "<p><strong>Email:</strong> {$policeStation['p_email']}</p>";

    // // Display Police Inspector
// echo "<h4>Police Inspector:</h4>";
// echo "<p><strong>Name:</strong> {$police['i_name']}</p>";
// echo "<p><strong>Mobile:</strong> {$police['i_number']}</p>";
// echo "<p><strong>Designation:</strong> {$police['i_designation']}</p>";

} else {
    echo "Invalid request.";
}


if ($print === 'true') {
    echo '<script>window.onload = function() { window.print(); }</script>';
}

?>

<!DOCTYPE html>
<html>

<head>
    <meta charset="UTF-8">
    <title><?php echo strtoupper($platform); ?></title>
    <link rel="stylesheet" href="https://www.w3schools.com/w3css/4/w3.css">
    <link rel="stylesheet" href="css/styles.css"> <!-- External CSS file -->
</head>

<body>

    <div class="a4-container">
        <!-- Header -->
        <div class="header-container">
            <img src="images/gp_logo.png" class="logo-left" alt="Police Logo">
            <div class="header-text">
                <h2><?php echo $policeStationName ?></h2>
                <p><?php echo htmlspecialchars($pAddress); ?></p>
                <p>Tel. no. <?php echo $pLandLine ?></p>
                <p class="email">E-mail ID: <?php echo $pEmail; ?></p>
            </div>
            <img src="images/azadi.png" class="logo-right" alt="Azadi Ka Amrit Mahotsav">
        </div>

        <!-- Title -->
        <div class="section-title">
            <?php echo strtoupper($noticeName); ?>
        </div>

        <!-- Outward block right aligned -->
        <div class="outward-details">
            <div class="outward-box">
                <b>
                    Outward number _________/2025,<br>
                    Date-<?php echo $currentDate; ?>
                </b>
            </div>
        </div>

        <!-- Recipient Info -->
        <div class="to-box">
            <b>
                To,<br>
                Domain & Hosting Provider
            </b>
        </div>

        <div class="subject">
            Subject: <?php echo $subjectName; ?>
        </div>


        <div class="letter-body">
            <p>Dear Sir/Madam,</p>

            <p>
                &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                I, the undersigned <b><?php echo $policeName; ?></b>, currently serving as
                <b><?php echo $policeDesignation; ?></b>
                at <b><?php echo $policeStationName; ?></b>, am the designated Investigating Officer for the case
                registered under

                <?php
                $typeLabel = '';

                if ($type == 0) {
                    $typeLabel = 'Acknowledgement Number ';
                } elseif ($type == 1) {
                    $typeLabel = 'Ticket Number ';
                } elseif ($type == 2) {
                    $typeLabel = 'FIR Number';
                }
                ?>
                <b><?php echo $typeLabel; ?>: <?php echo htmlspecialchars($acknowledgement_no); ?></b>

                This case pertains to suspected cyber activities, including financial fraud, identity impersonation,
                online cheating, and possible violations under the Information Technology Act. During the investigation,
                it was found that the following <b><?= ucfirst($platform) ?> ID(s)</b> may be involved in the
                aforementioned activities.<br>
                We request your cooperation in providing relevant account, domain, or hosting information to assist with
                this investigation.
            </p>
            </p>
        </div>

        <div class="account-table">
            <table class="w3-table-all w3-bordered">
                <thead>
                    <tr>
                        <th>Sr No.</th>
                        <th><?= ucfirst($platform) ?> ID</th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    $domainIds = json_decode($data['domain_id'], true);
                    if (!is_array($domainIds))
                        $domainIds = explode(',', $data['domain_id']);
                    foreach ($domainIds as $i => $fbId) {
                        echo "<tr>
                    <td>" . ($i + 1) . "</td>
                    <td>" . htmlspecialchars(trim($fbId)) . "</td>
                </tr>";
                    }
                    ?>
                </tbody>
            </table>
        </div>

        <div class="instruction-block">
            <p>
                In accordance with the provisions of <b>BNS Section 318(4)</b> and <b>Section 66(B) of the Information
                    Technology Act, 2008</b>,
                I hereby request access to the following information related to the listed <b> <?= ucfirst($platform) ?>
                    account(s):</b>
            </p>
            <ol>
                <li>Domain registration and ownership details (Name, Email, Contact No., etc.)</li>
                <li>Hosting service provider and server/IP history</li>
                <li>Login IP logs and access locations</li>
                <li>Linked or associated domain names/accounts</li>
                <li>Account creation/modification timeline</li>
                <li>Transaction or billing records (if any)</li>
                <li>Complaints or reports filed against the ID/domain</li>
            </ol>

            <p>
                Kindly treat this matter as urgent and confidential, as it relates to an active criminal
                investigation.<br>
                <b>Thanking you,</b>
            </p>

        </div>

        <!-- Signature Wrapper -->
        <div class="signature-container">
            <div class="signature-block">
                <b>
                    (<?php echo strtoupper($policeName); ?>)<br>
                    <?php echo strtoupper($policeDesignation); ?><br>
                    <?php echo strtoupper($policeStationName); ?><br>
                    <?php echo strtoupper($pAddress); ?><br>
                    <?php echo strtoupper($policeNumber); ?>
                </b>
            </div>

        </div>


    </div>

</body>

</html>