<?php
session_start();
include "config.php";

if (!isset($_SESSION['user'])) {
    echo '<script>window.location.href = "index.php";</script>';
    exit();
}

$currentDate = date("d/m/Y");
$acknowledgement_no = "";
$complainantName = "";
$policeStationName = "";
$pAddress = "";
$pLandLine = "";
$pNumber = "";
$pEmail = "";
$policeName = "";
$policeNumber = "";
$policeDesignation = "";
$subjectName = "";
$noticeName = "";
$bankName = "";
$atmID = "";
$type = "";

if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['record_id'])) {
    $record_id = (int) $_POST['record_id'];
    $print = $_POST['print'] ?? '';
    $query = "SELECT * FROM cctv WHERE id = $record_id";
    $result = mysqli_query($con, $query);

    if ($result && mysqli_num_rows($result) > 0) {
        $data = mysqli_fetch_assoc($result);
        $cctvDetails = json_decode($data['cctv_details'], true);
        $c_id = $data['c_id'];

        // Fetch cyber_police data using c_id
        $cpQuery = "SELECT * FROM cyber_police WHERE id = '$c_id'";
        $cpResult = mysqli_query($con, $cpQuery);

        if ($cpRow = mysqli_fetch_assoc($cpResult)) {
            $type = $cpRow['atf'];

            // Map ATF type to human-readable string
            switch ($type) {
                case '0':
                    $typeLabel = "Acknowledgement";
                    break;
                case '1':
                    $typeLabel = "FIR";
                    break;
                case '2':
                    $typeLabel = "Ticket"; // if you have a third type
                    break;
                default:
                    $typeLabel = "Unknown";
                    break;
            }

            $acknowledgement_no = $cpRow['acknowlegement'];
            $complainant_name = $cpRow['complain_name'];
            $policestationId = $cpRow['pid'];
            $mobile = $cpRow['mobile'];
            $incident_date_time = $cpRow['incident_date_time'];
            $total_fraud_amount = $cpRow['total_fraud_amount'];
            $total_lien_amount = $cpRow['total_lien_amount'];
            $atf = $cpRow['atf'];
            $status = $cpRow['status'];
            $time_stamp = $cpRow['time_stamp'];

        }


        $policeId = $data['police_id'];
        $subjectId = $data['s_id'];
        $noticeId = $data['n_id'];

        $sqlPolice = "SELECT * FROM `policestation` WHERE `id` = $policestationId";

        $resultPolice = mysqli_query($con, $sqlPolice);

        if (mysqli_num_rows($resultPolice) > 0) {
            $row = mysqli_fetch_assoc($resultPolice);
            $policeStationName = $row['p_name'];
            $pAddress = $row['p_address'];
            $pLandLine = $row['p_landline'];
            $pNumber = $row['p_number'];
            $pEmail = $row['p_email'];
        } else {
            echo "No police station record found.";
        }

        $sqlPoliceInspector = "SELECT * FROM `police` WHERE `id` = $policeId";

        $resultPolice = mysqli_query($con, $sqlPoliceInspector);

        if (mysqli_num_rows($resultPolice) > 0) {
            $row = mysqli_fetch_assoc($resultPolice);
            $policeName = $row['i_name'];
            $policeNumber = $row['i_number'];
            $policeDesignation = $row['i_designation'];

        } else {
            echo "No police station record found.";
        }


        $sqlSubject = "SELECT * FROM `subject` WHERE `id` = $subjectId";

        $resultSubject = mysqli_query($con, $sqlSubject);

        if (mysqli_num_rows($resultSubject) > 0) {
            $row = mysqli_fetch_assoc($resultSubject);
            $subjectName = $row['s_name'];
        } else {
            echo "No police station record found.";
        }

        $sqlNotice = "SELECT * FROM `notice` WHERE `id` = $noticeId";

        $resultNotice = mysqli_query($con, $sqlNotice);

        if (mysqli_num_rows($resultNotice) > 0) {
            $row = mysqli_fetch_assoc($resultNotice);
            $noticeName = $row['n_name'];
        } else {
            echo "No police station record found.";
        }




    } else {
        echo "Invalid record ID.";
        exit();
    }
} else {
    echo "No record ID received.";
    exit();
}

if ($print === 'true') {
    echo '<script>window.onload = function() { window.print(); }</script>';
}

?>

<?php foreach ($cctvDetails as $item):
    $bankName = htmlspecialchars($item['bank_name']);
    $atmID = htmlspecialchars($item['atm_id']);
    $startDateTime = $item['start_date_time'];
    $endDateTime = $item['end_date_time'];
    ?>
<!DOCTYPE html>
<html>

<head>
    <meta charset="UTF-8">
    <title>BANK-CCTV</title>
    <link rel="stylesheet" href="https://www.w3schools.com/w3css/4/w3.css">
    <link rel="stylesheet" href="css/styles.css"> <!-- External CSS file -->
</head>

<body>

    <div class="a4-container">
        <!-- Header -->
        <div class="header-container">
            <img src="images/gp_logo.png" class="logo-left" alt="Police Logo">
            <div class="header-text">
                <h2><?php echo $policeStationName ?></h2>
                <p><?php echo htmlspecialchars($pAddress); ?></p>
                <p>Tel. no. <?php echo $pLandLine ?></p>
                <p class="email">E-mail ID: <?php echo $pEmail; ?></p>
            </div>
            <img src="images/azadi.png" class="logo-right" alt="Azadi Ka Amrit Mahotsav">
        </div>

        <!-- Title -->
        <div class="section-title">
            <?php echo strtoupper($noticeName); ?>
        </div>

        <!-- Outward block right aligned -->
        <div class="outward-details">
            <div class="outward-box">
                <b>
                    Outward number _________/2025,<br>
                    Date-<?php echo $currentDate; ?>
                </b>
            </div>
        </div>

        <!-- Recipient Info -->
        <div class="to-box">
            <b>
                To,<br>
                Nodal officer/The Manager<br>
                <?php echo $bankName; ?>
            </b>
        </div>


        <center style="margin-top: 5px;">
            <table>
                <tr>
                    <td><strong>Subject:</strong> <?php echo $subjectName . " " . $atmID; ?></td>
                </tr>
                <tr>
                    <td><strong>Reference:</strong> <?php
                        $typeLabel = '';

                        if ($type == 0) {
                            $typeLabel = 'Acknowledgement Number ';
                        } elseif ($type == 1) {
                            $typeLabel = 'Ticket Number ';
                        } elseif ($type == 2) {
                            $typeLabel = 'FIR Number';
                        }
                        ?>
                        <b><?php echo $typeLabel; ?> :
                            <strong><?php echo $acknowledgement_no; ?></strong>
                    </td>
                </tr>
            </table>
        </center>


        <div class="letter-body">
            <p>Dear Sir/Madam,</p>
            <p>
                &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                I, <b><?php echo strtoupper($policeName); ?></b>,
                <b><?php echo strtoupper($policeDesignation); ?></b> at
                <b><?php echo $policeStationName; ?></b>,
                am currently investigating a case registered under

                <?php
                    $typeLabel = '';

                    if ($type == 0) {
                        $typeLabel = 'Acknowledgement Number ';
                    } elseif ($type == 1) {
                        $typeLabel = 'Ticket Number ';
                    } elseif ($type == 2) {
                        $typeLabel = 'FIR Number';
                    }
                    ?>
                <b><?php echo $typeLabel; ?> : <?php echo $acknowledgement_no; ?></b>,
                lodged by the complainant <b><?php echo strtoupper($complainantName); ?></b>.
                The case pertains to a fraudulent financial transaction involving suspicious activity at one of your
                bank’s ATMs.
            </p>
            <p>
                As part of our investigation into this cyber fraud case under <b>BNS 2023 Section 318(4)</b> and
                <b>Section 66(D) of the Information Technology Act, 2008</b>, we request you to kindly provide the
                <b>CCTV footage of ATM ID: <?php echo $atmID; ?></b> for the relevant date and time linked to the
                transaction in
                question.
            </p>
            <p>
                This request is made under the powers conferred upon us under <b>BNSS 2023 Section 94</b> for the
                purpose of gathering crucial evidence.
            </p>


            <p>Kindly provide:</p>
            <ol>
                <li>
                    CCTV footage of ATM ID: <b><?php echo $atmID; ?></b> for the period,
                    from <b><?php echo $startDateTime; ?></b> to <b><?php echo $endDateTime ?></b>
                </li>
                <li>
                    Exact date and time details of any related transactions, if available.
                </li>
                <li>
                    Any additional logs or relevant ATM activity reports for verification.
                </li>
            </ol>
            <p>
                Your cooperation in this matter will assist us in proceeding further with the investigation and
                identifying the accused involved.
            </p>
            <p>Thanking you in panticipation.</p>

        </div>

        <!-- Signature Wrapper -->
        <div class="signature-container">
            <div class="signature-block">
                <b>
                    (<?php echo strtoupper($policeName); ?>)<br>
                    <?php echo strtoupper($policeDesignation); ?><br>
                    <?php echo strtoupper($policeStationName); ?><br>
                    <?php echo strtoupper($pAddress); ?><br>
                    <?php echo strtoupper($policeNumber); ?>
                </b>
            </div>

        </div>


    </div>

</body>

</html>
<?php endforeach; ?>