<?php
$current_page = basename($_SERVER['PHP_SELF']); // Get current page name

$user = $_SESSION['user'];
?>

<ul class="app-menu">

    <li>
        <a class="app-menu__item <?php echo ($current_page == 'main.php') ? 'active' : ''; ?>" href="main.php">
            <i class="app-menu__icon bi bi-speedometer"></i>
            <span class="app-menu__label">Dashboard</span>
        </a>
    </li>

    <li>
        <a class="app-menu__item <?php echo ($current_page == 'atf.php') ? 'active' : ''; ?>" href="atf.php">
            <i class="app-menu__icon bi bi-speedometer"></i>
            <span class="app-menu__label">Add Acknowlegement/FIR</span>
        </a>
    </li>

    <li>
        <a class="app-menu__item <?php echo ($current_page == 'graph.php') ? 'active' : ''; ?>" href="graph.php">
            <i class="app-menu__icon bi bi-bar-chart-line"></i>
            <span class="app-menu__label">Graph</span>
        </a>
    </li>


    <li
        class="treeview <?php echo (in_array($current_page, ['kycform.php', 'lien_amount.php', 'comply_order.php', 'cctv.php'])) ? 'is-expanded' : ''; ?>">
        <a class="app-menu__item <?php echo (in_array($current_page, ['kycform.php', 'lien_amount.php', 'comply_order.php', 'cctv.php'])) ? 'active' : ''; ?>"
            data-toggle="treeview">
            <i class="app-menu__icon bi bi-bank"></i>
            <span class="app-menu__label">Bank</span>
            <i class="treeview-indicator bi bi-chevron-right"></i>
        </a>
        <ul class="treeview-menu">
            <li>
                <a class="treeview-item <?php echo ($current_page == 'kycform.php') ? 'active' : ''; ?>"
                    href="kycform.php">
                    <i class="icon bi bi-person-bounding-box"></i> KYC
                </a>
            </li>
            <li>
                <a class="treeview-item <?php echo ($current_page == 'lien_amount.php') ? 'active' : ''; ?>"
                    href="lien_amount.php">
                    <i class="icon bi bi-currency-rupee"></i> LIEN AMOUNT
                </a>
            </li>
            <li>
                <a class="treeview-item <?php echo ($current_page == 'comply_order.php') ? 'active' : ''; ?>"
                    href="comply_order.php">
                    <i class="icon bi bi-journal-text"></i> COMPLY ORDER
                </a>
            </li>
            <li>
                <a class="treeview-item <?php echo ($current_page == 'cctv.php') ? 'active' : ''; ?>" href="cctv.php">
                    <i class="icon bi bi-camera-reels"></i> CCTV
                </a>
            </li>
        </ul>
    </li>

    <li class="treeview <?php echo (in_array($current_page, ['socialmedia.php'])) ? 'is-expanded' : ''; ?>">
        <a class="app-menu__item <?php echo (in_array($current_page, ['socialmedia.php'])) ? 'active' : ''; ?>"
            data-toggle="treeview">
            <i class="app-menu__icon bi bi-laptop"></i>
            <span class="app-menu__label">SOCIAL MEDIA</span>
            <i class="treeview-indicator bi bi-chevron-right"></i>
        </a>
        <ul class="treeview-menu">
            <li><a class="treeview-item <?php echo ($_GET['platform'] ?? '') == 'facebook' ? 'active' : ''; ?>"
                    href="socialmedia.php?platform=facebook"><i class="icon bi bi-facebook"></i> FACEBOOK</a></li>
            <li><a class="treeview-item <?php echo ($_GET['platform'] ?? '') == 'instagram' ? 'active' : ''; ?>"
                    href="socialmedia.php?platform=instagram"><i class="icon bi bi-instagram"></i> INSTAGRAM</a></li>
            <li><a class="treeview-item <?php echo ($_GET['platform'] ?? '') == 'whatsapp' ? 'active' : ''; ?>"
                    href="socialmedia.php?platform=whatsapp"><i class="icon bi bi-whatsapp"></i> WhatsApp</a></li>
            <li><a class="treeview-item <?php echo ($_GET['platform'] ?? '') == 'twitter' ? 'active' : ''; ?>"
                    href="socialmedia.php?platform=twitter"><i class="icon bi bi-twitter-x"></i> X (Twitter)</a></li>
            <li><a class="treeview-item <?php echo ($_GET['platform'] ?? '') == 'snapchat' ? 'active' : ''; ?>"
                    href="socialmedia.php?platform=snapchat"><i class="icon bi bi-snapchat"></i> Snapchat</a></li>
            <li><a class="treeview-item <?php echo ($_GET['platform'] ?? '') == 'google' ? 'active' : ''; ?>"
                    href="socialmedia.php?platform=google"><i class="icon bi bi-google"></i> LERS (Google)</a></li>
        </ul>
    </li>

    <li>
        <a class="app-menu__item <?php echo ($current_page == 'domain.php') ? 'active' : ''; ?>" href="domain.php">
            <i class="app-menu__icon bi bi-database"></i>
            <span class="app-menu__label">Domain</span>
        </a>
    </li>

    <li>
        <a class="app-menu__item <?php echo ($current_page == 'cdr.php') ? 'active' : ''; ?>" href="cdr.php">
            <i class="app-menu__icon bi bi-telephone"></i>
            <span class="app-menu__label">Call Details Record</span>
        </a>
    </li>

    <li>
        <a class="app-menu__item <?php echo ($current_page == 'ipdr.php') ? 'active' : ''; ?>" href="ipdr.php">
            <i class="app-menu__icon bi bi-clipboard2-data"></i>
            <span class="app-menu__label">IPDR</span>
        </a>
    </li>

    <li><a class="app-menu__item" href="refund.php"><i class="app-menu__icon bi bi-clipboard2-data"></i><span
                class="app-menu__label">REFUND AMOUNT</span></a>
    </li>


    <?php
    // Normalize (trim spaces and convert to lowercase)
    $name = isset($user['name']) ? trim(strtolower($user['name'])) : '';

    // Set boolean condition
    $bool = in_array($name, ['cyber crime', 'admin']);
    ?>
    <li class="<?php echo $bool ? '' : 'd-none'; ?>">
        <a class="app-menu__item <?php echo ($current_page === 'report.php') ? 'active' : ''; ?>" href="report.php">
            <i class="app-menu__icon bi bi-clipboard2-data"></i>
            <span class="app-menu__label">REPORT</span>
        </a>
    </li>




</ul>