<?php
session_start();
include "config.php";

// Redirect if user is not logged in
if (!isset($_SESSION['user'])) {
    echo '<script>window.location.href = "index.php";</script>';
    exit();
}
// Get user details from session
$user = $_SESSION['user'];
$pid = $user['pid'];

//echo "Welcome " . htmlspecialchars($user['name'] ?? 'User') . "<br>";
//echo "Email: " . htmlspecialchars($user['email'] ?? '') . "<br>";
//echo "Phone: " . htmlspecialchars($user['phone'] ?? '') . "<br>";
?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="icon" href="images/favicon.ico" sizes="32x32" type="image/x-icon">

    <title>Profile</title>

    <!-- Main CSS -->
    <link rel="stylesheet" type="text/css" href="css/main.css">

    <!-- Bootstrap Icons -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css">
</head>

<body class="app sidebar-mini">
    <!-- Navbar-->
    <?php include "header.php" ?>
    <!-- Sidebar menu-->
    <div class="app-sidebar__overlay" data-toggle="sidebar"></div>
    <aside class="app-sidebar">

        <?php include "./common/name.php" ?>

        <ul class="app-menu">

            <li><a class="app-menu__item active" href="main.php"><i class="app-menu__icon bi bi-speedometer"></i><span
                        class="app-menu__label">Dashboard</span></a>
            </li>

            <li class="treeview"><a class="app-menu__item" data-toggle="treeview"><i
                        class="app-menu__icon bi bi-bank"></i><span class="app-menu__label">Bank</span><i
                        class="treeview-indicator bi bi-chevron-right"></i></a>
                <ul class="treeview-menu">
                    <li><a class="treeview-item" href="kycform.php"><i
                                class="icon bi bi-person-bounding-box"></i>KYC</a>
                    </li>
                    <li><a class="treeview-item" href="lien_amount.php"><i class="icon bi bi-currency-rupee"></i> LIAN
                            AMOUNT</a></li>
                    <li><a class="treeview-item" href="comply_order.php"><i class="icon bi bi-journal-text"></i> COMPLY
                            ORDER</a> </li>
                    <li><a class="treeview-item" href="cctv.php"><i class="icon bi bi-camera-reels"></i> CCTV</a> </li>
                </ul>
            </li>

            <li class="treeview"><a class="app-menu__item" data-toggle="treeview"><i
                        class="app-menu__icon bi bi-laptop"></i><span class="app-menu__label"> SOCIAL MEDIA</span><i
                        class="treeview-indicator bi bi-chevron-right"></i></a>
                <ul class="treeview-menu">
                    <li><a class="treeview-item" href="socialmedia.php?platform=facebook"><i
                                class="icon bi bi-facebook"></i> FACEBOOK</a>
                    </li>
                    <li><a class="treeview-item" href="socialmedia.php?platform=instagram"><i
                                class="icon bi bi-instagram"></i> INSTAGRAM</a></li>
                    <li><a class="treeview-item" href="socialmedia.php?platform=whatsapp"><i
                                class="icon bi bi-whatsapp"></i> WhatsApp</a>
                    </li>
                    <li><a class="treeview-item" href="socialmedia.php?platform=twitter"><i
                                class="icon bi bi-twitter-x"></i> X (TWitter)</a> </li>
                    <li><a class="treeview-item" href="socialmedia.php?platform=snapchat"><i
                                class="icon bi bi-snapchat"></i> Snapchat</a>
                    </li>
                    <li><a class="treeview-item" href="socialmedia.php?platform=google"><i
                                class="icon bi bi-google"></i> LERS(Google)</a> </li>
                </ul>
            </li>

            <li><a class="app-menu__item" href="domain.php"><i class="app-menu__icon bi bi-database"></i><span
                        class="app-menu__label">Domain</span></a>
            </li>

            <li><a class="app-menu__item" href="cdr.php"><i class="app-menu__icon bi bi-telephone"></i><span
                        class="app-menu__label">Call Details Record</span></a>
            </li>

        </ul>

    </aside>

    <main class="app-content">
        <div class="app-title">
            <div>
                <h1><i class="bi bi-person-circle"></i> Profile</h1>
            </div>
            <ul class="app-breadcrumb breadcrumb">
                <li class="breadcrumb-item"><i class="bi bi-house-door fs-6"></i></li>
                <li class="breadcrumb-item"><a href="profile.php">Profile</a></li>
            </ul>
        </div>
        <div class="row">
            <div class="col-md-12">
                <div class="tile">
                    <div class="tile-body">
                        <form class="row">
                            <div class="mb-3 col-md-6">
                                <label class="form-label">Name</label>
                                <input class="form-control" type="text" placeholder="Enter your name"
                                    value="<?= $user['name']?>" readonly>
                            </div>
                            <div class="mb-3 col-md-6">
                                <label class="form-label">Email</label>
                                <input class="form-control" type="text" placeholder="Enter your email"
                                    value="<?= $user['email']?>" readonly>
                            </div>

                        </form>
                    </div>
                </div>
            </div>


            <div class="col-md-12">
                <div class="tile">
                    <div class="tile-title-w-btn">
                        <h3 class="title"><i class="bi bi-lock-fill me-2"></i> Update Your Password</h3>
                        <div class="btn-group">
                            <a class="btn btn-primary" href="#" data-bs-toggle="modal"
                                data-bs-target="#updatePasswordModal">
                                <i class="bi bi-pencil-square fs-5"></i> Change Password
                            </a>
                        </div>
                    </div>
                    <div class="tile-body">
                        <b class="text-muted">Your security is our top priority.</b><br>
                        Keep your account safe by updating your password regularly. Click the button above to securely
                        change your current password.
                    </div>
                </div>

            </div>


        </div>


        <!-- Password Update Modal -->
        <div class="modal fade" id="updatePasswordModal" tabindex="-1" aria-labelledby="updatePasswordModalLabel"
            aria-hidden="true">
            <div class="modal-dialog">
                <form method="POST" action="update_password.php">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title" id="updatePasswordModalLabel">Update Password</h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                        </div>
                        <div class="modal-body">
                            <div class="mb-3">
                                <label>Old Password</label>
                                <input type="password" class="form-control" name="old_password" required>
                            </div>
                            <div class="mb-3">
                                <label>New Password</label>
                                <input type="password" class="form-control" name="new_password" required>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="submit" class="btn btn-primary">Update</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>



    </main>
    <!-- Essential javascripts for application to work-->
    <script src="js/jquery-3.7.0.min.js"></script>
    <script src="js/bootstrap.min.js"></script>
    <script src="js/main.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

</body>

</html>