<?php
session_start();
include "config.php";

// Redirect if user is not logged in
if (!isset($_SESSION['user'])) {
    echo '<script>window.location.href = "index.php";</script>';
    exit();
}

// Get user details from session
$user = $_SESSION['user'];

//echo "Welcome " . htmlspecialchars($user['name'] ?? 'User') . "<br>";
//echo "Email: " . htmlspecialchars($user['email'] ?? '') . "<br>";
//echo "Phone: " . htmlspecialchars($user['phone'] ?? '') . "<br>";

// Fetch all users
$usersQuery = "SELECT * FROM `policestation`";
$result = mysqli_query($con, $usersQuery);

$allsp = "SELECT * FROM `spoffice`";
$spresult = mysqli_query($con, $allsp);
$spresult2 = mysqli_query($con, $allsp); // for Update modal

?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <title>Police Station</title>

    <!-- Main CSS -->
    <link rel="stylesheet" type="text/css" href="css/main.css">

    <!-- Bootstrap Icons -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css">
    <link rel="stylesheet" href="https://cdn.datatables.net/v/bs5/dt-1.13.4/datatables.min.css">

</head>

<body class="app sidebar-mini">
    <!-- Navbar-->
    <?php include "header.php" ?>
    <!-- Sidebar menu-->
    <div class="app-sidebar__overlay" data-toggle="sidebar"></div>
    <aside class="app-sidebar">

        <?php include "./common/name.php" ?>

        <ul class="app-menu">

            <li><a class="app-menu__item" href="dashboard.php"><i class="app-menu__icon bi bi-speedometer"></i><span
                        class="app-menu__label">Dashboard</span></a>
            </li>

            <li><a class="app-menu__item" href="sp_office.php"><i class="app-menu__icon bi bi-people"></i><span
                        class="app-menu__label">Sp Office</span></a>
            </li>

            <li><a class="app-menu__item" href="users.php"><i class="app-menu__icon bi bi-people"></i><span
                        class="app-menu__label">Users</span></a>
            </li>

            <li><a class="app-menu__item active" href="police_station.php"><i
                        class="app-menu__icon bi bi-pin-map"></i><span class="app-menu__label">Police Station</span></a>
            </li>

            <li><a class="app-menu__item" href="police.php"><i class="app-menu__icon bi bi-person-badge"></i><span
                        class="app-menu__label">Police</span></a>
            </li>

            <li><a class="app-menu__item" href="notice.php"><i class="app-menu__icon bi bi-files"></i><span
                        class="app-menu__label">Notice</span></a>
            </li>

            <li><a class="app-menu__item" href="subject.php"><i class="app-menu__icon bi bi-files-alt"></i><span
                        class="app-menu__label">Subject</span></a>
            </li>

            <li><a class="app-menu__item" href="bank.php"><i class="app-menu__icon bi bi-bank"></i><span
                        class="app-menu__label">Bank</span></a>
            </li>

        </ul>

    </aside>
    <main class="app-content">
        <div class="app-title">
            <div>
                <h1> Police Station</h1>

            </div>
            <ul class="app-breadcrumb breadcrumb side">
                <li class="breadcrumb-item"><i class="bi bi-house-door fs-6"></i></li>
                <li class="breadcrumb-item">Dashboard</li>
                <li class="breadcrumb-item active"><a href="police_station.php">Police Station</a></li>
            </ul>
        </div>
        <div class="tile-title-w-btn d-flex justify-content-end">
            <p class="mb-10">
                <a class="btn btn-primary icon-btn" data-bs-toggle="modal" data-bs-target="#addUserModal">
                    <i class="bi bi-plus-square me-2"></i>Add Police Station
                </a>
            </p>
        </div>

        <div class="row">
            <div class="col-md-12">
                <div class="tile">
                    <div class="tile-body">
                        <div class="table-responsive">
                            <table class="table table-hover table-bordered" id="sampleTable">
                                <thead>
                                    <tr>
                                        <th>ID</th>
                                        <th>SP ID</th>
                                        <th>POLSTN NAME</th>
                                        <th>ADDRESS</th>
                                        <th>LANDLINE</th>
                                        <th>NUMBER</th>
                                        <th>EMAIL</th>
                                        <th>UPDATE</th>
                                        <th>DELETE</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php if (mysqli_num_rows($result) > 0): ?>
                                    <?php while($row = mysqli_fetch_assoc($result)): ?>
                                    <tr>
                                        <td><?= htmlspecialchars($row['id']) ?></td>
                                        <td>
                                            <?php
                                                    $id = (int)$row['spid'];
                                                    $result0 = $con->query("SELECT sp_name FROM spoffice WHERE id = $id");
                                                    if ($result0 && $result0->num_rows > 0) {
                                                        $data = $result0->fetch_assoc();
                                                        echo htmlspecialchars($data['sp_name']);
                                                    } else {
                                                        echo "Name not found";
                                                    }
                                                    ?>
                                        </td>
                                        <td><?= htmlspecialchars($row['p_name']) ?></td>
                                        <td><?= htmlspecialchars($row['p_address']) ?></td>
                                        <td><?= htmlspecialchars($row['p_landline']) ?></td>
                                        <td><?= htmlspecialchars($row['p_number']) ?></td>
                                        <td><?= htmlspecialchars($row['p_email']) ?></td>
                                        <td>
                                            <button type="button" class="btn btn-primary btn-sm" onclick="openUpdateModal('<?= $row['id'] ?>', 
                                            '<?= htmlspecialchars($row['spid'], ENT_QUOTES) ?>',
                                                 '<?= htmlspecialchars($row['p_name'], ENT_QUOTES) ?>',
                                                 '<?= htmlspecialchars($row['p_address'], ENT_QUOTES) ?>',
                                                 '<?= htmlspecialchars($row['p_landline'], ENT_QUOTES) ?>',
                                                 '<?= htmlspecialchars($row['p_number'], ENT_QUOTES) ?>',
                                                '<?= htmlspecialchars($row['p_email'], ENT_QUOTES) ?>'
                                                 )">
                                                Update
                                            </button>
                                        </td>
                                        <td>
                                            <button type="button" class="btn btn-primary btn-sm" onclick="openDeleteModal('<?= $row['id'] ?>',
                                                  '<?= htmlspecialchars($row['p_name'], ENT_QUOTES) ?>',
                                                 '<?= htmlspecialchars($row['p_address'], ENT_QUOTES) ?>',
                                                 '<?= htmlspecialchars($row['p_landline'], ENT_QUOTES) ?>',
                                                 '<?= htmlspecialchars($row['p_number'], ENT_QUOTES) ?>',
                                                '<?= htmlspecialchars($row['p_email'], ENT_QUOTES) ?>',
                                            
                                                
                                    )">
                                                Delete
                                            </button>
                                        </td>
                                    </tr>
                                    <?php endwhile; ?>

                                    <?php endif; ?>

                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>


            <!-- Add User Modal -->
            <div class="modal fade" id="addUserModal" tabindex="-1" aria-labelledby="addUserModalLabel"
                aria-hidden="true">
                <div class="modal-dialog">
                    <form method="POST" action="add_police_station.php">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h5 class="modal-title">Add New Police Station</h5>
                                <button type="button" class="btn-close" data-bs-dismiss="modal"
                                    aria-label="Close"></button>
                            </div>
                            <div class="modal-body">
                                <div class="mb-3">
                                    <label class="form-label">Select SP ID</label>
                                    <select class="form-control" name="spid" required>
                                        <option value="">-- Select SP ID --</option>
                                        <?php while($row = $spresult->fetch_assoc()): ?>
                                        <option value="<?= $row['id'] ?>">
                                            <?= $row['sp_name'] ?>
                                        </option>
                                        <?php endwhile; ?>
                                    </select>
                                </div>
                                <div class="mb-3">
                                    <label class="form-label">Police Station Name</label>
                                    <input type="text" class="form-control" name="name" required />
                                </div>
                                <div class="mb-3">
                                    <label class="form-label">Address</label>
                                    <input type="text" class="form-control" name="address" required />
                                </div>
                                <div class="mb-3">
                                    <label class="form-label">Landline</label>
                                    <input type="text" class="form-control" name="landline" required />
                                </div>
                                <div class="mb-3">
                                    <label class="form-label">Number</label>
                                    <input type="text" class="form-control" name="number" required />
                                </div>
                                <div class="mb-3">
                                    <label class="form-label">Email</label>
                                    <input type="email" class="form-control" name="email" required />
                                </div>
                            </div>
                            <div class="modal-footer">
                                <button type="submit" class="btn btn-primary">Add User</button>
                                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>

            <!-- Update User Modal -->
            <div class="modal fade" id="updateModal" tabindex="-1" aria-labelledby="updateUserModalLabel"
                aria-hidden="true">
                <div class="modal-dialog">
                    <form method="POST" action="update_police_station.php">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h5 class="modal-title">Update Police Station</h5>
                                <button type="button" class="btn-close" data-bs-dismiss="modal"
                                    aria-label="Close"></button>
                            </div>
                            <div class="modal-body">
                                <input type="hidden" name="id" id="update_id">
                                <div class="mb-3">
                                    <label class="form-label">Select SP ID</label>
                                    <select class="form-control" name="spid" id="update_spid" required>
                                        <option value="">-- Select SP ID --</option>
                                        <?php while($row = $spresult2->fetch_assoc()): ?>
                                        <option value="<?= $row['id'] ?>">
                                            <?= $row['sp_name'] ?>
                                        </option>
                                        <?php endwhile; ?>
                                    </select>
                                </div>

                                <div class="mb-3">
                                    <label class="form-label">Name</label>
                                    <input type="text" class="form-control" name="name" id="update_name" required />
                                </div>
                                <div class="mb-3">
                                    <label class="form-label">Address</label>
                                    <input type="text" class="form-control" name="address" id="update_address"
                                        required />
                                </div>
                                <div class="mb-3">
                                    <label class="form-label">Landline</label>
                                    <input type="text" class="form-control" name="landline" id="update_landline"
                                        required />
                                </div>
                                <div class="mb-3">
                                    <label class="form-label">Number</label>
                                    <input type="text" class="form-control" name="number" id="update_number" required />
                                </div>
                                <div class="mb-3">
                                    <label class="form-label">Email</label>
                                    <input type="email" class="form-control" name="email" id="update_email" required />
                                </div>
                            </div>
                            <div class="modal-footer">
                                <button type="submit" class="btn btn-primary">Update</button>
                                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>


            <!-- Delete User Modal -->
            <div class="modal fade" id="deleteModal" tabindex="-1" aria-labelledby="deleteModalLabel"
                aria-hidden="true">
                <div class="modal-dialog">
                    <form method="POST" action="delete_police_station.php">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h5 class="modal-title">Confirm Delete</h5>
                                <button type="button" class="btn-close" data-bs-dismiss="modal"
                                    aria-label="Close"></button>
                            </div>
                            <div class="modal-body">
                                <input type="hidden" name="id" id="deleteId">
                                <p>Are you sure you want to delete <strong id="deleteUserName"></strong>?</p>
                            </div>
                            <div class="modal-footer">
                                <button type="submit" class="btn btn-danger">Yes, Delete</button>
                                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>



        </div>
    </main>
    <!-- Essential javascripts for application to work-->
    <script src="js/jquery-3.7.0.min.js"></script>
    <script src="js/bootstrap.min.js"></script>
    <script src="js/main.js"></script>
    <!-- Page specific javascripts-->
    <!-- Data table plugin-->
    <script type="text/javascript" src="js/plugins/jquery.dataTables.min.js"></script>
    <script type="text/javascript" src="js/plugins/dataTables.bootstrap.min.js"></script>
    <script type="text/javascript">
    $('#sampleTable').DataTable();
    </script>
    <!-- Google analytics script-->

    <script>
    function openUpdateModal(id, spid, name, address, landline, number, email) {
        document.getElementById('update_id').value = id;
        document.getElementById('update_spid').value = spid;
        document.getElementById('update_name').value = name;
        document.getElementById('update_address').value = address;
        document.getElementById('update_landline').value = landline;
        document.getElementById('update_number').value = number;
        document.getElementById('update_email').value = email;
        var updateModal = new bootstrap.Modal(document.getElementById('updateModal'));
        updateModal.show();
    }
    </script>

    <script>
    function openDeleteModal(id, name, email, password) {
        document.getElementById('deleteId').value = id;
        document.getElementById('deleteUserName').textContent = name;

        var modal = new bootstrap.Modal(document.getElementById('deleteModal'));
        modal.show();
    }
    </script>



</body>

</html>