<?php
session_start();
include "../config.php";

// Set headers for Excel export
header("Content-Type: application/vnd.ms-excel");
header("Content-Disposition: attachment; filename=ipdr_report.xls");
header("Pragma: no-cache");
header("Expires: 0");

$IPDRQuery = "
    SELECT ipdr.*, cyber_police.acknowlegement,cyber_police.complain_name, cyber_police.mobile, ipdr.status AS ipdr_status
    FROM ipdr
    INNER JOIN cyber_police 
        ON ipdr.c_id = cyber_police.id
    ORDER BY ipdr.id DESC
";

$result = mysqli_query($con, $IPDRQuery);

$user = $_SESSION['user'];
$pid = $user['pid'];

// Get Police Station Name
$psQuery = "SELECT p_name FROM policestation WHERE id = '$pid' LIMIT 1";
$psResult = mysqli_query($con, $psQuery);
$policeStationName = mysqli_fetch_assoc($psResult)['p_name'] ?? 'PoliceStation';
?>

<table border="1">
    <tr>
        <th colspan="4" style="text-align:center; font-size:16px;">
            <?= htmlspecialchars($policeStationName) ?> - IP Detail Record
        </th>
    </tr>
    <tr>
        <th>#</th>
        <th>Acknowledgement No / Complain Name / Mobile</th>
        <th>IP Details</th>
        <th>Status</th>
    </tr>
    <?php if (mysqli_num_rows($result) > 0): ?>
        <?php $i = 1;
        while ($row = mysqli_fetch_assoc($result)): ?>
            <tr>
                <td><?= $i++; ?></td>
                <td>
                    <?= htmlspecialchars($row['acknowlegement'] ?? '-') ?><br>
                    <?= htmlspecialchars($row['complain_name'] ?? '-') ?><br>
                    <?= htmlspecialchars($row['mobile'] ?? '-') ?>
                </td>
                <td>
                    <?php
                    $ip_data = $row['ip_data'];
                    $ip_records = json_decode($ip_data, true);

                    if (is_array($ip_records) && count($ip_records) > 0): ?>
                        <table border="1">
                            <tr style="background-color:#f0f0f0;">
                                <th>IP TYPE</th>
                                <th>IP ADDRESS</th>
                                <th>START DATE</th>
                                <th>START TIME (IST)</th>
                                <th>END DATE</th>
                                <th>END TIME (IST)</th>
                            </tr>
                            <?php foreach ($ip_records as $record): ?>
                                <tr>
                                    <td><?= htmlspecialchars($record['ip_type'] ?? '-') ?></td>
                                    <td><?= htmlspecialchars($record['ip_address'] ?? '-') ?></td>
                                    <td><?= htmlspecialchars($record['start_date'] ?? '-') ?></td>
                                    <td><?= htmlspecialchars($record['start_time_ist'] ?? '-') ?></td>
                                    <td><?= htmlspecialchars($record['end_date'] ?? '-') ?></td>
                                    <td><?= htmlspecialchars($record['end_time_ist'] ?? '-') ?></td>
                                </tr>
                            <?php endforeach; ?>
                        </table>
                    <?php else: ?>
                        No IP records available.
                    <?php endif; ?>
                </td>
                <td><?= htmlspecialchars($row['status'] ?? '-') ?></td>
            </tr>
        <?php endwhile; ?>
    <?php else: ?>
        <tr>
            <td colspan="4" style="text-align:center;">No Records Found</td>
        </tr>
    <?php endif; ?>
</table>