<?php
session_start();
include "../config.php";

// Redirect if not logged in
if (!isset($_SESSION['user'])) {
    header("Location: index.php");
    exit();
}

$user = $_SESSION['user'];
$pid = $user['pid'];

// Get Police Station Name
$psQuery = "SELECT p_name FROM policestation WHERE id = '$pid' LIMIT 1";
$psResult = mysqli_query($con, $psQuery);
$policeStationName = mysqli_fetch_assoc($psResult)['p_name'] ?? 'PoliceStation';

// Fetch domain data
$sql = "
    SELECT 
        d.id,
        d.domain_id,
        d.status AS domain_status,
        c.acknowlegement,
        c.complain_name,
        c.mobile
    FROM domain_data AS d
    LEFT JOIN cyber_police AS c 
        ON d.c_id = c.id
    WHERE c.pid = '$pid'
    ORDER BY d.id DESC
";

$result = mysqli_query($con, $sql);
?>
<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <title><?= htmlspecialchars($policeStationName) ?> Domain Report</title>
    <style>
    body {
        font-family: Arial, sans-serif;
    }

    h2 {
        text-align: center;
        margin-bottom: 20px;
    }

    table {
        border-collapse: collapse;
        width: 100%;
    }

    th,
    td {
        border: 1px solid #000;
        padding: 8px;
        text-align: left;
    }

    th {
        background-color: #f2f2f2;
    }
    </style>
</head>

<body>
    <h2><?= htmlspecialchars($policeStationName) ?> Domain Report</h2>
    <table>
        <thead>
            <tr>
                <th>#</th>
                <th>Acknowledgement No</th>
                <th>Complainant Name</th>
                <th>Mobile</th>
                <th>Domain ID(s)</th>
                <th>Status</th>
            </tr>
        </thead>
        <tbody>
            <?php if (mysqli_num_rows($result) > 0): ?>
            <?php $serial = 1; ?>
            <?php while ($row = mysqli_fetch_assoc($result)): ?>
            <tr>
                <td><?= $serial++; ?></td>
                <td><?= htmlspecialchars($row['acknowlegement'] ?? '-') ?></td>
                <td><?= htmlspecialchars($row['complain_name'] ?? '-') ?></td>
                <td><?= htmlspecialchars($row['mobile'] ?? '-') ?></td>
                <td>
                    <?php
                            $domains = json_decode($row['domain_id'], true);
                            if (is_array($domains)) {
                                echo implode(",<br>", array_map('htmlspecialchars', $domains));
                            } else {
                                echo htmlspecialchars($row['domain_id'] ?? '-');
                            }
                            ?>
                </td>
                <td><?= htmlspecialchars($row['domain_status'] ?? '-') ?></td>
            </tr>
            <?php endwhile; ?>
            <?php else: ?>
            <tr>
                <td colspan="6" style="text-align:center;">No records found</td>
            </tr>
            <?php endif; ?>
        </tbody>
    </table>

    <script>
    window.print(); // Automatically open print dialog
    </script>
</body>

</html>