<?php
session_start();
include "../config.php";

// Redirect if not logged in
if (!isset($_SESSION['user'])) {
    header("Location: ../index.php");
    exit();
}

$user = $_SESSION['user'];
$pid = $user['pid'];

// Get Police Station Name
$psQuery = "SELECT p_name FROM policestation WHERE id = '$pid' LIMIT 1";
$psResult = mysqli_query($con, $psQuery);
$policeStationName = mysqli_fetch_assoc($psResult)['p_name'] ?? 'PoliceStation';

// Fetch CDR data
$domainQuery = "
    SELECT 
        d.*, 
        c.acknowlegement, 
        c.complain_name, 
        c.mobile,
        c.status
    FROM cdr d
    LEFT JOIN cyber_police c 
        ON d.c_id = c.id
    WHERE d.c_id != 0 
      AND c.pid = '$pid'
    ORDER BY d.id DESC
";
$resultDomain = mysqli_query($con, $domainQuery);
?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <title><?= htmlspecialchars($policeStationName) ?> - CDR Report</title>
    <style>
    body {
        font-family: Arial, sans-serif;
        padding: 20px;
    }

    h2 {
        text-align: center;
        margin-bottom: 20px;
    }

    table {
        border-collapse: collapse;
        width: 100%;
    }

    th,
    td {
        border: 1px solid #000;
        padding: 8px;
        text-align: left;
    }

    th {
        background-color: #f2f2f2;
    }

    table table {
        width: 100%;
        margin: 5px 0;
    }

    table table th,
    table table td {
        font-size: 12px;
    }
    </style>
</head>

<body>
    <h2><?= htmlspecialchars($policeStationName) ?> Call Detail Record</h2>

    <table>
        <thead>
            <tr>
                <th>#</th>
                <th>Acknowledgement</th>
                <th>CDR Details</th>
            </tr>
        </thead>
        <tbody>
            <?php if (mysqli_num_rows($resultDomain) > 0): ?>
            <?php $serial = 1; ?>
            <?php while ($row = mysqli_fetch_assoc($resultDomain)): ?>
            <tr>
                <td><?= $serial++; ?></td>
                <td>
                    <?= !empty($row['acknowlegement']) ? htmlspecialchars($row['acknowlegement']) . "<br>" . htmlspecialchars($row['complain_name']) . "<br>" . htmlspecialchars($row['mobile']) : '-' ?>
                </td>
                <td>
                    <table>
                        <thead>
                            <tr>
                                <th>Number</th>
                                <th>Start Date/Time</th>
                                <th>End Date/Time</th>
                                <th>Status</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                                    $cdr_ids = $row['cdr_id'];
                                    $data_number = json_decode($cdr_ids, true);
                                    if (is_array($data_number) && count($data_number) > 0) {
                                        foreach ($data_number as $record) {
                                            echo "<tr>";
                                            echo "<td>" . htmlspecialchars($record['number']) . "</td>";
                                            echo "<td>" . htmlspecialchars($record['from_date']) . "</td>";
                                            echo "<td>" . htmlspecialchars($record['to_date']) . "</td>";
                                            echo "<td>" . htmlspecialchars($record['status'] ?? '-') . "</td>";
                                            echo "</tr>";
                                        }
                                    } else {
                                        echo '<tr><td colspan="3" style="text-align:center;">No CDR records</td></tr>';
                                    }
                                    ?>
                        </tbody>
                    </table>
                </td>
            </tr>
            <?php endwhile; ?>
            <?php else: ?>
            <tr>
                <td colspan="3" style="text-align:center;">No records found</td>
            </tr>
            <?php endif; ?>
        </tbody>
    </table>

    <script>
    // Automatically open print dialog
    window.onload = function() {
        window.print();
    }
    </script>
</body>

</html>