<?php
session_start();
include "../config.php";

// Redirect if not logged in
if (!isset($_SESSION['user'])) {
    header("Location: ../index.php");
    exit();
}

$user = $_SESSION['user'];
$pid = $user['pid'];

// Get Police Station Name
$psQuery = "SELECT p_name FROM policestation WHERE id = '$pid' LIMIT 1";
$psResult = mysqli_query($con, $psQuery);
$policeStationName = mysqli_fetch_assoc($psResult)['p_name'] ?? 'PoliceStation';

// Fetch Comply Orders with related data
$sql = "
    SELECT k.id AS comply_order_id, k.remarks AS comply_remarks,
           c.acknowlegement, c.complain_name, c.mobile,
           b.b_name AS bank_name, cbd.account_number, cbd.ifsc_code, 
           cbd.account_holder, cbd.release_amount, cbd.remarks AS bank_remarks
    FROM comply_order k
    LEFT JOIN cyber_police c ON k.c_id = c.id
    LEFT JOIN c_bank_data cbd ON cbd.comply_order_id = k.id
    LEFT JOIN bank b ON cbd.bank_id = b.id
    WHERE c.pid = '$pid'
    ORDER BY k.id DESC, cbd.id ASC
";
$result = mysqli_query($con, $sql);

// Grouping data by comply_order_id
$complyData = [];
while ($row = mysqli_fetch_assoc($result)) {
    $id = $row['comply_order_id'];
    if (!isset($complyData[$id])) {
        $complyData[$id] = [
            'acknowlegement' => $row['acknowlegement'],
            'complain_name' => $row['complain_name'],
            'mobile' => $row['mobile'],
            'comply_remarks' => $row['comply_remarks'],
            'banks' => []
        ];
    }
    $complyData[$id]['banks'][] = [
        'bank_name' => $row['bank_name'],
        'account_number' => $row['account_number'],
        'ifsc_code' => $row['ifsc_code'],
        'account_holder' => $row['account_holder'],
        'release_amount' => $row['release_amount'],
        'bank_remarks' => $row['bank_remarks']
    ];
}
?>
<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <title><?= htmlspecialchars($policeStationName) ?> Comply Order Report</title>
    <style>
        body {
            font-family: Arial, sans-serif;
        }

        h2 {
            text-align: center;
            margin-bottom: 20px;
        }

        table {
            border-collapse: collapse;
            width: 100%;
            font-size: 14px;
        }

        th,
        td {
            border: 1px solid #000;
            padding: 8px;
            text-align: left;
        }

        th {
            background-color: #f2f2f2;
        }

        @media print {
            button {
                display: none;
            }
        }

        .print-btn {
            background: #007bff;
            color: white;
            border: none;
            padding: 10px 20px;
            font-size: 14px;
            cursor: pointer;
            border-radius: 4px;
            margin-bottom: 15px;
        }
    </style>
</head>

<body>
    <h2><?= htmlspecialchars($policeStationName) ?> Comply Order Report</h2>

    <table>
        <thead>
            <tr>
                <th>Acknowledgement</th>
                <th>Complainant Name</th>
                <th>Mobile</th>
                <th>Bank Name</th>
                <th>Account Number</th>
                <th>IFSC</th>
                <th>Account Holder</th>
                <th>Release Amount</th>
                <th>Bank Remarks</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($complyData as $order): ?>
                <?php $rowspan = count($order['banks']) ?: 1; ?>
                <?php foreach ($order['banks'] as $i => $bank): ?>
                    <tr>
                        <?php if ($i === 0): ?>
                            <td rowspan="<?= $rowspan ?>"><?= htmlspecialchars((string) $order['acknowlegement']) ?></td>
                            <td rowspan="<?= $rowspan ?>"><?= htmlspecialchars((string) $order['complain_name']) ?></td>
                            <td rowspan="<?= $rowspan ?>"><?= htmlspecialchars((string) $order['mobile']) ?></td>
                        <?php endif; ?>
                        <td><?= htmlspecialchars((string) $bank['bank_name']) ?></td>
                        <td><?= htmlspecialchars((string) $bank['account_number']) ?></td>
                        <td><?= htmlspecialchars((string) $bank['ifsc_code']) ?></td>
                        <td><?= htmlspecialchars((string) $bank['account_holder']) ?></td>
                        <td><?= htmlspecialchars((string) $bank['release_amount']) ?></td>
                        <td><?= htmlspecialchars((string) $bank['bank_remarks']) ?></td>
                    </tr>
                <?php endforeach; ?>
            <?php endforeach; ?>
        </tbody>
    </table>
    <script>
        window.print(); // Open print dialog for PDF
    </script>
</body>

</html>