<?php
session_start();

// ✅ 1. Database connection details
$host = "localhost";     // your MySQL host
$user = "root";          // your MySQL username
$pass = "";              // your MySQL password
$dbname = "it";          // your database name

// ✅ 2. Check user login
if (!isset($_SESSION['user'])) {
    echo '<script>window.location.href = "index.php";</script>';
    exit();
}

// ✅ 3. Filename and backup path
$backupFile = "backup_" . $dbname . "_" . date("Y-m-d_H-i-s") . ".sql";

// ✅ 4. Run mysqldump command (make sure mysqldump is in system PATH)
$command = "mysqldump --user={$user} --password={$pass} --host={$host} {$dbname} > {$backupFile}";
system($command);

// ✅ 5. Force download of the SQL file
if (file_exists($backupFile)) {
    header('Content-Description: File Transfer');
    header('Content-Type: application/octet-stream');
    header('Content-Disposition: attachment; filename="' . basename($backupFile) . '"');
    header('Expires: 0');
    header('Cache-Control: must-revalidate');
    header('Pragma: public');
    header('Content-Length: ' . filesize($backupFile));
    readfile($backupFile);
    unlink($backupFile); // delete temp file after download
    exit;
} else {
    echo "<h3 style='color:red;'>❌ Backup failed. Check mysqldump path or database credentials.</h3>";
}
?>