<?php
session_start();
include "config.php";

// Redirect if user is not logged in
if (!isset($_SESSION['user'])) {
    echo '<script>window.location.href = "index.php";</script>';
    exit();
}
// Get user details from session
$user = $_SESSION['user'];
$pid = $user['pid'];

//echo "Welcome " . htmlspecialchars($user['name'] ?? 'User') . "<br>";
//echo "Email: " . htmlspecialchars($user['email'] ?? '') . "<br>";
//echo "Phone: " . htmlspecialchars($user['phone'] ?? '') . "<br>";
$domainQuery = "
    SELECT 
        d.*, 
        c.acknowlegement, 
        c.complain_name, 
        c.mobile, 
        c.incident_date_time, 
        c.total_fraud_amount, 
        c.total_lien_amount, 
        c.atf, 
        c.pid AS complain_pid, 
        d.status AS domain_status,  -- use status from domain_data
        c.time_stamp
    FROM domain_data AS d
    LEFT JOIN cyber_police AS c 
        ON d.c_id = c.id
    WHERE c.pid = '$pid'
    ORDER BY d.id DESC
";


$resultDomain = mysqli_query($con, $domainQuery);

?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="icon" href="images/favicon.ico" sizes="32x32" type="image/x-icon">

    <title>Domain</title>

    <!-- Main CSS -->
    <link rel="stylesheet" type="text/css" href="css/main.css">

    <!-- Bootstrap Icons -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css">
</head>

<body class="app sidebar-mini">
    <!-- Navbar-->
    <?php include "header.php" ?>
    <!-- Sidebar menu-->
    <div class="app-sidebar__overlay" data-toggle="sidebar"></div>
    <aside class="app-sidebar">

        <?php include "./common/name.php" ?>
        <?php include "sidebar.php"?>


    </aside>

    <main class="app-content">
        <div class="app-title">
            <div>
                <h1><i class="bi bi-database"></i> Domain</h1>
            </div>
            <ul class="app-breadcrumb breadcrumb">
                <li class="breadcrumb-item"><i class="bi bi-house-door fs-6"></i></li>
                <li class="breadcrumb-item"><a href="domain.php">Domain</a></li>

            </ul>
        </div>


        <div class="tile-title-w-btn d-flex justify-content-end">

            <p class="mb-10">
                <a href="./export/export_domain_pdf.php" class="btn btn-primary icon-btn" target="_blank">
                    <i class="bi bi-plus-square me-2"></i>Export to PDF
                </a>

            </p>
            <p class="mb-10"> &nbsp;&nbsp;</p>
            <p class="mb-10">
                <a href="./export/export_domain_excel.php" class="btn btn-primary icon-btn">
                    <i class="bi bi-plus-square me-2"></i>Export to EXCEL
                </a>
            </p>
            <p class="mb-10"> &nbsp;&nbsp;</p>

            <p class="mb-10">
                <a href="add_domain.php" class="btn btn-primary icon-btn">
                    <i class="bi bi-plus-square me-2"></i>Add
                </a>
            </p>
        </div>

        <div class="row">
            <div class="col-md-12">
                <div class="tile">
                    <div class="tile-body">
                        <div class="table-responsive">
                            <table class="table table-hover table-bordered" id="sampleTable">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>Acknowlegement No</th>
                                        <th>Domain</th>
                                        <th>View</th>
                                        <th>Status</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php if (mysqli_num_rows($resultDomain) > 0): ?>
                                    <?php $serial = 1; ?>

                                    <?php while ($row = mysqli_fetch_assoc($resultDomain)): ?>
                                    <tr>
                                        <td><?= $serial++; ?></td>
                                        <td>
                                            <?php
                                                    if (!empty($row['acknowlegement'])) {
                                                        echo htmlspecialchars($row['acknowlegement']) . '<br>';
                                                        echo htmlspecialchars($row['complain_name']) . '<br>';
                                                        echo htmlspecialchars($row['mobile']);
                                                    } else {
                                                        echo '-';
                                                    }
                                                    ?>
                                        </td>
                                        <td>
                                            <?php
                                                    $fb_ids = json_decode($row['domain_id'], true);
                                                    if (is_array($fb_ids)) {
                                                        // Escape each id and join with comma + <br> tag
                                                        echo implode(",<br>", array_map('htmlspecialchars', $fb_ids));
                                                    } else {
                                                        echo htmlspecialchars($row['domain_id']);
                                                    }
                                                    ?>
                                        </td>

                                        <td>
                                            <form id="viewForm<?= $row['id'] ?>" method="post" action="view_domain.php"
                                                style="display:inline;">
                                                <input type="hidden" name="domain_id"
                                                    value="<?= htmlspecialchars($row['id']) ?>">
                                                <input type="hidden" name="print" value="true">
                                                <a href="#"
                                                    onclick="document.getElementById('viewForm<?= $row['id'] ?>').submit();"
                                                    class="btn btn-primary">
                                                    View
                                                </a>
                                            </form>
                                        </td>

                                        <td>
                                            <form action="update_status_domain.php" method="POST">
                                                <input type="hidden" name="id"
                                                    value="<?= htmlspecialchars($row['id']) ?>">
                                                <select name="status" class="form-control"
                                                    onchange="this.form.submit()">
                                                    <option value="Pending"
                                                        <?= ($row['domain_status'] == 'Pending') ? 'selected' : '' ?>>
                                                        Pending</option>
                                                    <option value="KYC Done"
                                                        <?= ($row['domain_status'] == 'KYC Done') ? 'selected' : '' ?>>
                                                        KYC Done</option>
                                                </select>
                                            </form>

                                        </td>

                                    </tr>
                                    <?php endwhile; ?>
                                    <?php else: ?>
                                    <?php endif; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>



    </main>
    <!-- Essential javascripts for application to work-->
    <script src="js/jquery-3.7.0.min.js"></script>
    <script src="js/bootstrap.min.js"></script>
    <script src="js/main.js"></script>
    <!-- Page specific javascripts-->
    <link rel="stylesheet" href="https://cdn.datatables.net/v/bs5/dt-1.13.4/datatables.min.css">
    <!-- Data table plugin-->
    <script type="text/javascript" src="js/plugins/jquery.dataTables.min.js"></script>
    <script type="text/javascript" src="js/plugins/dataTables.bootstrap.min.js"></script>
    <script type="text/javascript">
    $('#sampleTable').DataTable();
    </script>
    <script type="text/javascript" src="https://cdn.jsdelivr.net/npm/echarts@5.4.3/dist/echarts.min.js"></script>


</body>

</html>