<?php
// Allow cross-origin requests if needed (optional for testing)
header('Content-Type: application/json');

// Include database configuration
include "../config.php";


// Handle POST only
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Read and decode raw JSON
    $rawData = file_get_contents("php://input");
    $data = json_decode($rawData, true);

    if (json_last_error() !== JSON_ERROR_NONE) {
        http_response_code(400);
        echo json_encode(["error" => "Invalid JSON"]);
        exit();
    }

    // Required fields
    $uid = $data['uid'] ?? '';
    $atf = $data['atf'] ?? '';
    $pid = $data['policestation_id'] ?? '';
    $police_id = $data['police_id'] ?? '';
    $court_order = $data['court_order'] ?? '';
    $ack_no = $data['ack_no'] ?? '';
    $subject_id = $data['subject_id'] ?? '';
    $mobile = "true";

    // Victim info
    $v_name = $data['v_name'] ?? '';
    $v_bank = $data['victim_bank_id'] ?? '';
    $v_ac_no = $data['victim_account_no'] ?? '';
    $v_ifsc = $data['victim_ifsc'] ?? '';

    $bankAccounts = $data['bank_accounts'] ?? [];

    // Validate mandatory fields (basic example)
    if (empty($uid) || empty($ack_no) || empty($court_order)) {
        http_response_code(400);
        echo json_encode(["error" => "Required fields missing"]);
        exit();
    }

    // Insert into comply_order
    $query = "INSERT INTO comply_order (
        uid, pid, police_id, court_order, acknowlegement_no, subject_id,
        v_name, v_bank, v_ac_no, v_ifsc, time_stamp, atf,mobile
    ) VALUES (
        '$uid', '$pid', '$police_id', '$court_order', '$ack_no', '$subject_id',
        '$v_name', '$v_bank', '$v_ac_no', '$v_ifsc', NOW(), '$atf','$mobile'
    )";

    if (!mysqli_query($con, $query)) {
        http_response_code(500);
        echo json_encode(["error" => "Failed to insert comply_order", "details" => mysqli_error($con)]);
        exit();
    }

    $comply_order_id = mysqli_insert_id($con);

    // Insert bank account data if provided
    foreach ($bankAccounts as $bank) {
        $bank_id = mysqli_real_escape_string($con, $bank['bank_id'] ?? '');
        $account_number = mysqli_real_escape_string($con, $bank['account_number'] ?? '');
        $ifsc_code = mysqli_real_escape_string($con, $bank['ifsc_code'] ?? '');
        $account_holder = mysqli_real_escape_string($con, $bank['account_holder'] ?? '');
        $release_amount = mysqli_real_escape_string($con, $bank['release_amount'] ?? '');

        $bankInsert = "INSERT INTO c_bank_data (
            comply_order_id, bank_id, account_number, ifsc_code, account_holder, release_amount
        ) VALUES (
            '$comply_order_id', '$bank_id', '$account_number', '$ifsc_code', '$account_holder', '$release_amount'
        )";

        mysqli_query($con, $bankInsert); // Optional: handle insert error
    }

    // Success response
    echo json_encode([
        "success" => true,
        "message" => "Comply Order Submitted Successfully",
        "comply_order_id" => $comply_order_id
    ]);
    exit();
} else {
    http_response_code(405);
    echo json_encode(["error" => "Method Not Allowed"]);
    exit();
}
?>