<?php
session_start();
include "config.php";

// Redirect if user is not logged in
if (!isset($_SESSION['user'])) {
    echo '<script>window.location.href = "index.php";</script>';
    exit();
}

$platform = 'Domain';
// Get user details from session
$user = $_SESSION['user'];
$pid = $user['pid'];


//echo "Welcome " . htmlspecialchars($user['name'] ?? 'User') . "<br>";
//echo "Email: " . htmlspecialchars($user['email'] ?? '') . "<br>";
//echo "Phone: " . htmlspecialchars($user['phone'] ?? '') . "<br>";

$ATFQuery = "SELECT * FROM `cyber_police` WHERE `pid` = '$pid'";
$resultATF = mysqli_query($con, $ATFQuery);

$policeQuery = "SELECT * FROM `police` WHERE pid = '{$user['pid']}'";
$resultPolice = mysqli_query($con, $policeQuery);

// Fetch Notice Options
$noticeOptions = "";
$noticeQuery = "SELECT * FROM `notice` WHERE `n_name` = 'NOTICE UNDER SECTION 94 OF B.N.S.S 2023'";
$noticeResult = mysqli_query($con, $noticeQuery);
if ($noticeResult && mysqli_num_rows($noticeResult) > 0) {
    while ($row = mysqli_fetch_assoc($noticeResult)) {
        $noticeOptions .= "<option value='" . htmlspecialchars($row['id']) . "'>" . htmlspecialchars($row['n_name']) . "</option>";
    }
}

// Fetch Subject Options
$subjectOptions = "";
$subjectQuery = "SELECT `id`, `s_name` FROM `subject` WHERE `s_name`='Request for Suspect Account Information'";
$subjectResult = mysqli_query($con, $subjectQuery);
if ($subjectResult && mysqli_num_rows($subjectResult) > 0) {
    while ($row = mysqli_fetch_assoc($subjectResult)) {
        $subjectOptions .= "<option value='" . htmlspecialchars($row['id']) . "'>" . htmlspecialchars($row['s_name']) . "</option>";
    }
}


// $policeOptions = "";
// $policeQuery = "SELECT `id`, `i_name` FROM `police` WHERE pid=$pid";
// $policeResult = mysqli_query($con, $policeQuery);
// if ($policeResult && mysqli_num_rows($policeResult) > 0) {
//     while ($row = mysqli_fetch_assoc($policeResult)) {
//         $policeOptions .= "<option value='" . htmlspecialchars($row['id']) . "'>" . htmlspecialchars($row['i_name']) . "</option>";
//     }
// }

?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="icon" href="images/favicon.ico" sizes="32x32" type="image/x-icon">

    <title><?php echo strtoupper($platform); ?></title>

    <!-- Main CSS -->
    <link rel="stylesheet" type="text/css" href="css/main.css">

    <!-- Bootstrap Icons -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css">
</head>

<body class="app sidebar-mini">
    <!-- Navbar-->
    <?php include "header.php" ?>
    <!-- Sidebar menu-->
    <div class="app-sidebar__overlay" data-toggle="sidebar"></div>
    <aside class="app-sidebar">

        <?php include "./common/name.php" ?>

        <ul class="app-menu">

            <li><a class="app-menu__item" href="main.php"><i class="app-menu__icon bi bi-speedometer"></i><span
                        class="app-menu__label">Dashboard</span></a>
            </li>

            <li class="treeview"><a class="app-menu__item" data-toggle="treeview"><i
                        class="app-menu__icon bi bi-bank"></i><span class="app-menu__label">Bank</span><i
                        class="treeview-indicator bi bi-chevron-right"></i></a>
                <ul class="treeview-menu">
                    <li><a class="treeview-item" href="kycform.php"><i
                                class="icon bi bi-person-bounding-box"></i>KYC</a>
                    </li>
                    <li><a class="treeview-item" href="lien_amount.php"><i class="icon bi bi-currency-rupee"></i> LIAN
                            AMOUNT</a></li>
                    <li><a class="treeview-item" href="comply_order.php"><i class="icon bi bi-journal-text"></i> COMPLY
                            ORDER</a> </li>
                    <li><a class="treeview-item" href="cctv.php"><i class="icon bi bi-camera-reels"></i> CCTV</a> </li>
                </ul>
            </li>

            <li class="treeview"><a class="app-menu__item" data-toggle="treeview"><i
                        class="app-menu__icon bi bi-laptop"></i><span class="app-menu__label"> SOCIAL MEDIA</span><i
                        class="treeview-indicator bi bi-chevron-right"></i></a>
                <ul class="treeview-menu">
                    <li><a class="treeview-item" href="socialmedia.php?platform=facebook"><i
                                class="icon bi bi-facebook"></i> FACEBOOK</a>
                    </li>
                    <li><a class="treeview-item" href="socialmedia.php?platform=instagram"><i
                                class="icon bi bi-instagram"></i> INSTAGRAM</a></li>
                    <li><a class="treeview-item" href="socialmedia.php?platform=whatsapp"><i
                                class="icon bi bi-whatsapp"></i> WhatsApp</a>
                    </li>
                    <li><a class="treeview-item" href="socialmedia.php?platform=twitter"><i
                                class="icon bi bi-twitter-x"></i> X (TWitter)</a> </li>
                    <li><a class="treeview-item" href="socialmedia.php?platform=snapchat"><i
                                class="icon bi bi-snapchat"></i> Snapchat</a>
                    </li>
                    <li><a class="treeview-item" href="socialmedia.php?platform=google"><i
                                class="icon bi bi-google"></i> LERS(Google)</a> </li>
                </ul>
            </li>

            <li><a class="app-menu__item active" href="domain.php"><i class="app-menu__icon bi bi-database"></i><span
                        class="app-menu__label">Domain</span></a>
            </li>

            <li><a class="app-menu__item" href="cdr.php"><i class="app-menu__icon bi bi-telephone"></i><span
                        class="app-menu__label">Call Details Record</span></a>
            </li>

        </ul>


    </aside>

    <main class="app-content">
        <div class="app-title">
            <div>
                <h1><i class="bi bi-database"></i> <?php echo strtoupper($platform); ?></h1>
            </div>
            <ul class="app-breadcrumb breadcrumb">
                <li class="breadcrumb-item"><i class="bi bi-house-door fs-6"></i></li>
                <li class="breadcrumb-item">Social Media</li>
                <li class="breadcrumb-item"><a href="#"> <?php echo strtoupper($platform); ?></a></li>
            </ul>
        </div>


        <form method="POST" action="insert_domain.php">
            <div class="row">
                <div class="col-md-6">
                    <div class="tile">
                        <div class="tile-body">

                            <div class="mb-3">
                                <label class="form-label">Select Acknowledgement / FIR No.</label>
                                <select class="form-control" name="atf" id="atf_id" required>
                                    <option value="">-- Select Acknowledgement No / FIR No --</option>
                                    <?php
                                    while ($row = mysqli_fetch_assoc($resultATF)) {
                                        $displayText = htmlspecialchars($row['acknowlegement']) . ' - ' . htmlspecialchars($row['complain_name']);
                                        echo '<option value="' . $row['id'] . '">' . $displayText . '</option>';
                                    }
                                    ?>
                                </select>

                            </div>

                            <!-- <div class="mb-3">
                                <label class="form-label">Select Fraud Type</label>
                                <select id="fraudTypeSelect" class="form-control" name="fraud_type" required>
                                    <option value="">-- Select Fraud Type --</option>
                                </select>
                            </div> -->

                            <div class="mb-3 d-none">
                                <label class="form-label">Select Notice</label>
                                <select class="form-control" name="notice_id" required>
                                    <?= $noticeOptions ?>
                                </select>
                            </div>

                            <div class="mb-3 d-none">
                                <label class="form-label">Select Subject</label>
                                <select class="form-control" name="subject_id" required>
                                    <?= $subjectOptions ?>
                                </select>
                            </div>

                            <div class="mb-3">
                                <label class="form-label">Select Investigation Officer</label>
                                <select class="form-control" name="police_id" id="police_id" required>
                                    <option value="">-- Select Investigation Officer --</option>
                                    <?php
                                    while ($row = mysqli_fetch_assoc($resultPolice)) {
                                        echo '<option value="' . $row['id'] . '">' . htmlspecialchars($row['i_name']) . '</option>';
                                    }
                                    ?>
                                </select>

                            </div>



                        </div>

                        <div class="mb-3">
                            <div class="row">
                                <div class="col-9">
                                    <label class="form-label"><?php echo strtoupper($platform); ?> ID</label>
                                    <input id="domainInput" class="form-control" type="text"
                                        placeholder="Enter <?php echo strtoupper($platform); ?> ID Like www.google.com">

                                </div>
                                <div class="col-3">
                                    <label class="form-label"
                                        style="visibility: hidden;"><?php echo strtoupper($platform); ?></label>
                                    <button class="btn btn-primary" type="button" onclick="addDomain()">
                                        <i class="bi bi-check-circle-fill me-2"></i>Add
                                    </button>
                                </div>
                            </div>
                        </div>

                        <!-- Hidden field to hold all Instagram IDs -->
                        <input type="hidden" name="domain_ids" id="domain_ids">

                        <div class="tile-footer">
                            <button class="btn btn-primary" type="submit"><i
                                    class="bi bi-check-circle-fill me-2"></i>Submit</button>&nbsp;&nbsp;&nbsp;<a
                                class="btn btn-secondary" href="#"><i class="bi bi-x-circle-fill me-2"></i>Cancel</a>
                        </div>


                    </div>

                </div>

                <div class="col-md-6">
                    <div class="tile">
                        <div class="tile-body">
                            <div class="table-responsive">
                                <table class="table table-hover table-bordered" id="sampleTable">
                                    <thead>
                                        <tr>
                                            <th>ID</th>
                                            <th><?= strtoupper($platform) ?> ID</th>
                                            <th>DELETE</th>
                                        </tr>
                                    </thead>
                                    <tbody id="socialTableBody"></tbody>

                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            </div>

        </form>




    </main>
    <!-- Essential javascripts for application to work-->
    <script src="js/jquery-3.7.0.min.js"></script>
    <script src="js/bootstrap.min.js"></script>
    <script src="js/main.js"></script>
    <!-- Page specific javascripts-->
    <script type="text/javascript" src="https://cdn.jsdelivr.net/npm/echarts@5.4.3/dist/echarts.min.js"></script>

    <script>
        let idCounter = 1;
        const domainIds = [];

        function addDomain() {
            const input = document.getElementById("domainInput");
            const value = input.value.trim();
            const hiddenField = document.getElementById("domain_ids");

            if (value === "") {
                alert("Please enter a SocialMedia ID.");
                return;
            }

            domainIds.push(value);
            hiddenField.value = JSON.stringify(domainIds);

            const tableBody = document.getElementById("socialTableBody");
            const newRow = document.createElement("tr");
            newRow.innerHTML = `
            <td>${idCounter++}</td>
            <td>${value}</td>
            <td><button class="btn btn-danger btn-sm" onclick="deleteRow(this, '${value}')">Delete</button></td>
        `;
            tableBody.appendChild(newRow);
            input.value = "";
        }

        function deleteRow(button, value) {
            const row = button.closest("tr");
            row.remove();
            const index = domainIds.indexOf(value);
            if (index !== -1) domainIds.splice(index, 1);
            document.getElementById("domain_ids").value = JSON.stringify(domainIds);
        }
    </script>


    <script>
        const fraudTypes = [{
            value: "identity_theft",
            label: "Identity Theft"
        },
        {
            value: "cyber_fraud",
            label: "Cyber Fraud"
        },
        {
            value: "financial_fraud",
            label: "Financial Fraud"
        },
        {
            value: "phishing",
            label: "Phishing"
        },
        {
            value: "other",
            label: "Other"
        }
        ];

        const fraudTypeSelect = document.getElementById("fraudTypeSelect");

        fraudTypes.forEach(type => {
            const option = document.createElement("option");
            option.value = type.value;
            option.textContent = type.label;
            fraudTypeSelect.appendChild(option);
        });

        fraudTypeSelect.addEventListener("change", function () {
            const selected = this.value;

        });
    </script>

    <script>
        function updateLabel() {
            const selectedValue = document.querySelector('input[name="reference_type"]:checked').value;
            const label = document.getElementById("referenceLabel");
            const input = document.querySelector('input[name="reference_number"]');

            if (selectedValue === "0") {
                label.innerText = "Acknowledgement Number";
                input.placeholder = "Enter Acknowledgement Number";
            } else if (selectedValue === "1") {
                label.innerText = "Ticket No.";
                input.placeholder = "Enter Ticket No.";
            } else if (selectedValue === "2") {
                label.innerText = "FIR No.";
                input.placeholder = "Enter FIR No.";
            }
        }
    </script>


</body>

</html>