<?php

session_start();
include "config.php";

// Redirect if user not logged in
if (!isset($_SESSION['user'])) {
    header("Location: index.php");
    exit();
}

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    die("Invalid request method.");
}

// Get record ID
$record_id = isset($_POST['record_id']) ? (int) $_POST['record_id'] : 0;

// Get CCTV JSON data
$bank_accounts_json = $_POST['bank_accounts_json'] ?? '[]';

// Validate record ID
if ($record_id <= 0) {
    die("Invalid record ID.");
}

// Sanitize data
$cctv_details = mysqli_real_escape_string($con, $bank_accounts_json);
$timestamp = date('Y-m-d H:i:s');

// Update query (only required fields)
$updateQuery = "
    UPDATE `cctv`
    SET
        `cctv_details` = '$cctv_details',
        `time_stamp` = '$timestamp'
    WHERE `id` = $record_id
";

// Execute query
if (mysqli_query($con, $updateQuery)) {
    header("Location: cctv.php");
    exit();
} else {
    echo "Error: " . mysqli_error($con);
}
?>