<?php
//session_start();

$current_page = basename($_SERVER['PHP_SELF']);
$platform = $_GET['platform'] ?? '';

$user = $_SESSION['user'] ?? [];

/* ================= PAGE GROUPS ================= */

// BANK
$kycPages = ['kyc_form.php', 'add_kyc_form.php', 'kyc_form_update.php'];
$lienPages = ['lien_amount.php', 'add_lien_amount.php', 'update_lien_amount.php'];
$complyPages = ['comply_order.php'];
$cctvPages = ['cctv.php', 'add_cctv.php', 'update_cctv.php'];

// SOCIAL MEDIA
$socialMediaPages = [
    'socialmedia.php',
    'add_socialmedia.php',
    'update_socialmedia.php'
];

// DOMAIN / CDR / IPDR
$domainPages = ['domain.php', 'add_domain.php', 'update_domain.php'];
$cdrPages = ['cdr.php', 'add_cdr.php', 'update_cdr.php'];
$ipdrPages = ['ipdr.php', 'add_ipdr.php', 'update_ipdr.php'];

/* ================= ADMIN CHECK ================= */
$name = isset($user['name']) ? trim(strtolower($user['name'])) : '';
$isAdmin = in_array($name, ['cyber crime', 'admin']);
?>

<ul class="app-menu">

    <!-- DASHBOARD -->
    <li>
        <a class="app-menu__item <?= ($current_page == 'main.php') ? 'active' : '' ?>" href="main.php">
            <i class="app-menu__icon bi bi-boxes"></i>
            <span class="app-menu__label">Dashboard</span>
        </a>
    </li>

    <!-- FIR -->
    <li>
        <a class="app-menu__item <?= ($current_page == 'atf.php') ? 'active' : '' ?>" href="atf.php">
            <i class="app-menu__icon bi bi-patch-plus-fill"></i>
            <span class="app-menu__label">Add Acknowledgement</span>
        </a>
    </li>

    <!-- ================= BANK ================= -->
    <li class="treeview <?= (
        in_array($current_page, $kycPages) ||
        in_array($current_page, $lienPages) ||
        in_array($current_page, $complyPages) ||
        in_array($current_page, $cctvPages)
    ) ? 'is-expanded' : '' ?>">

        <a class="app-menu__item" data-toggle="treeview">
            <i class="app-menu__icon bi bi-bank"></i>
            <span class="app-menu__label">Bank</span>
            <i class="treeview-indicator bi bi-chevron-right"></i>
        </a>

        <ul class="treeview-menu">

            <li>
                <a class="treeview-item <?= in_array($current_page, $kycPages) ? 'active' : '' ?>" href="kyc_form.php">
                    <i class="icon bi bi-person-bounding-box"></i> KYC
                </a>
            </li>

            <li>
                <a class="treeview-item <?= in_array($current_page, $lienPages) ? 'active' : '' ?>"
                    href="lien_amount.php">
                    <i class="icon bi bi-currency-rupee"></i> LIEN AMOUNT
                </a>
            </li>

            <li>
                <a class="treeview-item <?= in_array($current_page, $complyPages) ? 'active' : '' ?>"
                    href="comply_order.php">
                    <i class="icon bi bi-journal-text"></i> COMPLY ORDER
                </a>
            </li>

            <li>
                <a class="treeview-item <?= in_array($current_page, $cctvPages) ? 'active' : '' ?>" href="cctv.php">
                    <i class="icon bi bi-camera-reels"></i> CCTV
                </a>
            </li>

        </ul>
    </li>

    <!-- ================= SOCIAL MEDIA ================= -->
    <li class="treeview <?= in_array($current_page, $socialMediaPages) ? 'is-expanded' : '' ?>">

        <a class="app-menu__item <?= in_array($current_page, $socialMediaPages) ? 'active' : '' ?>"
            data-toggle="treeview">
            <i class="app-menu__icon bi bi-laptop"></i>
            <span class="app-menu__label">SOCIAL MEDIA</span>
            <i class="treeview-indicator bi bi-chevron-right"></i>
        </a>

        <ul class="treeview-menu">
            <li>
                <a class="treeview-item <?= ($platform == 'facebook') ? 'active' : '' ?>"
                    href="socialmedia.php?platform=facebook">
                    <i class="icon bi bi-facebook"></i> Facebook
                </a>
            </li>

            <li>
                <a class="treeview-item <?= ($platform == 'instagram') ? 'active' : '' ?>"
                    href="socialmedia.php?platform=instagram">
                    <i class="icon bi bi-instagram"></i> Instagram
                </a>
            </li>

            <li>
                <a class="treeview-item <?= ($platform == 'whatsapp') ? 'active' : '' ?>"
                    href="socialmedia.php?platform=whatsapp">
                    <i class="icon bi bi-whatsapp"></i> WhatsApp
                </a>
            </li>

            <li>
                <a class="treeview-item <?= ($platform == 'twitter') ? 'active' : '' ?>"
                    href="socialmedia.php?platform=twitter">
                    <i class="icon bi bi-twitter-x"></i> X (Twitter)
                </a>
            </li>
        </ul>
    </li>

    <!-- DOMAIN -->
    <li>
        <a class="app-menu__item <?= in_array($current_page, $domainPages) ? 'active' : '' ?>" href="domain.php">
            <i class="app-menu__icon bi bi-database"></i>
            <span class="app-menu__label">Domain</span>
        </a>
    </li>

    <!-- CDR -->
    <li>
        <a class="app-menu__item <?= in_array($current_page, $cdrPages) ? 'active' : '' ?>" href="cdr.php">
            <i class="app-menu__icon bi bi-telephone"></i>
            <span class="app-menu__label">Call Details Record</span>
        </a>
    </li>

    <!-- IPDR -->
    <li>
        <a class="app-menu__item <?= in_array($current_page, $ipdrPages) ? 'active' : '' ?>" href="ipdr.php">
            <i class="app-menu__icon bi bi-modem"></i>
            <span class="app-menu__label">IPDR</span>
        </a>
    </li>

    <!-- REPORT (ADMIN ONLY) -->
    <li class="<?= $isAdmin ? '' : 'd-none' ?>">
        <a class="app-menu__item <?= ($current_page == 'report.php') ? 'active' : '' ?>" href="report.php">
            <i class="app-menu__icon bi bi-clipboard2-data"></i>
            <span class="app-menu__label">REPORT</span>
        </a>
    </li>

    <!-- GRAPH -->
    <li>
        <a class="app-menu__item <?= ($current_page == 'graph.php') ? 'active' : '' ?>" href="graph.php">
            <i class="app-menu__icon bi bi-pie-chart-fill"></i>
            <span class="app-menu__label">Graph</span>
        </a>
    </li>

    <li> <a class="app-menu__item <?php echo ($current_page == 'bank_nodel.php') ? 'active' : ''; ?>"
            href="bank_nodel.php"> <i class="app-menu__icon bi bi-safe-fill"></i> <span class="app-menu__label">BANK
                NODEL</span> </a> </li>

    <li> <a class="app-menu__item <?php echo ($current_page == 'portal.php') ? 'active' : ''; ?>" href="portal.php"> <i
                class="app-menu__icon bi bi-safe-fill"></i> <span class="app-menu__label">PORTAL</span> </a> </li>

</ul>