<?php
session_start();
include "../config.php";

// Redirect if not logged in
if (!isset($_SESSION['user'])) {
    header("Location: ../index.php");
    exit();
}

$user = $_SESSION['user'];
$pid = $user['pid'];

// Receive POST data
$type = $_POST['type'] ?? 'KYC';
$start = $_POST['start'] ?? '';
$end = $_POST['end'] ?? '';

if (!$start || !$end) {
    die("Missing date range!");
}

// Get Police Station Name
$psQuery = "SELECT p_name FROM policestation WHERE id = '$pid' LIMIT 1";
$psResult = mysqli_query($con, $psQuery);
$policeStationName = mysqli_fetch_assoc($psResult)['p_name'] ?? 'PoliceStation';

// Fetch CCTV data
$sql = "
    SELECT 
        c.*, 
        p.acknowlegement, 
        p.complain_name, 
        p.mobile,
        c.time_stamp,
        ps.p_name AS police_station
    FROM cctv c
    LEFT JOIN cyber_police p ON c.c_id = p.id
    LEFT JOIN policestation ps ON p.pid = ps.id  -- ✅ use p.pid instead of c.pid
    WHERE DATE(c.time_stamp) BETWEEN '$start' AND '$end'
    ORDER BY c.id DESC
";


$result = mysqli_query($con, $sql);
?>

<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <title><?= htmlspecialchars($policeStationName) ?> CCTV Report</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            font-size: 13px;
            margin: 20px;
        }

        h2 {
            text-align: center;
            margin-bottom: 15px;
            text-transform: uppercase;
        }

        table {
            border-collapse: collapse;
            width: 100%;
            margin-top: 10px;
        }

        th,
        td {
            border: 1px solid #000;
            padding: 6px;
            text-align: left;
            vertical-align: top;
        }

        th {
            background-color: #f2f2f2;
        }

        .nested-table {
            width: 100%;
            border-collapse: collapse;
        }

        .nested-table th,
        .nested-table td {
            border: 1px solid #999;
            padding: 4px;
            font-size: 12px;
        }
    </style>
</head>

<body>
    <h2><?= htmlspecialchars($policeStationName) ?> CCTV Report</h2>

    <table>
        <thead>
            <tr>
                <th>#</th>
                <th>Acknowledgement</th>
                <th>Complainant</th>
                <th>Mobile</th>
                <th>Police Station</th>
                <th>CCTV Details</th>
                <th>Status</th>
                <th>Remark</th>
            </tr>
        </thead>
        <tbody>
            <?php
            $serial = 1;
            while ($row = mysqli_fetch_assoc($result)):
                $cctv_details = json_decode($row['cctv_details'], true);
                ?>
                <tr>
                    <td><?= $serial++ ?></td>
                    <td><?= htmlspecialchars($row['acknowlegement'] ?? '-') ?></td>
                    <td><?= htmlspecialchars($row['complain_name'] ?? '-') ?></td>
                    <td><?= htmlspecialchars($row['mobile'] ?? '-') ?></td>
                    <td><?= htmlspecialchars($row['police_station'] ?? '-') ?></td>
                    <td>
                        <?php if (is_array($cctv_details) && count($cctv_details) > 0): ?>
                            <table class="nested-table">
                                <thead>
                                    <tr>
                                        <th>Bank Name</th>
                                        <th>ATM ID</th>
                                        <th>Start Date/Time</th>
                                        <th>End Date/Time</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($cctv_details as $cctv): ?>
                                        <tr>
                                            <td><?= htmlspecialchars($cctv['bank_name'] ?? '-') ?></td>
                                            <td><?= htmlspecialchars($cctv['atm_id'] ?? '-') ?></td>
                                            <td><?= htmlspecialchars($cctv['start_date_time'] ?? '-') ?></td>
                                            <td><?= htmlspecialchars($cctv['end_date_time'] ?? '-') ?></td>
                                        </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                        <?php else: ?>
                            No CCTV details available.
                        <?php endif; ?>
                    </td>
                    <td><?= htmlspecialchars($row['status'] ?? '-') ?></td>
                    <td><?= htmlspecialchars($row['remarks'] ?? '-') ?></td>

                </tr>
            <?php endwhile; ?>
        </tbody>
    </table>

    <script>
        // Automatically open print dialog to export as PDF
        window.print();
    </script>
</body>

</html>