<?php
session_start();
include "config.php";

// Redirect if user is not logged in
if (!isset($_SESSION['user'])) {
    echo '<script>window.location.href = "index.php";</script>';
    exit();
}
// Get user details from session
$user = $_SESSION['user'];
$pid = $user['pid'];

//echo "Welcome " . htmlspecialchars($user['name'] ?? 'User') . "<br>";
//echo "Email: " . htmlspecialchars($user['email'] ?? '') . "<br>";
//echo "Phone: " . htmlspecialchars($user['phone'] ?? '') . "<br>";
?>

<?php

// 1️⃣ Query to get total release amount per police station
$sql = "
    SELECT 
        ps.p_name AS police_station_name,
        SUM(cb.release_amount) AS total_release_amount
    FROM cyber_police cp
    INNER JOIN comply_order co ON cp.id = co.c_id
    INNER JOIN c_bank_data cb ON co.id = cb.comply_order_id
    INNER JOIN policestation ps ON cp.pid = ps.id
    WHERE cp.pid = $pid
      AND LOWER(cb.remarks) = 'yes'
    GROUP BY ps.p_name
";
$result = mysqli_query($con, $sql);
?>



<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="icon" href="images/favicon.ico" sizes="32x32" type="image/x-icon">

    <title>Dashboard</title>

    <!-- Main CSS -->
    <link rel="stylesheet" type="text/css" href="css/main.css">

    <!-- Bootstrap Icons -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css">
</head>

<body class="app sidebar-mini">
    <!-- Navbar-->
    <?php include "header.php" ?>
    <!-- Sidebar menu-->
    <div class="app-sidebar__overlay" data-toggle="sidebar"></div>
    <aside class="app-sidebar">

        <?php include "./common/name.php" ?>


        <?php include 'sidebar.php' ?>


    </aside>

    <div class="app-content">
        <div class="app-title">
            <div>
                <h1><i class="bi bi-speedometer"></i> REFUND AMOUNT</h1>
            </div>
            <ul class="app-breadcrumb breadcrumb">
                <li class="breadcrumb-item"><i class="bi bi-house-door fs-6"></i></li>
                <li class="breadcrumb-item"><a href="refund.php">REFUND AMOUNT</a></li>
            </ul>
        </div>

        <div class="row">
            <div class="col-md-12">
                <table class="table table-bordered">
                    <thead>
                        <tr>
                            <th>Police Station</th>
                            <th>Total Release Amount</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if ($result && mysqli_num_rows($result) > 0) { ?>
                            <?php while ($row = mysqli_fetch_assoc($result)) { ?>
                                <tr>
                                    <td><?= htmlspecialchars($row['police_station_name']) ?></td>
                                    <td>₹<?= number_format($row['total_release_amount'], 2) ?></td>
                                </tr>
                            <?php } ?>
                        <?php } else { ?>
                            <tr>
                                <td colspan="2">No records found</td>
                            </tr>
                        <?php } ?>
                    </tbody>
                </table>
            </div>
        </div>



        </main>
        <!-- Essential javascripts for application to work-->
        <script src="js/jquery-3.7.0.min.js"></script>
        <script src="js/bootstrap.min.js"></script>
        <script src="js/main.js"></script>
        <!-- Page specific javascripts-->

        <script type="text/javascript" src="https://cdn.jsdelivr.net/npm/echarts@5.4.3/dist/echarts.min.js"></script>
        <script src="https://cdn.jsdelivr.net/npm/echarts@5.4.2/dist/echarts.min.js"></script>


</body>

</html>