<script>
// ----------------------------
// 1. Disable right-click
// ----------------------------
document.addEventListener("contextmenu", e => e.preventDefault(), false);

// ----------------------------
// 2. Disable keyboard shortcuts
// ----------------------------
document.addEventListener("keydown", function(e) {

    // F12
    if (e.keyCode === 123) e.preventDefault();

    // Ctrl+Shift+I / C / J / K
    if (e.ctrlKey && e.shiftKey && [73, 67, 74, 75].includes(e.keyCode))
        e.preventDefault();

    // Ctrl+U
    if (e.ctrlKey && e.keyCode === 85)
        e.preventDefault();

}, false);

// ----------------------------
// 3. Detect DevTools (outerWidth / outerHeight method)
// ----------------------------
(function devtoolsDimensionCheck() {
    const threshold = 160;

    setInterval(() => {
        const widthDiff = window.outerWidth - window.innerWidth;
        const heightDiff = window.outerHeight - window.innerHeight;

        if (widthDiff > threshold || heightDiff > threshold) {
            blockPage();
        }

    }, 500);
})();

// ----------------------------
// 4. Heavy Anti-Debug Loop (SAFE VERSION)
// ----------------------------
(function safeAntiDebug() {
    let triggered = false;

    setInterval(() => {
        if (triggered) return;

        const start = performance.now();
        debugger; // light detection

        const delay = performance.now() - start;

        if (delay > 50) {
            triggered = true;
            blockPage();
        }

    }, 300);
})();

// ----------------------------
// 5. Function: Block Page & Show Warning
// ----------------------------
function blockPage() {
    document.body.innerHTML = "";

    const overlay = document.createElement("div");
    overlay.style.position = "fixed";
    overlay.style.top = 0;
    overlay.style.left = 0;
    overlay.style.width = "100%";
    overlay.style.height = "100%";
    overlay.style.background = "#000";
    overlay.style.color = "#fff";
    overlay.style.display = "flex";
    overlay.style.alignItems = "center";
    overlay.style.justifyContent = "center";
    overlay.style.fontSize = "30px";
    overlay.style.zIndex = "9999999";
    overlay.innerText = "🚫 Developer Tools Detected! Access Restricted.";

    document.body.appendChild(overlay);
}
</script>
