<?php
session_start(); // ✅ Start session first
include "../config.php";


$IPDRQuery = "
    SELECT ipdr.*,cyber_police.acknowlegement, cyber_police.complain_name, cyber_police.mobile, ipdr.status AS ipdr_status
    FROM ipdr
    INNER JOIN cyber_police 
        ON ipdr.c_id = cyber_police.id
    ORDER BY ipdr.id DESC
";


$result = mysqli_query($con, $IPDRQuery);

$user = $_SESSION['user'];
$pid = $user['pid'];

// Get Police Station Name
$psQuery = "SELECT p_name FROM policestation WHERE id = '$pid' LIMIT 1";
$psResult = mysqli_query($con, $psQuery);
$policeStationName = mysqli_fetch_assoc($psResult)['p_name'] ?? 'PoliceStation';


?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <title>IP Detail Record - PDF View</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            margin: 30px;
            font-family: Arial, sans-serif;
        }

        h2 {
            text-align: center;
            margin-bottom: 30px;
        }

        th,
        td {
            text-align: center;
            vertical-align: middle;
        }

        th {
            background-color: #007bff;
            color: #fff;
        }

        tr:nth-child(even) {
            background-color: #f8f9fa;
        }

        .nested-table th {
            background-color: #6c757d;
            color: #fff;
            font-size: 13px;
        }

        .nested-table td {
            font-size: 13px;
        }

        @media print {
            body {
                margin: 10px;
            }

            button,
            .no-print {
                display: none !important;
            }

            table {
                page-break-inside: auto;
            }
        }
    </style>
</head>

<body>
    <h2><?= htmlspecialchars($policeStationName) ?> IP Detail Record</h2>


    <table class="table table-bordered">
        <thead>
            <tr>
                <th>#</th>
                <th>Acknowledgement No / Complain Name / Mobile</th>
                <th>IP Details</th>
                <th>Status</th>
            </tr>
        </thead>
        <tbody>
            <?php if (mysqli_num_rows($result) > 0): ?>
                <?php $i = 1;
                while ($row = mysqli_fetch_assoc($result)): ?>
                    <tr>
                        <td><?= $i++; ?></td>
                        <td>
                            <?= htmlspecialchars($row['acknowlegement'] ?? '-') ?><br>
                            <?= htmlspecialchars($row['complain_name'] ?? '-') ?><br>
                            <?= htmlspecialchars($row['mobile'] ?? '-') ?>
                        </td>
                        <td>
                            <?php
                            $ip_data = $row['ip_data'];
                            $ip_records = json_decode($ip_data, true);

                            if (is_array($ip_records) && count($ip_records) > 0): ?>
                                <table class="table table-bordered nested-table">
                                    <thead>
                                        <tr>
                                            <th>IP TYPE</th>
                                            <th>IP ADDRESS</th>
                                            <th>START DATE</th>
                                            <th>START TIME (IST)</th>
                                            <th>END DATE</th>
                                            <th>END TIME (IST)</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php foreach ($ip_records as $record): ?>
                                            <tr>
                                                <td><?= htmlspecialchars($record['ip_type'] ?? '-') ?></td>
                                                <td><?= htmlspecialchars($record['ip_address'] ?? '-') ?></td>
                                                <td><?= htmlspecialchars($record['start_date'] ?? '-') ?></td>
                                                <td><?= htmlspecialchars($record['start_time_ist'] ?? '-') ?></td>
                                                <td><?= htmlspecialchars($record['end_date'] ?? '-') ?></td>
                                                <td><?= htmlspecialchars($record['end_time_ist'] ?? '-') ?></td>
                                            </tr>
                                        <?php endforeach; ?>
                                    </tbody>
                                </table>
                            <?php else: ?>
                                <span>No IP records available.</span>
                            <?php endif; ?>
                        </td>
                        <td><?= htmlspecialchars($row['status'] ?? '-') ?></td>
                    </tr>
                <?php endwhile; ?>
            <?php else: ?>
                <tr>
                    <td colspan="4" class="text-center">No Records Found</td>
                </tr>
            <?php endif; ?>
        </tbody>
    </table>
    <script>
        window.onload = function () {
            window.print(); // auto open print dialog
        };
    </script>
</body>

</html>