<?php
session_start();
include "../config.php";

// Fetch data
$sql = "SELECT id, bank_name, email_id FROM nodel_officer ORDER BY id ASC";
$result = mysqli_query($con, $sql);
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <title>Bank Nodel Officer List</title>

    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">

    <style>
        body {
            margin: 30px;
            font-family: Arial, sans-serif;
        }

        h2 {
            text-align: center;
            margin-bottom: 25px;
        }

        th,
        td {
            text-align: center;
            vertical-align: middle;
            font-size: 14px;
        }

        th {
            background-color: #007bff;
            color: white;
        }

        tr:nth-child(even) {
            background-color: #f8f9fa;
        }

        @media print {
            body {
                margin: 10px;
            }

            .no-print {
                display: none !important;
            }
        }
    </style>
</head>

<body>

    <h2>BANK NODEL OFFICER LIST</h2>

    <table class="table table-bordered">
        <thead>
            <tr>
                <th>Sr No</th>
                <th>Bank Name</th>
                <th>Email (Multiline)</th>
            </tr>
        </thead>
        <tbody>
            <?php $sr = 1; ?>
            <?php while ($row = mysqli_fetch_assoc($result)): ?>
                <tr>
                    <td><?= $sr++; ?></td>

                    <td><?= htmlspecialchars($row['bank_name']); ?></td>

                    <td>
                        <?php
                        // multiline view only
                        $emails_display = str_replace(";", "<br>", $row['email_id']);
                        echo $emails_display;
                        ?>
                    </td>

                </tr>
            <?php endwhile; ?>
        </tbody>
    </table>

    <script>
        // Auto-open print dialog
        window.onload = function () {
            window.print();
        };
    </script>

</body>

</html>