<?php
header('Content-Type: text/html; charset=UTF-8');
?>

<?php
include "config.php";

$currentDate = date("d/m/Y");
$kycid = $_POST['kycid'] ?? '';
$print = $_POST['print'] ?? '';

$acknowledgement_no = "";
$complainantName = "";
$policestationId = "";

if (!empty($kycid)) {

    // Sanitize input for safety (basic level)
    $kycid = mysqli_real_escape_string($con, $kycid);

    $getKycData = "SELECT id, acknowledgement_no, complainant_name, policestation_id, police_id, subject_id, notice_id, created_by, created_at FROM kyc WHERE id = $kycid";

    $resultData = $con->query($getKycData);

    if ($resultData && $resultData->num_rows > 0) {
        $row = $resultData->fetch_assoc();
        // You can now access fields like:
        // $row['acknowledgement_no'], $row['complainant_name'], etc.
        $acknowledgement_no = $row['acknowledgement_no'];
        $complainantName = $row['complainant_name'];
        $policestationId = $row['policestation_id'];
        $policeId = $row['police_id'];
        $noticeId = $row['notice_id'];
        $subjectId = $row['subject_id'];

    } else {
        echo "No KYC data found.";
    }

     $getNotice = "SELECT `id`, `n_name`, `time_stamp` FROM `notice` 
                     WHERE `id` = '$noticeId' 
                     LIMIT 1";

    $resultNotice = $con->query($getNotice);

    if ($resultNotice && $resultNotice->num_rows > 0) {
        $row = $resultNotice->fetch_assoc();
    
            // Example: To access station name
            $noticeName = $row['n_name'];

    }
         $getSubject = "SELECT `id`, `s_name`, `time_stamp` FROM `subject` 
                     WHERE `id` = '$subjectId' 
                     LIMIT 1";

    $resultSubject = $con->query($getSubject);

    if ($resultSubject && $resultSubject->num_rows > 0) {
        $row = $resultSubject->fetch_assoc();
    
            // Example: To access station name
            $subjectName = $row['s_name'];

    }

        $getPoliceStation = "SELECT `id`, `spid`, `p_name`, `p_address`, `p_landline`, `p_number`, `p_email`, `timestamp` 
                     FROM `policestation` 
                     WHERE `id` = '$policestationId' 
                     LIMIT 1";

    $resultPoliceStation = $con->query($getPoliceStation);

    if ($resultPoliceStation && $resultPoliceStation->num_rows > 0) {
        $row = $resultPoliceStation->fetch_assoc();
    
            // Example: To access station name
            $policeStationName = $row['p_name'];
            $pAddress =$row['p_address'];
            $pLandLine =$row['p_landline'];
            $pNumber =$row['p_number'];
            $pEmail =$row['p_email'];            
    }

            $getPoliceInspector = "SELECT `id`, `pid`, `i_name`, `i_number`, `i_designation`, `i_sign` FROM `police` 
                                 WHERE `id` = '$policeId' 
                     LIMIT 1";

    $resultPoliceInspector = $con->query($getPoliceInspector);

    if ($resultPoliceInspector && $resultPoliceInspector->num_rows > 0) {
        $row = $resultPoliceInspector->fetch_assoc();
    
            // Example: To access station name
            $policeName = $row['i_name'];
            $policeNumber =$row['i_number'];
            $policeDesignation =$row['i_designation'];

    }
    

        if ($print === 'true') {
    echo '<script>window.onload = function() { window.print(); }</script>'; 
    }

    
    $sql = "SELECT `id`, `kyc_id`, `bank_id`, `bank_name`, `account_number`, `ifsc_code`, `account_holder`, `transaction_id`,`hold_amount`
            FROM `bank_accounts` 
            WHERE `kyc_id` = '$kycid'";

    $result = $con->query($sql);

    if ($result && $result->num_rows > 0) {
        while ($row = $result->fetch_assoc()) {
            ?>

<!DOCTYPE html>
<html>

<head>
    <meta charset="UTF-8">
    <title>BANK-LIEN AMOUNT</title>
    <link rel="stylesheet" href="https://www.w3schools.com/w3css/4/w3.css">
    <link rel="stylesheet" href="css/styles.css"> <!-- External CSS file -->
</head>

<body>

    <div class="a4-container">
        <!-- Header -->
        <div class="header-container">
            <img src="images/gp_logo.png" class="logo-left" alt="Police Logo">
            <div class="header-text">
                <h2><?php echo $policeStationName ?></h2>
                <p><?php echo htmlspecialchars($pAddress); ?></p>
                <p>Tel. no. <?php echo $pLandLine ?></p>
                <p class="email">E-mail ID: <?php  echo $pEmail;?></p>
            </div>
            <img src="images/azadi.png" class="logo-right" alt="Azadi Ka Amrit Mahotsav">
        </div>

        <!-- Title -->
        <div class="section-title">
            <?php
    $parts = explode('-', $noticeName);
    foreach ($parts as $index => $part) {
        echo strtoupper(trim($part));
        if ($index < count($parts) - 1) {
            echo "<br>";
        }
    }
    ?>
        </div>

        <!-- Outward block right aligned -->
        <div class="outward-details">
            <div class="outward-box">
                <b>
                    Outward number _________/2025,<br>
                    Date-<?php echo $currentDate; ?>
                </b>
            </div>
        </div>

        <!-- Recipient Info -->
        <div class="to-box">
            <b>
                To,<br>
                Nodal officer/The Manager<br>
                <?php echo htmlspecialchars($row['bank_name']); ?>
            </b>
        </div>


        <center style="margin-top: 5px;">
            <table>
                <tr>
                    <td><strong>Subject:</strong> <?php echo $subjectName; ?></td>
                </tr>
                <tr>
                    <td><strong>Reference:</strong> (1) Acknowledgement No./Ticket No.
                        <strong><?php echo $acknowledgement_no; ?></strong>
                    </td>
                </tr>
            </table>
        </center>


        <div class="letter-body">
            <p>Dear Sir/Madam,</p>
            <p>
                &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                I,Undersigned <b><?php echo strtoupper($policeName); ?></b>,
                <b><?php echo strtoupper($policeDesignation); ?></b>,
                <b><?php echo $policeStationName; ?></b>,
                <b><?php echo strtoupper($pAddress); ?></b>,
                brings to your notice that I am going to initiate the refund process regarding <b>Acknowledgement
                    No./Ticket No. <?php echo $acknowledgement_no; ?></b>, and below mentioned accounts is registered in
                your bank. You are
                requested to inform the Account holder that if he/she has any issues or objections, they can raise
                concerns with us within 3 (three) days. We request you to provide the Suspect bank account Statement,
                containing
                details, and confirmation of freeze/lien/put on hold amount as soon as possible (in the below format).
            </p>
        </div>

        <div class="account-table">
            <table class="w3-table-all w3-bordered">
                <thead>
                    <tr>
                        <th>Put on hold Amount </th>
                        <th>Account Number</th>
                        <th>IFSC Code</th>
                        <th>Transaction ID /UTR Number</th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td><?php echo htmlspecialchars($row['hold_amount']) ?></td>
                        <td><?php echo htmlspecialchars($row['account_number']) ?></td>
                        <td><?php echo htmlspecialchars($row['ifsc_code']) ?></td>
                        <td><?php echo htmlspecialchars($row['transaction_id']) ?></td>

                    </tr>
                </tbody>
            </table>
        </div>

        <br>

        <div class="account-table" style="margin-top: -15px;">
            <table class="w3-table-all w3-bordered">
                <thead>
                    <tr>
                        <th>Account Holder Name </th>
                        <th>Lien/Hold Amount </th>
                        <th>Current Available Balance </th>
                        <th>Status Freez or not </th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td style="padding: 5px;"><?php echo htmlspecialchars($row['account_holder']) ?></td>
                        <td> </td>
                        <td> </td>
                        <td> </td>
                    </tr>
                </tbody>
            </table>
        </div>

        <div class="instruction-block">
            <p>
                Hence, as per the powers conferred under BNSS 2023, Section 94, you are hereby instructed to:
            </p>
            <ol>
                <li>Provide a soft copy of the customer’s KYC documents.</li>
                <li>Submit a complete transaction statement from the account opening date to
                    <?php echo $currentDate; ?>.</li>
                <li>Share the registered contact number of the account holder and the email address of the home branch.
                </li>
            </ol>
            <p>
                Additionally, we request you to share information on whether any other agencies or law enforcement
                authorities (LEAs)
                have issued a freeze or lien on the aforementioned account. Kindly ensure the above information is
                submitted at the earliest.
                Please forward this request to the concerned branch.
                <br>
                <b>Thanking you.</b>
            </p>
            <p></p>
        </div>


        <!-- Signature Wrapper -->
        <div class="signature-container">
            <div class="signature-block">
                <b>
                    (<?php echo strtoupper($policeName); ?>)<br>
                    <?php echo strtoupper($policeDesignation); ?><br>
                    <?php echo strtoupper($policeStationName); ?><br>
                    <?php echo strtoupper($pAddress); ?><br>
                    <?php echo strtoupper($policeNumber); ?>
                </b>
            </div>

        </div>


    </div>

</body>

</html>

<?php

        //     echo "Bank Name: " . htmlspecialchars($row['bank_name']) . "<br>";
        //     echo "Account Number: " . htmlspecialchars($row['account_number']) . "<br>";
        //     echo "IFSC Code: " . htmlspecialchars($row['ifsc_code']) . "<br>";
        //     echo "Account Holder: " . htmlspecialchars($row['account_holder']) . "<br>";
        //     echo "Transaction ID: " . htmlspecialchars($row['transaction_id']) . "<br><hr>";
        }
    } else {
        echo "No bank details found for KYC ID: " . htmlspecialchars($kycid);
    }
} else {
    echo "No KYC ID provided.";
}
?>