<?php
header('Content-Type: text/html; charset=UTF-8');
?>

<?php
session_start();
include "config.php";

// Redirect if not logged in
if (!isset($_SESSION['user'])) {
    echo '<script>window.location.href = "index.php";</script>';
    exit();
}

$id = $_POST['id'] ?? '';
$print = $_POST['print'] ?? '';

// Fetch the comply_order details
$query = "SELECT * FROM comply_order WHERE id = $id";
$result = mysqli_query($con, $query);

if (!$result || mysqli_num_rows($result) === 0) {
    die("No record found.");
}

$data = mysqli_fetch_assoc($result);
$currentDate = date("d/m/Y");
// Optionally fetch related data like police, subject, etc.
$acknowledgement_no = $data['acknowlegement_no'];
$complainantName = $data['v_name'];
$policestationId = $data['pid'];  // ID, not name — useful for internal logic
$accountNo = $data['v_ac_no'];
$ifscCode = $data['v_ifsc'];
$courtOrder = $data['court_order'];
$subjectId = $data['subject_id'];
$policeId = $data['police_id'];
$bankId = $data['v_bank'];
$subjectName = "";

// Police name
if ($data['v_bank']) {
    $res = $con->query("SELECT b_name FROM bank WHERE id = " . (int)$data['v_bank']);
    if ($res && $res->num_rows > 0) {
        $bankName = $res->fetch_assoc()['b_name'];
    }
}


// Police 
$policeInfo = [];
if ($data['police_id']) {
    $res = $con->query("SELECT id, pid, i_name, i_number, i_designation, i_sign FROM police WHERE id = " . (int)$data['police_id']);
    if ($res && $res->num_rows > 0) {
        $policeInfo = $res->fetch_assoc();
    }
}


// Subject name
if ($data['subject_id']) {
    $res = $con->query("SELECT s_name FROM subject WHERE id = " . (int)$data['subject_id']);
    if ($res && $res->num_rows > 0) {
        $subjectName = $res->fetch_assoc()['s_name'];
    }
}

// Police station
$stationInfo = [];
if ($data['pid']) {
    $res = $con->query("SELECT id, spid, p_name, p_address, p_landline, p_number, p_email, timestamp FROM policestation WHERE id = " . (int)$data['pid']);
    if ($res && $res->num_rows > 0) {
        $stationInfo = $res->fetch_assoc();
    }
}



// Fetch c_bank_data entries with bank name
$bankData = [];
$bankQuery = "SELECT cb.*, b.b_name 
              FROM c_bank_data cb 
              LEFT JOIN bank b ON cb.bank_id = b.id 
              WHERE cb.comply_order_id = $id";
$bankResult = mysqli_query($con, $bankQuery);

if ($bankResult && mysqli_num_rows($bankResult) > 0) {
    while ($row = mysqli_fetch_assoc($bankResult)) {
        $bankData[] = $row;
    }
}

$policeInfo['i_name'];
$policeInfo['i_number'];
$policeInfo['i_designation'];
$policeInfo['i_sign'];
$stationInfo['p_name'];
$stationInfo['p_address'];
$stationInfo['p_landline'];
$stationInfo['p_number'];
$stationInfo['p_email'];

$policeStationName = $stationInfo['p_name'];
$pAddress = $stationInfo['p_address'];
$pLandLine = $stationInfo['p_landline'];
$pEmail = $stationInfo['p_email'];
$policeName = $policeInfo['i_name'];
$policeDesignation = $policeInfo['i_designation'];
$policeNumber = $policeInfo['i_number'];
$accountNo = $data['v_ac_no'];
$ifscCode = $data['v_ifsc'];
$banknameLatter = "";

$acNo_name_victim = $bankName."<br>".$complainantName. "<br>" . $accountNo;

$releaseInstructions = '';

 if ($print === 'true') {
    echo '<script>window.onload = function() { window.print(); }</script>'; 
    }

?>

<?php
// Group bank data by bank name
$groupedBankData = [];
foreach ($bankData as $item) {
    $groupedBankData[$item['b_name']][] = $item;
}

?>

<?php foreach ($groupedBankData as $bankName => $entries): ?>

<?php
$releaseInstructions = "This is to bring to your kind notice that Chief Judicial Magistrate court, Tapi has given direction to $policeStationName stating to give direction to concerned ";

$sentences = [];
foreach ($entries as $data) {
    $accno = $data['account_number'];
    $amount = $data['release_amount'];
    $sentences[] = "Manager of $bankName account No.$accno to de-freeze the amount of Rs.$amount/-";
}

$releaseInstructions .= implode(" & ", $sentences);

// Complainant's bank details
$complainantBankName = '';
if (!empty($bankId)) {
    $res = $con->query("SELECT b_name FROM bank WHERE id = " . (int)$bankId);
    if ($res && $res->num_rows > 0) {
        $complainantBankName = $res->fetch_assoc()['b_name'];
    }
}

$complainantAcc = htmlspecialchars($accountNo);
$complainantIFSC = htmlspecialchars($ifscCode);

$releaseInstructions .= " and release the said amount to the account of complainant’s $complainantBankName Account No.$complainantAcc IFSC Code-$complainantIFSC and submit the report to the court forthwith.";
?>

<!DOCTYPE html>
<html>

<head>
    <meta charset="UTF-8">
    <title>BANK-COMPLY ORDER</title>
    <link rel="stylesheet" href="https://www.w3schools.com/w3css/4/w3.css">
    <link rel="stylesheet" href="css/styles.css"> <!-- External CSS file -->
</head>

<body>

    <div class="a4-container">
        <!-- Header -->
        <div class="header-container">
            <img src="images/gp_logo.png" class="logo-left" alt="Police Logo">
            <div class="header-text">
                <h2><?php echo $policeStationName ?></h2>
                <p><?php echo htmlspecialchars($pAddress); ?></p>
                <p>Tel. no. <?php echo $pLandLine ?></p>
                <p class="email">E-mail ID: <?php  echo $pEmail;?></p>
            </div>
            <img src="images/azadi.png" class="logo-right" alt="Azadi Ka Amrit Mahotsav">
        </div>

        <!-- Title -->
        <div class="section-title">
            <?php //echo strtoupper($noticeName);?>
        </div>

        <!-- Outward block right aligned -->
        <div class="outward-details">
            <div class="outward-box">
                <b>
                    Outward number _________/2025,<br>
                    Date-<?php echo $currentDate; ?>
                </b>
            </div>
        </div>

        <!-- Recipient Info for each bank -->
        <div class="to-box">
            <b>
                To,<br>
                Nodal officer / The Manager<br>
                <?php echo htmlspecialchars($bankName); ?>
            </b>
        </div>

        <center style="margin-top: 5px;">
            <table>
                <tr>
                    <td><strong>Subject:</strong> <?php echo $subjectName; ?></td>
                </tr>
                <tr>
                    <td><strong>Reference:</strong> (1) Acknowledgement No./Ticket No.
                        <strong><?php echo $acknowledgement_no; ?></strong>
                    </td>
                </tr>
            </table>
        </center>

        <!-- Release Instruction -->
        <div class="letter-body">
            <p>Dear Sir/Madam,</p>
            <p>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                <?php echo $releaseInstructions?>
                This is to bring to your kind notice that Chief Judicial Magistrate court, Tapi has given direction to
                <?php echo $policeStationName; ?> stating to give direction to concerned
                Manager of <?php echo $bankName; ?> accounts as below:</p>
        </div>

        <div class="account-table">
            <table class="w3-table-all w3-bordered">
                <thead>
                    <tr>
                        <th>Victim Account Number and Name</th>
                        <th>IFSC Code</th>
                        <th>Suspect Account Number and Name</th>
                        <th>IFSC Code</th>
                        <th>Release Amount</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($entries as $entry): ?>
                    <tr>
                        <td><?php echo $acNo_name_victim; ?></td>
                        <td><?php echo htmlspecialchars($ifscCode); ?></td>
                        <td><?php echo htmlspecialchars($entry['b_name']) . "<br>" . htmlspecialchars($entry['account_holder']) . "<br>" . htmlspecialchars($entry['account_number']); ?>
                        </td>
                        <td><?php echo htmlspecialchars($entry['ifsc_code']); ?></td>
                        <td><?php echo htmlspecialchars($entry['release_amount']); ?></td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>

        <div class="instruction-block">
            <p>
                Therefore, you are hereby directed to act according to the order passed by the honorable court and
                comply
                with this order in writing in 10 days. A scanned copy of the court order is attached herewith for your
                kind
                perusal.
            </p>
            <p> Thanking you, </p>
        </div>

        <!-- Signature Block -->
        <div class="signature-container">
            <div class="signature-block">
                <b>
                    (<?php echo strtoupper($policeName); ?>)<br>
                    <?php echo strtoupper($policeDesignation); ?><br>
                    <?php echo strtoupper($policeStationName); ?><br>
                    <?php echo strtoupper($pAddress); ?><br>
                    <?php echo strtoupper($policeNumber); ?>
                </b>
            </div>
        </div>

    </div>

</body>

</html>
<?php endforeach; ?>