<?php
session_start();
include "config.php";

// Redirect if user not logged in
if (!isset($_SESSION['user'])) {
    echo '<script>window.location.href = "index.php";</script>';
    exit();
}

$user = $_SESSION['user'];
$pid = $user['pid'];
$uid = $user['id'];
// Check if POST data is set
if ($_SERVER["REQUEST_METHOD"] === "POST") {

    // Sanitize input
    $ack_no = isset($_POST['acknowledgement_number']) ? trim($_POST['acknowledgement_number']) : '';
    $fraud_type = isset($_POST['fraud_type']) ? trim($_POST['fraud_type']) : '';
    $subject_id = isset($_POST['subject_id']) ? trim($_POST['subject_id']) : '';
    $notice_id = isset($_POST['notice_id']) ? trim($_POST['notice_id']) : '';
    $police_id = isset($_POST['police_id']) ? trim($_POST['police_id']) : '';
    
    

    $facebook_ids_json = isset($_POST['facebook_ids']) ? $_POST['facebook_ids'] : '[]';

    // Decode Facebook IDs JSON into PHP array
    $facebook_ids = json_decode($facebook_ids_json, true);

    // Validate inputs
    if (empty($ack_no) || empty($fraud_type) || !is_array($facebook_ids) || count($facebook_ids) == 0) {
        echo "<script>alert('All fields are required.'); window.location.href='facebook.php';</script>";
        exit();
    }

    // Escape user inputs to prevent SQL injection
    $ack_no_escaped = mysqli_real_escape_string($con, $ack_no);
    $fraud_type_escaped = mysqli_real_escape_string($con, $fraud_type);
     $subject_id_escaped = mysqli_real_escape_string($con, $subject_id);
    $notice_id_escaped = mysqli_real_escape_string($con, $notice_id);
    $police_id_escaped = mysqli_real_escape_string($con, $police_id);

    $facebook_ids_json_escaped = mysqli_real_escape_string($con, json_encode($facebook_ids));

    // Insert a single row with all Facebook IDs stored as JSON string
    $query = "INSERT INTO facebook_data (uid,pid,police_id,ack_no, fraud_type,notice_id,subject_id, facebook_id) 
    VALUES ('$uid','$pid','$police_id_escaped','$ack_no_escaped', '$fraud_type_escaped','$notice_id','$subject_id', '$facebook_ids_json_escaped')";

    if (mysqli_query($con, $query)) {
        echo "<script>alert('Facebook entries added successfully.'); window.location.href='facebook.php';</script>";
    } else {
        echo "<script>alert('Error while inserting data.'); window.location.href='facebook.php';</script>";
    }

    mysqli_close($con);

} else {
    // If accessed without POST, redirect back
    echo "<script>window.location.href='facebook.php';</script>";
    exit();
}
?>