<?php
// Database connection
include 'config.php'; // Include database connection

// Fetch data from 'location' table
$sql = "SELECT id, latitude, longitude, location_time FROM location ORDER BY location_time DESC";
$result = $con->query($sql);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Data Table</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            text-align: center;
        }
        table {
            width: 80%;
            margin: auto;
            border-collapse: collapse;
            box-shadow: 0px 0px 10px #aaa;
        }
        th, td {
            padding: 10px;
            border: 1px solid #ddd;
            text-align: left;
        }
        th {
            background: #333;
            color: white;
        }
        tr:nth-child(even) {
            background: #f2f2f2;
        }
        .map-button {
            background-color: #28a745;
            color: white;
            padding: 6px 12px;
            border: none;
            cursor: pointer;
            border-radius: 5px;
            font-size: 14px;
        }
        .map-button:hover {
            background-color: #218838;
        }
    </style>
</head>
<body>

<h2>User Location Data</h2>

<table>
    <tr>
        <th>ID</th>
        <th>Latitude</th>
        <th>Longitude</th>
        <th>Timestamp</th>
        <th>Action</th>
    </tr>

    <?php
    if ($result->num_rows > 0) {
        while ($row = $result->fetch_assoc()) {
            // Format location_time (dd/mm/yyyy hh:mm:ss AM/PM)
            $formattedTime = date("d/m/Y h:i:s A", strtotime($row['location_time']));
            $lat = $row['latitude'];
            $lng = $row['longitude'];
            echo "<tr>
                    <td>{$row['id']}</td>
                    <td>{$lat}</td>
                    <td>{$lng}</td>
                    <td>{$formattedTime}</td>
                    <td>
                        <a href='https://www.google.com/maps?q={$lat},{$lng}' target='_blank'>
                            <button class='map-button'>Show on Map</button>
                        </a>
                    </td>
                  </tr>";
        }
    } else {
        echo "<tr><td colspan='5'>No data found</td></tr>";
    }
    $con->close();
    ?>

</table>

</body>
</html>
