<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

include('config.php');

// Create connection
$con = new mysqli($host, $username, $password, $database);

// Check connection
if ($con->connect_error) {
    die("Connection failed: " . $con->connect_error);
}

// Fetch all location data
$sql = "SELECT id, latitude, longitude FROM location ORDER BY id DESC";
$result = $con->query($sql);
?>

<!DOCTYPE html>
<html>
<head>
    <title>Location List</title>
    <style>
        table {
            width: 100%;
            border-collapse: collapse;
        }
        th, td {
            border: 1px solid black;
            padding: 8px;
            text-align: center;
        }
        th {
            background-color: #f2f2f2;
        }
        button {
            padding: 5px 10px;
            background-color: blue;
            color: white;
            border: none;
            cursor: pointer;
        }
        button:hover {
            background-color: darkblue;
        }
    </style>
</head>
<body>

<h2>Stored Locations</h2>

<table>
    <tr>
        <th>ID</th>
        <th>Latitude</th>
        <th>Longitude</th>
        <th>Action</th>
    </tr>

    <?php
    if ($result->num_rows > 0) {
        while ($row = $result->fetch_assoc()) {
            echo "<tr>
                    <td>{$row['id']}</td>
                    <td>{$row['latitude']}</td>
                    <td>{$row['longitude']}</td>
                    <td><button onclick=\"viewOnMap({$row['latitude']}, {$row['longitude']})\">View on Map</button></td>
                </tr>";
        }
    } else {
        echo "<tr><td colspan='4'>No locations found</td></tr>";
    }
    $con->close();
    ?>
</table>

<script>
function viewOnMap(lat, lng) {
    window.location.href = `https://www.google.com/maps?q=${lat},${lng}`;
}
</script>

</body>
</html>
