<?php
session_start();
include "config.php";

// Redirect if user is not logged in
if (!isset($_SESSION['user'])) {
    echo '<script>window.location.href = "index.php";</script>';
    exit();
}



// Get user details from session
$user = $_SESSION['user'];

//echo "Welcome " . htmlspecialchars($user['name'] ?? 'User') . "<br>";
//echo "Email: " . htmlspecialchars($user['email'] ?? '') . "<br>";
//echo "Phone: " . htmlspecialchars($user['phone'] ?? '') . "<br>";
$pid = $user['pid'];
// Fetch all users

$complyQuery = "    SELECT `id`,`uid`,`pid`,`police_id`, `court_order`,`acknowlegement_no`, `subject_id`,
        `v_name`,`v_bank`,`v_ac_no`,`v_ifsc`,`bank_data`,`time_stamp` FROM `comply_order` 
    WHERE `pid` = '$pid' ORDER BY `id` DESC";
$resultComply = mysqli_query($con, $complyQuery);


?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>BANK-COMPLY ORDER</title>

    <!-- Main CSS -->
    <link rel="stylesheet" type="text/css" href="css/main.css">

    <!-- Bootstrap Icons -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css">
</head>

<body class="app sidebar-mini">
    <!-- Navbar-->

    <!-- Navbar-->
    <?php include "header.php" ?>
    <!-- Sidebar menu-->
    <div class="app-sidebar__overlay" data-toggle="sidebar"></div>
    <aside class="app-sidebar">

        <?php include "./common/name.php" ?>

        <ul class="app-menu">

            <li><a class="app-menu__item  " href="main.php"><i class="app-menu__icon bi bi-speedometer"></i><span
                        class="app-menu__label">Dashboard</span></a>
            </li>

            <li class="treeview"><a class="app-menu__item active" data-toggle="treeview"><i
                        class="app-menu__icon bi bi-laptop"></i><span class="app-menu__label">Bank</span><i
                        class="treeview-indicator bi bi-chevron-right"></i></a>
                <ul class="treeview-menu">
                    <li><a class="treeview-item" href="kycform.php"><i class="icon bi bi-circle-fill"></i>KYC</a>
                    </li>
                    <li><a class="treeview-item" href="lien_amount.php"><i class="icon bi bi-circle-fill"></i>
                            LIAN AMOUNT</a></li>
                    <li><a class="treeview-item active" href="comply_order.php"><i class="icon bi bi-circle-fill"></i>
                            COMPLY
                            ORDER</a> </li>
                    <li><a class="treeview-item" href="cctv.php"><i class="icon bi bi-circle-fill"></i> CCTV</a> </li>
                </ul>
            </li>

        </ul>

    </aside>


    <main class="app-content">
        <div class="app-title">
            <div>
                <h1>Comply Order</h1>
            </div>
            <ul class="app-breadcrumb breadcrumb side">
                <li class="breadcrumb-item"><i class="bi bi-house-door fs-6"></i></li>
                <li class="breadcrumb-item">Bank</li>
                <li class="breadcrumb-item active"><a href="#">Comply Order</a></li>
            </ul>
        </div>

        <div class="tile-title-w-btn d-flex justify-content-end">
            <p class="mb-10">
                <a href="add_comply_order.php" class="btn btn-primary icon-btn">
                    <i class="bi bi-plus-square me-2"></i>Add
                </a>
            </p>
        </div>


        <div class="row">
            <div class="col-md-12">
                <div class="tile">
                    <div class="tile-body">
                        <div class="table-responsive">
                            <table class="table table-hover table-bordered" id="sampleTable">
                                <thead>
                                    <tr>
                                        <th>ID</th>
                                        <th>Acknowledgement</th>
                                        <th>Complaint Name</th>
                                        <th>Police Station</th>
                                        <th>Police Name</th>
                                        <th>Subject</th>
                                        <th>View</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php if (mysqli_num_rows($resultComply) > 0): ?>
                                    <?php $serial = 1; ?>
                                    <?php while($row = mysqli_fetch_assoc($resultComply)): ?>
                                    <tr>
                                        <td><?= $serial++; ?></td>
                                        <td><?= htmlspecialchars($row['acknowlegement_no']) ?></td>
                                        <td><?= htmlspecialchars($row['v_name']) ?></td>
                                        <td>
                                            <?php
                                                    $id = (int)$row['pid'];
                                                    $result0 = $con->query("SELECT * FROM `policestation` WHERE id = $id");
                                                    if ($result0 && $result0->num_rows > 0) {
                                                        $data = $result0->fetch_assoc();
                                                        echo htmlspecialchars($data['p_name']);
                                                    } else {
                                                        echo "Name not found";
                                                    }
                                                    ?>
                                        </td>
                                        <td>
                                            <?php
                                                    $id = (int)$row['police_id'];
                                                    $result0 = $con->query("SELECT * FROM `police` WHERE id = $id");
                                                    if ($result0 && $result0->num_rows > 0) {
                                                        $data = $result0->fetch_assoc();
                                                        echo htmlspecialchars($data['i_name']);
                                                    } else {
                                                        echo "Name not found";
                                                    }
                                                    ?>
                                        </td>
                                        <td>
                                            <?php
                                                    $id = (int)$row['subject_id'];
                                                    $result0 = $con->query("SELECT * FROM `subject` WHERE id = $id");
                                                    if ($result0 && $result0->num_rows > 0) {
                                                        $data = $result0->fetch_assoc();
                                                        echo htmlspecialchars($data['s_name']);
                                                    } else {
                                                        echo "Name not found";
                                                    }
                                                    ?>
                                        </td>
                                        <td>
                                            <form action="view_comply_order.php" method="POST" style="display:inline;">
                                                <input type="hidden" name="id"
                                                    value="<?= htmlspecialchars($row['id']) ?>">
                                                <input type="hidden" name="print" value="true">

                                                <button type="submit" class="btn btn-primary btn-sm">View</button>
                                            </form>
                                        </td>
                                    </tr>
                                    <?php endwhile; ?>
                                    <?php else: ?>
                                    <?php endif; ?>

                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </main>
    <!-- Essential javascripts for application to work-->
    <script src="js/jquery-3.7.0.min.js"></script>
    <script src="js/bootstrap.min.js"></script>
    <script src="js/main.js"></script>
    <!-- Page specific javascripts-->
    <link rel="stylesheet" href="https://cdn.datatables.net/v/bs5/dt-1.13.4/datatables.min.css" />
    <!-- Data table plugin-->
    <script type="text/javascript" src="js/plugins/jquery.dataTables.min.js"></script>
    <script type="text/javascript" src="js/plugins/dataTables.bootstrap.min.js"></script>

    <script type="text/javascript">
    $('#sampleTable').DataTable();
    </script>
    <!-- Google analytics script-->

</body>

</html>