<?php
session_start();
include "config.php";

// Redirect if user is not logged in
if (!isset($_SESSION['user'])) {
    header("Location: index.php");
    exit();
}

// Get user details from session
$user = $_SESSION['user'];

//echo "Welcome " . htmlspecialchars($user['name'] ?? 'User') . "<br>";
//echo "Email: " . htmlspecialchars($user['email'] ?? '') . "<br>";
//echo "Phone: " . htmlspecialchars($user['phone'] ?? '') . "<br>";

// Fetch all users
$noticeQuery = "SELECT * FROM `notice`";
$resultNotice = mysqli_query($con, $noticeQuery);


$policeStationQuery = "SELECT * FROM `policestation` WHERE id='{$user['pid']}'";
$resultPoliceStation = mysqli_query($con, $policeStationQuery);

$policeQuery = "SELECT * FROM `police`";
$resultPolice = mysqli_query($con, $policeQuery);

//$policeQuery = "SELECT * FROM `policestation` WHERE id='{$user['pid']}'";
//$resultPolice = mysqli_query($con, $policeQuery);

$subjectQuery = "SELECT * FROM `subject` WHERE `s_name` LIKE '%CCTV%'";
$resultSubject = mysqli_query($con, $subjectQuery);

$noticeQuery = "SELECT * FROM `notice` WHERE `n_name` LIKE '%94%' ";
$resultNotice = mysqli_query($con, $noticeQuery);

$bankQuery = "SELECT * FROM `bank`";
$resultBank = mysqli_query($con, $bankQuery);



?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <title>CCTV</title>

    <!-- Main CSS -->
    <link rel="stylesheet" type="text/css" href="css/main.css">

    <!-- Bootstrap Icons -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css">
</head>

<body class="app sidebar-mini">
    <!-- Navbar-->

    <!-- Navbar-->
    <?php include "header.php" ?>
    <!-- Sidebar menu-->
    <div class="app-sidebar__overlay" data-toggle="sidebar"></div>
    <aside class="app-sidebar">

        <?php include "./common/name.php" ?>

        <ul class="app-menu">

            <li><a class="app-menu__item  " href="main.php"><i class="app-menu__icon bi bi-speedometer"></i><span
                        class="app-menu__label">Dashboard</span></a>
            </li>

            <li class="treeview"><a class="app-menu__item active" data-toggle="treeview"><i
                        class="app-menu__icon bi bi-laptop"></i><span class="app-menu__label">Bank</span><i
                        class="treeview-indicator bi bi-chevron-right"></i></a>
                <ul class="treeview-menu">
                    <li><a class="treeview-item" href="kycform.php"><i class="icon bi bi-circle-fill"></i>KYC</a>
                    </li>
                    <li><a class="treeview-item" href="lien_amount.php"><i class="icon bi bi-circle-fill"></i> LIAN
                            AMOUNT</a></li>
                    <li><a class="treeview-item" href="comply_order.php"><i class="icon bi bi-circle-fill"></i> COMPLY
                            ORDER</a> </li>
                    <li><a class="treeview-item active" href="cctv.php"><i class="icon bi bi-circle-fill"></i> CCTV</a>
                    </li>
                </ul>
            </li>

        </ul>

    </aside>


    <main class="app-content">
        <div class="app-title">
            <div>
                <h1>CCTV</h1>
            </div>
            <ul class="app-breadcrumb breadcrumb side">
                <li class="breadcrumb-item"><i class="bi bi-house-door fs-6"></i></li>
                <li class="breadcrumb-item">BANK</li>
                <li class="breadcrumb-item active"><a href="#">CCTV</a></li>
            </ul>
        </div>


        <div class="row">
            <form method="POST" action="cctv_form.php" enctype="multipart/form-data">
                <div class="text-end mb-3">
                    <button type="submit" class="btn btn-success">Submit</button>
                </div>

                <div class="row">
                    <div class="col-md-6">
                        <div class="tile">
                            <div class="tile-body">

                                <div class="mb-3">
                                    <label class="form-label">Acknowledgement No.</label>
                                    <input class="form-control" type="number" name="ack_no"
                                        placeholder="Enter Acknowledgement No." required>
                                </div>

                                <div class="mb-3">
                                    <label class="form-label">Complainant Name</label>
                                    <input class="form-control" type="text" name="complainant_name"
                                        placeholder="Enter Complainant" required>
                                </div>


                                <div class="mb-3">
                                    <label class="form-label">Select Police Station</label>
                                    <select class="form-control" name="policestation_id" id="policestation_id" required>
                                        <option value="">-- Select Police Station --</option>
                                        <?php while ($row = mysqli_fetch_assoc($resultPoliceStation)) { ?>
                                        <option value="<?php echo $row['id']; ?>">
                                            <?php echo htmlspecialchars($row['p_name']); ?>
                                        </option>
                                        <?php } ?>
                                    </select>
                                </div>


                                <div class="mb-3">
                                    <label class="form-label">Select Police</label>
                                    <select class="form-control" name="police_id" id="police_id" required>
                                        <option value="">-- Select Police --</option>
                                        <!-- Options will be populated using AJAX -->
                                    </select>
                                </div>


                                <div class="mb-3">
                                    <label class="form-label">Select Subject</label>
                                    <select class="form-control" name="subject_id" required>
                                        <?php while ($row = mysqli_fetch_assoc($resultSubject)) { ?>
                                        <option value="<?php echo $row['id']; ?>">
                                            <?php echo htmlspecialchars($row['s_name']); ?>
                                        </option>
                                        <?php } ?>
                                    </select>
                                </div>

                                <div class="mb-3">
                                    <label class="form-label">Select Notice</label>
                                    <select class="form-control" name="notice_id" required>
                                        <?php while ($row = mysqli_fetch_assoc($resultNotice)) { ?>
                                        <option value="<?php echo $row['id']; ?>">
                                            <?php echo htmlspecialchars($row['n_name']); ?>
                                        </option>
                                        <?php } ?>
                                    </select>
                                </div>



                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="tile">
                            <div class="tile-body">

                                <!-- BANK FIELDS -->
                                <div id="bank-form">
                                    <div class="mb-3">
                                        <label class="form-label">Select Bank</label>
                                        <select class="form-control" id="bank_id">
                                            <option value="">-- Select Bank --</option>
                                            <?php while ($row = mysqli_fetch_assoc($resultBank)) { ?>
                                            <option value="<?php echo $row['id']; ?>"
                                                data-name="<?php echo htmlspecialchars($row['b_name']); ?>">
                                                <?php echo htmlspecialchars($row['b_name']); ?>
                                            </option>
                                            <?php } ?>
                                        </select>
                                    </div>

                                    <div class="mb-3">
                                        <label class="form-label">ATM ID</label>
                                        <input class="form-control" type="text" id="atm_id" placeholder="Enter ATM ID">
                                    </div>

                                    <div class="mb-3">
                                        <label class="form-label">START DATE TIME</label>
                                        <input class="form-control" type="datetime-local" id="start_date_time"
                                            name="start_date_time">
                                    </div>

                                    <div class="mb-3">
                                        <label class="form-label">END DATE TIME</label>
                                        <input class="form-control" type="datetime-local" id="end_date_time"
                                            name="end_date_time">
                                    </div>

                                    <div class="mb-3">
                                        <label class="form-label">Difference in Time</label>
                                        <p id="time_difference" style="font-weight: bold;"></p>
                                    </div>

                                    <input type="hidden" name="bank_accounts_json" id="bank_accounts_json" required>

                                    <button type="button" class="btn btn-primary btn-sm" onclick="addBankCctv()">Add
                                        Bank
                                        Data</button>
                                </div>
                            </div>
                        </div>
            </form>
        </div>

        <!-- Display added bank accounts -->
        <div class="row">
            <div class="col-md-12">
                <div class="tile">
                    <h5 class="mt-0">Added Bank Accounts:</h5>
                    <div class="tile-body">
                        <div class="table-responsive">
                            <table class="table table-hover table-bordered" id="bank-table">
                                <thead>
                                    <tr>
                                        <th>Bank Name</th>
                                        <th>ATM ID</th>
                                        <th>START DATE TIME</th>
                                        <th>END DATE TIME</th>
                                        <th>Delete</th>
                                    </tr>
                                </thead>
                                <tbody>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </main>

    <!-- Essential javascripts for application to work-->
    <script src="js/jquery-3.7.0.min.js"></script>
    <script src="js/bootstrap.min.js"></script>
    <script src="js/main.js"></script>
    <!-- Page specific javascripts-->
    <link rel="stylesheet" href="https://cdn.datatables.net/v/bs5/dt-1.13.4/datatables.min.css">
    <!-- Data table plugin-->
    <script type="text/javascript" src="js/plugins/jquery.dataTables.min.js"></script>
    <script type="text/javascript" src="js/plugins/dataTables.bootstrap.min.js"></script>
    <script type="text/javascript">
    //$('#bank-table').DataTable();
    </script>
    <!-- Google analytics script-->

    <script>
    let bankCctvData = [];

    function formatDateTime(dateTimeStr) {
        const date = new Date(dateTimeStr);
        return date.toLocaleString('en-IN', {
            day: '2-digit',
            month: '2-digit',
            year: 'numeric',
            hour: '2-digit',
            minute: '2-digit',
            hour12: true
        });
    }

    function addBankCctv() {
        const bankSelect = document.getElementById('bank_id');
        const bankId = bankSelect.value;
        const bankName = bankSelect.options[bankSelect.selectedIndex].getAttribute('data-name');
        const atmId = document.getElementById('atm_id').value.trim();
        const startDateTime = document.getElementById('start_date_time').value;
        const endDateTime = document.getElementById('end_date_time').value;

        if (!bankId || !atmId || !startDateTime || !endDateTime) {
            alert("Please fill in all fields.");
            return;
        }

        // Format the datetime strings
        const formattedStart = formatDateTime(startDateTime);
        const formattedEnd = formatDateTime(endDateTime);

        const entry = {
            bank_id: bankId,
            bank_name: bankName,
            atm_id: atmId,
            start_date_time: formattedStart,
            end_date_time: formattedEnd
        };

        bankCctvData.push(entry);



        // Update hidden JSON input
        document.getElementById('bank_accounts_json').value = JSON.stringify(bankCctvData);

        // Add to table
        const tableBody = document.querySelector('#bank-table tbody');
        const rowIndex = bankCctvData.length - 1;

        const row = document.createElement('tr');
        row.innerHTML = `
            <td>${bankName}</td>
            <td>${atmId}</td>
             <td>${formattedStart}</td>
        <td>${formattedEnd}</td>
            <td><button type="button" class="btn btn-danger btn-sm" onclick="deleteBankRow(${rowIndex})">Delete</button></td>
        `;
        tableBody.appendChild(row);

        // Clear form fields
        bankSelect.selectedIndex = 0;
        document.getElementById('atm_id').value = '';
        document.getElementById('start_date_time').value = '';
        document.getElementById('end_date_time').value = '';
        document.getElementById('time_difference').innerText = '';
    }

    function deleteBankRow(index) {
        bankCctvData.splice(index, 1); // Remove from data array

        // Re-render table
        const tableBody = document.querySelector('#bank-table tbody');
        tableBody.innerHTML = ''; // Clear

        bankCctvData.forEach((entry, i) => {
            const row = document.createElement('tr');
            row.innerHTML = `
                <td>${entry.bank_name}</td>
                <td>${entry.atm_id}</td>
                <td>${entry.start_date_time}</td>
<td>${entry.end_date_time}</td>
                <td><button type="button" class="btn btn-danger btn-sm" onclick="deleteBankRow(${i})">Delete</button></td>
            `;
            tableBody.appendChild(row);
        });

        // Update hidden JSON input
        document.getElementById('bank_accounts_json').value = JSON.stringify(bankCctvData);
    }
    </script>


    <script>
    document.getElementById('policestation_id').addEventListener('change', function() {
        var stationId = this.value;
        var policeDropdown = document.getElementById('police_id');
        policeDropdown.innerHTML = '<option value="">Loading...</option>';

        fetch('get_police_by_station.php?station_id=' + stationId)
            .then(response => response.json())
            .then(data => {
                console.log('Fetched Police Data:', data); // 👈 This prints data to the console
                policeDropdown.innerHTML = '<option value="">-- Select Police --</option>';
                data.forEach(function(police) {
                    var option = document.createElement('option');
                    option.value = police.id;
                    option.text = police.i_name;
                    policeDropdown.appendChild(option);
                });
            })
            .catch(error => console.error('Error fetching police data:', error));
    });
    </script>

    <script>
    const startInput = document.getElementById('start_date_time');
    const endInput = document.getElementById('end_date_time');
    const diffDisplay = document.getElementById('time_difference');

    function updateTimeDifference() {
        const start = new Date(startInput.value);
        const end = new Date(endInput.value);

        if (!isNaN(start) && !isNaN(end)) {
            const diffMs = end - start;
            const diffMins = Math.floor(diffMs / 60000); // Convert ms to minutes
            if (diffMins >= 0) {
                diffDisplay.innerText = diffMins + ' minute(s)';
            } else {
                diffDisplay.innerText = 'End time must be after start time';
            }
        } else {
            diffDisplay.innerText = '';
        }
    }

    startInput.addEventListener('change', updateTimeDifference);
    endInput.addEventListener('change', updateTimeDifference);
    </script>



</body>

</html>