<?php
session_start();
include "config.php";
$currentDate = date("d/m/Y");
if (!isset($_SESSION['user'])) {
    echo '<script>window.location.href = "index.php";</script>';
    exit();
}

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['facebook_id'])) {
    $facebookId = intval($_POST['facebook_id']);

    // Fetch Facebook data
    $query = "SELECT * FROM `facebook_data` WHERE id = $facebookId";
    $result = mysqli_query($con, $query);

    if (!$result || mysqli_num_rows($result) == 0) {
        exit("No record found.");
    }

    $data = mysqli_fetch_assoc($result);
    $acknowledgement_no = htmlspecialchars($data['ack_no']);
    $pid = intval($data['pid']);
    $policeId = intval($data['police_id']);
    $noticeId = intval($data['notice_id']);
    $subjectId = intval($data['subject_id']);
    $policeStationName = "";
    $pAddress = "";
    $pLandLine ="";
    $pEmail = "";
    $noticeName = "";
    $policeName = "";
    $policeDesignation = "";
    $complainantName = "";
    $policeNumber ="";
    $subjectName ="";

// Fetch Police Station
$policeStation = $con->query("SELECT * FROM `policestation` WHERE id = $pid LIMIT 1")->fetch_assoc();

// Fetch Police Inspector
$police = $con->query("SELECT * FROM `police` WHERE id = $policeId LIMIT 1")->fetch_assoc();

// Fetch Notice
$notice = $con->query("SELECT `n_name` FROM `notice` WHERE id = $noticeId LIMIT 1")->fetch_assoc();

// Fetch Subject
$subject = $con->query("SELECT `s_name` FROM `subject` WHERE id = $subjectId LIMIT 1")->fetch_assoc();

// Display Information
echo "<h3>Facebook Data Details:</h3>";
echo "<p><strong>ID:</strong> {$data['id']}</p>";
echo "<p><strong>UID:</strong> {$data['uid']}</p>";
echo "<p><strong>Acknowledgement No:</strong> {$acknowledgement_no}</p>";
echo "<p><strong>Fraud Type:</strong> {$data['fraud_type']}</p>";
echo "<p><strong>Notice:</strong> {$notice['n_name']}</p>";
echo "<p><strong>Subject:</strong> {$subject['s_name']}</p>";
echo "<p><strong>Created At:</strong> {$data['created_at']}</p>";

    $policeStationName = $policeStation['p_name'];
    $pAddress = $policeStation['p_address'];
    $pLandLine =$policeStation['p_landline'];
    $pEmail = $policeStation['p_email'];
    $noticeName = $notice['n_name'];
    $subjectName =$subject['s_name'];
    $policeName = $police['i_name'];
    $policeDesignation = $police['i_designation'];
    $policeNumber = $police['i_number'];
    $complainantName = "";

// Display Police Station
echo "<h4>Police Station:</h4>";
echo "<p><strong>Name:</strong> {$policeStation['p_name']}</p>";
echo "<p><strong>Address:</strong> {$policeStation['p_address']}</p>";
echo "<p><strong>Landline:</strong> {$policeStation['p_landline']}</p>";
echo "<p><strong>Mobile:</strong> {$policeStation['p_number']}</p>";
echo "<p><strong>Email:</strong> {$policeStation['p_email']}</p>";

// Display Police Inspector
echo "<h4>Police Inspector:</h4>";
echo "<p><strong>Name:</strong> {$police['i_name']}</p>";
echo "<p><strong>Mobile:</strong> {$police['i_number']}</p>";
echo "<p><strong>Designation:</strong> {$police['i_designation']}</p>";

} else {
echo "Invalid request.";
}
?>

<!DOCTYPE html>
<html>

<head>
    <meta charset="UTF-8">
    <title>Facebook</title>
    <link rel="stylesheet" href="https://www.w3schools.com/w3css/4/w3.css">
    <link rel="stylesheet" href="css/styles.css"> <!-- External CSS file -->
</head>

<body>

    <div class="a4-container">
        <!-- Header -->
        <div class="header-container">
            <img src="images/gp_logo.png" class="logo-left" alt="Police Logo">
            <div class="header-text">
                <h2><?php echo $policeStationName ?></h2>
                <p><?php echo htmlspecialchars($pAddress); ?></p>
                <p>Tel. no. <?php echo $pLandLine ?></p>
                <p class="email">E-mail ID: <?php  echo $pEmail;?></p>
            </div>
            <img src="images/azadi.png" class="logo-right" alt="Azadi Ka Amrit Mahotsav">
        </div>

        <!-- Title -->
        <div class="section-title">
            <?php echo strtoupper($noticeName);?>
        </div>

        <!-- Outward block right aligned -->
        <div class="outward-details">
            <div class="outward-box">
                <b>
                    Outward number _________/2025,<br>
                    Date-<?php echo $currentDate; ?>
                </b>
            </div>
        </div>

        <!-- Recipient Info -->
        <div class="to-box">
            <b>
                To,<br>
                Nodal officer/The Manager<br>

            </b>
        </div>

        <div class="subject">
            Subject: <?php echo $subjectName;?>
        </div>


        Dear Sir/Mam
        I, the undersigned, A.R. Jadav, Police Inspector at Songadh Police Station, Tapi, am currently serving as the
        Investigating Officer for Ticket No.: СТТЕСН240325-153914. This case pertains to fraudulent activities that are
        currently under investigation.
        During the course of our investigation, it has been found that the following Instagram ID is suspected to be
        involved in fraudulent communications and financial transactions:

        <div class="letter-body">
            <p>Dear Sir/Madam,</p>
            <p>
                &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;

                I,the undersigned<b><?php echo $policeName; ?></b>, <b><?php echo $policeDesignation; ?></b>,
                <b><?php echo $policeStationName; ?></b>,
                am currently serving as the
                Investigating Officer for <b>Acknowlegement No.: <?php echo $acknowledgement_no;?>.</b> This case
                pertains to fraudulen activities that are currently under investigation.During the course of our
                investigation, it has been found that the following Instagram ID is suspected
                to be involved in fraudulent communications and financial transactions:
                fraud, fake transactions, and deceptive financial activities.<br>
                &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                As per our investigation, the fraudsters have committed offenses under BNS 2023, Section 318(4)
                and Section 66(D) of the Information Technology Act, 2008. In connection with this case, I formally
                request you to provide detailed information on the account(s) involved in these fraudulent
                transactions.
            </p>
        </div>


        <div class="account-table">
            <table class="w3-table-all w3-bordered">
                <thead>
                    <tr>
                        <th>Sr No.</th>
                        <th>Facebook ID</th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    $fbIds = json_decode($data['facebook_id'], true);
    if (!is_array($fbIds)) $fbIds = explode(',', $data['facebook_id']);
    foreach ($fbIds as $i => $fbId) {
    echo "<tr>
        <td>" . ($i+1) . "</td>
        <td>" . htmlspecialchars(trim($fbId)) . "</td>
    </tr>";
    }
                    ?>

                </tbody>
            </table>
        </div>


        <div class="instruction-block">

            Hence, as powers given in BNSS 2023, Section 94 you are instructed that:
            <ol>
                <li>To mandatorily provide beneficiary details of above-mentioned Account.</li>
                <li>Copy (soft copy) of above customer's KYC.</li>
                <li>Date of account opening.</li>
                <li>Complete transaction from accounts opened to <?php echo $currentDate?> date.</li>
                <li>Contact Number of account Holder.</li>
                <li>Detail of Home branch.</li>
            </ol>
            <p>
                So, you are hereby requested to provide beneficiary details of above-mentioned transaction at the
                earliest.<br>
                <b>Thanking You</b>
            </p>
        </div>

        <!-- Signature Wrapper -->
        <div class="signature-container">
            <div class="signature-block">
                <b>
                    (<?php echo strtoupper($policeName); ?>)<br>
                    <?php echo strtoupper($policeDesignation); ?><br>
                    <?php echo strtoupper($policeStationName); ?><br>
                    <?php echo strtoupper($pAddress); ?><br>
                    <?php echo strtoupper($policeNumber); ?>
                </b>
            </div>

        </div>


    </div>

</body>

</html>