<?php
session_start();
include "config.php";

// Redirect if user is not logged in
if (!isset($_SESSION['user'])) {
    echo '<script>window.location.href = "index.php";</script>';
    exit();
}
// Get user details from session
$user = $_SESSION['user'];
$pid = $user['pid'];

//echo "Welcome " . htmlspecialchars($user['name'] ?? 'User') . "<br>";
//echo "Email: " . htmlspecialchars($user['email'] ?? '') . "<br>";
//echo "Phone: " . htmlspecialchars($user['phone'] ?? '') . "<br>";


// Fetch Notice Options
$noticeOptions = "";
$noticeQuery = "SELECT `id`, `n_name` FROM `notice`";
$noticeResult = mysqli_query($con, $noticeQuery);
if ($noticeResult && mysqli_num_rows($noticeResult) > 0) {
    while ($row = mysqli_fetch_assoc($noticeResult)) {
        $noticeOptions .= "<option value='" . htmlspecialchars($row['id']) . "'>" . htmlspecialchars($row['n_name']) . "</option>";
    }
}

// Fetch Subject Options
$subjectOptions = "";
$subjectQuery = "SELECT `id`, `s_name` FROM `subject`";
$subjectResult = mysqli_query($con, $subjectQuery);
if ($subjectResult && mysqli_num_rows($subjectResult) > 0) {
    while ($row = mysqli_fetch_assoc($subjectResult)) {
        $subjectOptions .= "<option value='" . htmlspecialchars($row['id']) . "'>" . htmlspecialchars($row['s_name']) . "</option>";
    }
}


$policeOptions = "";
$policeQuery = "SELECT `id`, `i_name` FROM `police` WHERE pid=$pid";
$policeResult = mysqli_query($con, $policeQuery);
if ($policeResult && mysqli_num_rows($policeResult) > 0) {
    while ($row = mysqli_fetch_assoc($policeResult)) {
        $policeOptions .= "<option value='" . htmlspecialchars($row['id']) . "'>" . htmlspecialchars($row['i_name']) . "</option>";
    }
}



?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <title>Dashboard</title>

    <!-- Main CSS -->
    <link rel="stylesheet" type="text/css" href="css/main.css">

    <!-- Bootstrap Icons -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css">
</head>

<body class="app sidebar-mini">
    <!-- Navbar-->
    <?php include "header.php" ?>
    <!-- Sidebar menu-->
    <div class="app-sidebar__overlay" data-toggle="sidebar"></div>
    <aside class="app-sidebar">

        <?php include "./common/name.php" ?>

        <ul class="app-menu">

            <li><a class="app-menu__item" href="main.php"><i class="app-menu__icon bi bi-speedometer"></i><span
                        class="app-menu__label">Dashboard</span></a>
            </li>

            <li class="treeview"><a class="app-menu__item" data-toggle="treeview"><i
                        class="app-menu__icon bi bi-laptop"></i><span class="app-menu__label">Bank</span><i
                        class="treeview-indicator bi bi-chevron-right"></i></a>
                <ul class="treeview-menu">
                    <li><a class="treeview-item" href="kycform.php"><i class="icon bi bi-circle-fill"></i>KYC</a>
                    </li>
                    <li><a class="treeview-item" href="lien_amount.php"><i class="icon bi bi-circle-fill"></i> LIAN
                            AMOUNT</a></li>
                    <li><a class="treeview-item" href=""><i class="icon bi bi-circle-fill"></i> BOND</a> </li>
                    <li><a class="treeview-item" href=""><i class="icon bi bi-circle-fill"></i> Opinion</a> </li>
                    <li><a class="treeview-item" href=""><i class="icon bi bi-circle-fill"></i> COMPLY ORDER</a> </li>
                    <li><a class="treeview-item" href=""><i class="icon bi bi-circle-fill"></i> CCTV</a> </li>
                </ul>
            </li>

            <li class="treeview"><a class="app-menu__item active" data-toggle="treeview"><i
                        class="app-menu__icon bi bi-laptop"></i><span class="app-menu__label">SOCIAL MEDIA</span><i
                        class="treeview-indicator bi bi-chevron-right"></i></a>
                <ul class="treeview-menu">
                    <li><a class="treeview-item active" href="facebook.php"><i
                                class="icon bi bi-circle-fill"></i>FACEBOOK</a>
                    </li>
                    <li><a class="treeview-item" href=""><i class="icon bi bi-circle-fill"></i>INSTAGRAM</a></li>
                    <li><a class="treeview-item" href=""><i class="icon bi bi-circle-fill"></i> Whatsapp</a> </li>
                    <li><a class="treeview-item" href=""><i class="icon bi bi-circle-fill"></i> X(TWitter)</a> </li>
                    <li><a class="treeview-item" href=""><i class="icon bi bi-circle-fill"></i> Snapchat</a> </li>
                    <li><a class="treeview-item" href=""><i class="icon bi bi-circle-fill"></i> LERS(Google)</a> </li>
                </ul>
            </li>

        </ul>

    </aside>

    <main class="app-content">
        <div class="app-title">
            <div>
                <h1><i class="bi bi-facebook"></i> Facebook</h1>
            </div>
            <ul class="app-breadcrumb breadcrumb">
                <li class="breadcrumb-item"><i class="bi bi-house-door fs-6"></i></li>
                <li class="breadcrumb-item"><a href="#">Dashboard</a></li>
            </ul>
        </div>


        <form method="POST" action="insert_facebook.php">
            <div class="row">
                <div class="col-md-6">
                    <div class="tile">
                        <div class="tile-body">
                            <div class="mb-3">
                                <label class="form-label">Acknowlegement Number / Ticket No.</label>
                                <input class="form-control" type="number" name="acknowledgement_number"
                                    placeholder="Enter Acknowledgement Number">
                            </div>

                            <div class="mb-3">
                                <label class="form-label">Select Fraud Type</label>
                                <select id="fraudTypeSelect" class="form-control" name="fraud_type" required>
                                    <option value="">-- Select Fraud Type --</option>
                                </select>
                            </div>

                            <div class="mb-3">
                                <label class="form-label">Select Notice</label>
                                <select class="form-control" name="notice_id" required>
                                    <option value="">-- Select Notice --</option>
                                    <?= $noticeOptions ?>
                                </select>
                            </div>

                            <div class="mb-3">
                                <label class="form-label">Select Subject</label>
                                <select class="form-control" name="subject_id" required>
                                    <option value="">-- Select Subject --</option>
                                    <?= $subjectOptions ?>
                                </select>
                            </div>

                            <div class="mb-3">
                                <label class="form-label">Select Police</label>
                                <select class="form-control" name="police_id" required>
                                    <option value="">-- Select Police --</option>
                                    <?= $policeOptions ?>
                                </select>
                            </div>


                        </div>

                        <div class="mb-3">
                            <div class="row">
                                <div class="col-9">
                                    <label class="form-label">Facebook ID</label>
                                    <input id="facebookInput" class="form-control" type="text"
                                        placeholder="Enter Facebook ID">
                                </div>
                                <div class="col-3">
                                    <label class="form-label" style="visibility: hidden;">Facebook</label>
                                    <button class="btn btn-primary" type="button" onclick="addFacebook()">
                                        <i class="bi bi-check-circle-fill me-2"></i>Add
                                    </button>
                                </div>
                            </div>
                        </div>

                        <!-- Hidden field to hold all Instagram IDs -->
                        <input type="hidden" name="facebook_ids" id="facebook_ids">

                        <div class="tile-footer">
                            <button class="btn btn-primary" type="submit"><i
                                    class="bi bi-check-circle-fill me-2"></i>Submit</button>&nbsp;&nbsp;&nbsp;<a
                                class="btn btn-secondary" href="#"><i class="bi bi-x-circle-fill me-2"></i>Cancel</a>
                        </div>


                    </div>

                </div>

                <div class="col-md-6">
                    <div class="tile">
                        <div class="tile-body">
                            <div class="table-responsive">
                                <table class="table table-hover table-bordered" id="sampleTable">
                                    <thead>
                                        <tr>
                                            <th>ID</th>
                                            <th>FACEBOOK ID</th>
                                            <th>DELETE</th>
                                        </tr>
                                    </thead>
                                    <tbody id="facebookTableBody"></tbody>

                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            </div>

        </form>




    </main>
    <!-- Essential javascripts for application to work-->
    <script src="js/jquery-3.7.0.min.js"></script>
    <script src="js/bootstrap.min.js"></script>
    <script src="js/main.js"></script>
    <!-- Page specific javascripts-->
    <script type="text/javascript" src="https://cdn.jsdelivr.net/npm/echarts@5.4.3/dist/echarts.min.js"></script>

    <script>
    let idCounter = 1;
    const facebookIds = [];

    function addFacebook() {
        const input = document.getElementById("facebookInput");
        const value = input.value.trim();
        const hiddenField = document.getElementById("facebook_ids");

        if (value === "") {
            alert("Please enter a Facebook ID.");
            return;
        }

        facebookIds.push(value);
        hiddenField.value = JSON.stringify(facebookIds);

        const tableBody = document.getElementById("facebookTableBody");
        const newRow = document.createElement("tr");
        newRow.innerHTML = `
            <td>${idCounter++}</td>
            <td>${value}</td>
            <td><button class="btn btn-danger btn-sm" onclick="deleteRow(this, '${value}')">Delete</button></td>
        `;
        tableBody.appendChild(newRow);
        input.value = "";
    }

    function deleteRow(button, value) {
        const row = button.closest("tr");
        row.remove();
        const index = facebookIds.indexOf(value);
        if (index !== -1) facebookIds.splice(index, 1);
        document.getElementById("facebook_ids").value = JSON.stringify(facebookIds);
    }
    </script>


    <script>
    const fraudTypes = [{
            value: "identity_theft",
            label: "Identity Theft"
        },
        {
            value: "cyber_fraud",
            label: "Cyber Fraud"
        },
        {
            value: "financial_fraud",
            label: "Financial Fraud"
        },
        {
            value: "atm_skimming",
            label: "ATM Skimming"
        },
        {
            value: "phishing",
            label: "Phishing"
        },
        {
            value: "social_media_fraud",
            label: "Social Media Fraud"
        },
        {
            value: "fake_account",
            label: "Fake Account"
        }, // ✅ Added here
        {
            value: "other",
            label: "Other"
        }
    ];

    const fraudTypeSelect = document.getElementById("fraudTypeSelect");

    fraudTypes.forEach(type => {
        const option = document.createElement("option");
        option.value = type.value;
        option.textContent = type.label;
        fraudTypeSelect.appendChild(option);
    });

    fraudTypeSelect.addEventListener("change", function() {
        const selected = this.value;

    });
    </script>


</body>

</html>