<?php
session_start();
include "config.php";

// Redirect if user is not logged in
if (!isset($_SESSION['user'])) {
    header("Location: index.php");
    exit();
}

// Get user details from session
$user = $_SESSION['user'];

//echo "Welcome " . htmlspecialchars($user['name'] ?? 'User') . "<br>";
//echo "Email: " . htmlspecialchars($user['email'] ?? '') . "<br>";
//echo "Phone: " . htmlspecialchars($user['phone'] ?? '') . "<br>";

// Fetch all users
$noticeQuery = "SELECT * FROM `notice`";
$resultNotice = mysqli_query($con, $noticeQuery);


$policeStationQuery = "SELECT * FROM `policestation` WHERE id='{$user['pid']}'";
$resultPoliceStation = mysqli_query($con, $policeStationQuery);

$policeQuery = "SELECT * FROM `police` WHERE pid = '{$user['pid']}'";
$resultPolice = mysqli_query($con, $policeQuery);

//$policeQuery = "SELECT * FROM `policestation` WHERE id='{$user['pid']}'";
//$resultPolice = mysqli_query($con, $policeQuery);

$subjectQuery = "SELECT * FROM `subject` WHERE `s_name` LIKE '%kyc%'";
$resultSubject = mysqli_query($con, $subjectQuery);

$noticeQuery = "SELECT * FROM `notice` WHERE `n_name` LIKE '%94%'";
$resultNotice = mysqli_query($con, $noticeQuery);


$bankQuery = "SELECT * FROM `bank`";
$resultBank = mysqli_query($con, $bankQuery);
$resultBank2 = mysqli_query($con, $bankQuery);
?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <title>KYC</title>

    <!-- Main CSS -->
    <link rel="stylesheet" type="text/css" href="css/main.css">

    <!-- Bootstrap Icons -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css">
</head>

<body class="app sidebar-mini">
    <!-- Navbar-->

    <!-- Navbar-->
    <?php include "header.php" ?>
    <!-- Sidebar menu-->
    <div class="app-sidebar__overlay" data-toggle="sidebar"></div>
    <aside class="app-sidebar">

        <?php include "./common/name.php" ?>

        <ul class="app-menu">

            <li><a class="app-menu__item  " href="main.php"><i class="app-menu__icon bi bi-speedometer"></i><span
                        class="app-menu__label">Dashboard</span></a>
            </li>

            <li class="treeview"><a class="app-menu__item active" data-toggle="treeview"><i
                        class="app-menu__icon bi bi-laptop"></i><span class="app-menu__label">Bank</span><i
                        class="treeview-indicator bi bi-chevron-right"></i></a>
                <ul class="treeview-menu">
                    <li><a class="treeview-item " href="kycform.php"><i class="icon bi bi-circle-fill"></i>KYC</a>
                    </li>
                    <li><a class="treeview-item" href="lien_amount.php"><i class="icon bi bi-circle-fill"></i>
                            LIAN
                            AMOUNT</a></li>
                    <li><a class="treeview-item active" href="comply_order.php"><i class="icon bi bi-circle-fill"></i>
                            COMPLY
                            ORDER</a> </li>
                    <li><a class="treeview-item" href="cctv.php"><i class="icon bi bi-circle-fill"></i> CCTV</a> </li>
                </ul>
            </li>

        </ul>

    </aside>


    <main class="app-content">
        <div class="app-title">
            <div>
                <h1>Comply Order</h1>
            </div>
            <ul class="app-breadcrumb breadcrumb side">
                <li class="breadcrumb-item"><i class="bi bi-house-door fs-6"></i></li>
                <li class="breadcrumb-item">Bank</li>
                <li class="breadcrumb-item active"><a href="#">Comply Order</a></li>
            </ul>
        </div>

        <form method="POST" action="comply_order_form.php">
            <div class="text-end mb-3">
                <button type="submit" class="btn btn-success">Submit FORM</button>
            </div>

            <div class="row">
                <div class="col-md-6">
                    <div class="tile">
                        <div class="tile-body">



                            <div class="mb-3">
                                <label class="form-label">Acknowledgement No.</label>
                                <input class="form-control" type="number" name="ack_no"
                                    placeholder="Enter Acknowledgement No." required>
                            </div>

                            <div class="mb-3">
                                <label class="form-label">Court Order</label>
                                <input class="form-control" type="text" name="court_order"
                                    placeholder="Enter Court Order" required>
                            </div>




                            <div class="mb-3" style="display: none;">
                                <label class="form-label">Select Police Station</label>
                                <select class="form-control" name="policestation_id" id="policestation_id" required>
                                    <?php while ($row = mysqli_fetch_assoc($resultPoliceStation)) { ?>
                                    <option value="<?php echo $row['id']; ?>">
                                        <?php echo htmlspecialchars($row['p_name']); ?>
                                    </option>
                                    <?php } ?>
                                </select>
                            </div>


                            <div class="mb-3">
                                <label class="form-label">Select Police</label>
                                <select class="form-control" name="police_id" id="police_id" required>
                                    <option value="">-- Select Police --</option>
                                    <?php
                                            while ($row = mysqli_fetch_assoc($resultPolice)) {
                                                echo '<option value="' . $row['id'] . '">' . htmlspecialchars($row['i_name']) . '</option>';
                                                            }
                                                                        ?>
                                </select>
                            </div>


                            <div class="mb-3" style="display: none;">
                                <label class="form-label">Select Subject</label>
                                <select class="form-control" name="subject_id" required>
                                    <?php while ($row = mysqli_fetch_assoc($resultSubject)) { ?>
                                    <option value="<?php echo $row['id']; ?>">
                                        <?php echo htmlspecialchars($row['s_name']); ?>
                                    </option>
                                    <?php } ?>
                                </select>
                            </div>


                            <div class="mb-3">
                                <label class="form-label">Victim Select Bank</label>
                                <select class="form-control" name="victim_bank_id" id="bank_id_2" required>
                                    <option value="">-- Victim Bank --</option>
                                    <?php while ($row = mysqli_fetch_assoc($resultBank)) { ?>
                                    <option value="<?php echo $row['id']; ?>"
                                        data-name="<?php echo htmlspecialchars($row['b_name']); ?>">
                                        <?php echo htmlspecialchars($row['b_name']); ?>
                                    </option>
                                    <?php } ?>
                                </select>
                            </div>

                            <div class="mb-3">
                                <label class="form-label">Victim Name</label>
                                <input class="form-control" type="text" name="v_name" placeholder="Enter Complainant"
                                    required>
                            </div>


                            <div class="mb-3">
                                <label class="form-label">Victim Bank Ac no</label>
                                <input class="form-control" type="text" name="victim_account_no"
                                    placeholder="Enter Complainant" required>
                            </div>

                            <div class="mb-3">
                                <label class="form-label">Victim Bank IFSC</label>
                                <input class="form-control" type="text" name="victim_ifsc"
                                    placeholder="Enter Complainant" required>
                            </div>



                        </div>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="tile">
                        <div class="tile-body">

                            <!-- BANK FIELDS -->
                            <div id="bank-form">
                                <div class="mb-3">
                                    <label class="form-label">Select Bank</label>
                                    <select class="form-control" id="bank_id">
                                        <option value="">-- Select Bank --</option>
                                        <?php while ($row = mysqli_fetch_assoc($resultBank2)) { ?>
                                        <option value="<?php echo $row['id']; ?>"
                                            data-name="<?php echo htmlspecialchars($row['b_name']); ?>">
                                            <?php echo htmlspecialchars($row['b_name']); ?>
                                        </option>
                                        <?php } ?>
                                    </select>
                                </div>


                                <div class="mb-3">
                                    <label class="form-label">Account Number</label>
                                    <input class="form-control" type="text" id="account_number"
                                        placeholder="Enter Account Number">
                                </div>

                                <div class="mb-3">
                                    <label class="form-label">IFSC Code</label>
                                    <input class="form-control" type="text" id="ifsc_code"
                                        placeholder="Enter IFSC Code">
                                </div>

                                <div class="mb-3">
                                    <label class="form-label">Account Holder Name</label>
                                    <input class="form-control" type="text" id="account_holder"
                                        placeholder="Enter Account Holder Name">
                                </div>


                                <div class="mb-3">
                                    <label class="form-label">Release AMOUNT</label>
                                    <input class="form-control" type="number" id="account_release_amount"
                                        placeholder="Enter Release Amount">
                                </div>

                            </div>

                            <div class="text-end mb-3">
                                <button type="button" class="btn btn-primary btn-sm" onclick="addBank()">Add Bank
                                    Data</button>
                            </div>

                            <!-- Display added bank accounts -->


                        </div>
                    </div>
                </div>


                <div class="row">
                    <div class="col-md-12">
                        <div class="tile">
                            <div class="tile-body">

                                <h5 class="mt-3">Added Bank Accounts:</h5>
                                <div class="col-md-12">
                                    <div class="tile">
                                        <table class="table" id="bank-table">
                                            <thead>
                                                <tr>
                                                    <th>Bank Name</th>
                                                    <th>Account Number</th>
                                                    <th>IFSC Code</th>
                                                    <th>Account Holder</th>
                                                    <th>Release Amount</th>
                                                    <th>Delete</th>
                                                </tr>
                                            </thead>
                                            <tbody></tbody>
                                        </table>

                                        <!-- Hidden input to store final JSON (optional for form submission) -->
                                        <input type="hidden" name="bank_accounts_json" id="bank_accounts_json">

                                    </div>
                                </div>

                            </div>
                        </div>
                    </div>

                </div>
            </div>

        </form>



    </main>
    <!-- Essential javascripts for application to work-->
    <script src="js/jquery-3.7.0.min.js"></script>
    <script src="js/bootstrap.min.js"></script>
    <script src="js/main.js"></script>
    <!-- Page specific javascripts-->
    <link rel="stylesheet" href="https://cdn.datatables.net/v/bs5/dt-1.13.4/datatables.min.css">
    <!-- Data table plugin-->
    <script type="text/javascript" src="js/plugins/jquery.dataTables.min.js"></script>
    <script type="text/javascript" src="js/plugins/dataTables.bootstrap.min.js"></script>
    <script type="text/javascript">
    $('#bank-table').DataTable();
    </script>
    <!-- Google analytics script-->


    <script>
    const bankAccounts = [];

    function addBank() {
        const bankSelect = document.getElementById('bank_id');
        const accountNumber = document.getElementById('account_number').value.trim();
        const ifscCode = document.getElementById('ifsc_code').value.trim();
        const accountHolder = document.getElementById('account_holder').value.trim();
        const releaseAmount = document.getElementById('account_release_amount').value.trim();

        const bankId = bankSelect.value;
        const bankName = bankSelect.options[bankSelect.selectedIndex]?.getAttribute('data-name') || '';

        if (!bankId || !accountNumber || !ifscCode || !accountHolder || !releaseAmount) {
            alert("Please fill all bank details before adding.");
            return;
        }

        // Add to array
        const accountData = {
            bank_id: bankId,
            bank_name: bankName,
            account_number: accountNumber,
            ifsc_code: ifscCode,
            account_holder: accountHolder,
            release_amount: releaseAmount
        };

        bankAccounts.push(accountData);
        updateBankTable();
        updateHiddenField();

        // Clear form
        document.getElementById('account_number').value = '';
        document.getElementById('ifsc_code').value = '';
        document.getElementById('account_holder').value = '';
        document.getElementById('account_release_amount').value = '';
        document.getElementById('bank_id').selectedIndex = 0;
    }

    function updateBankTable() {
        const tbody = document.querySelector('#bank-table tbody');
        tbody.innerHTML = '';

        bankAccounts.forEach((account, index) => {
            const row = document.createElement('tr');

            row.innerHTML = `
                <td>${account.bank_name}</td>
                <td>${account.account_number}</td>
                <td>${account.ifsc_code}</td>
                <td>${account.account_holder}</td>
                <td>${account.release_amount}</td>
                <td><button type="button" class="btn btn-danger btn-sm" onclick="removeBank(${index})">Delete</button></td>
            `;

            tbody.appendChild(row);
        });
    }

    function removeBank(index) {
        bankAccounts.splice(index, 1);
        updateBankTable();
        updateHiddenField();
    }

    function updateHiddenField() {
        document.getElementById('bank_accounts_json').value = JSON.stringify(bankAccounts);
    }
    </script>


    <script>
    document.getElementById('policestation_id').addEventListener('change', function() {
        var stationId = this.value;
        var policeDropdown = document.getElementById('police_id');
        policeDropdown.innerHTML = '<option value="">Loading...</option>';

        fetch('get_police_by_station.php?station_id=' + stationId)
            .then(response => response.json())
            .then(data => {
                console.log('Fetched Police Data:', data); // 👈 This prints data to the console
                policeDropdown.innerHTML = '<option value="">-- Select Police --</option>';
                data.forEach(function(police) {
                    var option = document.createElement('option');
                    option.value = police.id;
                    option.text = police.i_name;
                    policeDropdown.appendChild(option);
                });
            })
            .catch(error => console.error('Error fetching police data:', error));
    });
    </script>


</body>

</html>